/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetContent
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(GetContent.class);

    public GetContent() {
    }

    public GetContent(IHandlerConfiguration conf) {
        super(conf);
    }

    @Override
    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        WorkflowMessage responseMsg = WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
        String url = (String)requestMsg.getParameterValue("url");
        logger.debug((Object)("Metadata file " + url));
        String contenturl = this.getContent(url, this.getAsset());
        if (contenturl != null && !contenturl.isEmpty()) {
            if (this.isURL(contenturl)) {
                responseMsg.putValue("content", contenturl);
            } else {
                responseMsg.putValue("content", FilenameUtils.getFullPath((String)url) + contenturl);
            }
            logger.debug((Object)("URL " + (String)requestMsg.getParameterValue("content")));
        } else {
            responseMsg.putValue("content", "");
        }
        return responseMsg;
    }

    private boolean isURL(String location) {
        boolean isurl = false;
        try {
            new URL(location);
            isurl = true;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isurl;
    }

    protected String getAsset() {
        return this.getConfiguration().getParameterValue("asset");
    }

    protected String getContent(String path, String asset) throws Exception {
        Document document = DocumentUtility.newInstance().getDocument(path);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate("//AMS[@Asset_Class='" + asset + "']", document, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        Node assetNode = node.getParentNode().getParentNode();
        return (String)xpath.evaluate("Content/@Value", assetNode, XPathConstants.STRING);
    }
}

