/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReadFieldValue
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(ReadFieldValue.class);

    public ReadFieldValue() {
    }

    public ReadFieldValue(IHandlerConfiguration conf) {
        super(conf);
    }

    protected String getValue(String path, String asset, String field) throws Exception {
        Document document = DocumentUtility.newInstance().getDocument(path);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node assetNode = (Node)xpath.evaluate("//AMS[@Asset_Class='" + asset + "']", document, XPathConstants.NODE);
        if (assetNode == null) {
            return null;
        }
        logger.debug((Object)("assetNode=" + assetNode.getTextContent()));
        Node metadataNode = assetNode.getParentNode();
        Element appDataNode = (Element)xpath.evaluate("//App_Data[@Name='" + field + "']", metadataNode, XPathConstants.NODE);
        if (appDataNode != null) {
            logger.debug((Object)("appData value = " + appDataNode.getAttribute("Value")));
            return appDataNode.getAttribute("Value");
        }
        logger.debug((Object)"appData value = ");
        return "";
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
        String url = (String)requestMsg.getParameterValue("url");
        String assetClassValue = (String)requestMsg.getParameterValue("assetClass");
        String fieldValue = (String)requestMsg.getParameterValue("fieldName");
        logger.debug((Object)("Metadata file: " + url));
        logger.debug((Object)("assetClass: " + assetClassValue));
        logger.debug((Object)("fieldName: " + fieldValue));
        response.putValue("fieldValue", this.getValue(url, assetClassValue, fieldValue));
        return response;
    }
}

