/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RemoveAsset
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(RemoveAsset.class);

    public RemoveAsset() {
    }

    public RemoveAsset(IHandlerConfiguration conf) {
        super(conf);
    }

    protected void removeAsset(Document document) throws XPathException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String asset = this.getAsset();
        Node node = (Node)xpath.evaluate("//AMS[@Asset_Class='" + asset + "']", document, XPathConstants.NODE);
        if (node == null) {
            return;
        }
        Node disappear = node.getParentNode().getParentNode();
        disappear.getParentNode().removeChild(disappear);
    }

    protected String getAsset() {
        return this.getConfiguration().getParameterValue("asset");
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        String url = (String)requestMsg.getParameterValue("url");
        logger.debug((Object)("Metadata file " + url));
        Document document = DocumentUtility.newInstance().getDocument(url);
        this.removeAsset(document);
        DocumentUtility.newInstance().write(document, url);
        return WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
    }
}

