/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SetAssetIdPrefix
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(SetAssetIdPrefix.class);

    public SetAssetIdPrefix() {
    }

    public SetAssetIdPrefix(IHandlerConfiguration conf) {
        super(conf);
    }

    private String generate(Document document, String prefix) throws XPathExpressionException {
        String id = this.update(document, "//Metadata/AMS[@Asset_Class='package']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='title']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='movie']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='poster']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='preview']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='box cover']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='barker']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='encrypted']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='trickfile']/@Asset_ID", prefix);
        return id;
    }

    protected String update(Document document, String path, String value) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(path, document, XPathConstants.NODE);
        String id = "";
        if (node == null) {
            return null;
        }
        id = node.getTextContent().isEmpty() || node.getTextContent().length() <= 4 ? node.getTextContent() : value + node.getTextContent().substring(value.length());
        node.setTextContent(id);
        return id;
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
        String url = (String)requestMsg.getParameterValue("url");
        String prefix = (String)requestMsg.getParameterValue("prefix");
        logger.debug((Object)("Metadata file " + url));
        Document document = DocumentUtility.newInstance().getDocument(url);
        if (prefix.length() > 4) {
            response.putValue("error-message", "Prefix cannot be longer than 4 characters");
        } else {
            String id = this.generate(document, prefix);
            if (id.isEmpty()) {
                response.putValue("error-message", "Asset id cannot be prefixed as it is empty or less then 4 characters");
            } else {
                DocumentUtility.newInstance().write(document, url);
                response.putValue("packageAssetId", id);
            }
        }
        return response;
    }
}

