/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SetPackageNameSuffix
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(SetPackageNameSuffix.class);

    public SetPackageNameSuffix() {
    }

    public SetPackageNameSuffix(IHandlerConfiguration conf) {
        super(conf);
    }

    private String generate(Document document, String baseName, String suffix) throws XPathExpressionException {
        return this.update(document, "//Metadata/AMS[@Asset_Class='package']/@Asset_Name", baseName, suffix);
    }

    protected String update(Document document, String path, String baseName, String suffix) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(path, document, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        String packageName = baseName + "_" + suffix;
        node.setTextContent(packageName);
        return packageName;
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
        String url = (String)requestMsg.getParameterValue("url");
        String suffix = (String)requestMsg.getParameterValue("suffix");
        String baseName = (String)requestMsg.getParameterValue("baseName");
        logger.debug((Object)("Metadata file " + url));
        Document document = DocumentUtility.newInstance().getDocument(url);
        String packageName = this.generate(document, baseName, suffix);
        DocumentUtility.newInstance().write(document, url);
        response.putValue("packageName", packageName);
        return response;
    }
}

