/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetProduct
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(SetProduct.class);

    public SetProduct() {
    }

    public SetProduct(IHandlerConfiguration conf) {
        super(conf);
    }

    private void setProduct(Document document, String product) throws XPathException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//AMS/@Product", document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            node.setTextContent(product);
        }
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        String url = (String)requestMsg.getParameterValue("url");
        String product = (String)requestMsg.getParameterValue("product");
        logger.debug((Object)("Metadata file " + url));
        Document document = DocumentUtility.newInstance().getDocument(url);
        this.setProduct(document, product);
        DocumentUtility.newInstance().write(document, url);
        return WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
    }
}

