/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.device.cablelabs11.metadata.AbstractMetadataParserHandler;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WriteAppDataField
extends AbstractMetadataParserHandler {
    private static final Logger logger = Logger.getLogger(WriteAppDataField.class);
    private static final String ASSET_CLASS = "Asset_Class";
    private static final String APP_DATA_VALUE = "Value";

    public WriteAppDataField() {
    }

    public WriteAppDataField(IHandlerConfiguration conf) {
        super(conf);
    }

    protected void setAttributeValue(String expression, String attribute, Node node, String value) {
        if (node != null) {
            node.getAttributes().getNamedItem(attribute).setTextContent(value);
        }
    }

    protected String getValue(String path) throws Exception {
        Document document = DocumentUtility.newInstance().getDocument(path);
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (String)xpath.evaluate(this.getXPath(), document, XPathConstants.STRING);
    }

    protected String getXPath() {
        return this.getConfiguration().getParameterValue("xpath");
    }

    @Override
    protected WorkflowMessage performOperation(WorkflowMessage requestMsg) throws Exception {
        String url = (String)requestMsg.getParameterValue("url");
        String name = this.getConfiguration().getParameterValue("name");
        String value = (String)requestMsg.getParameterValue(name);
        String assetClass = this.getConfiguration().getParameterValue("assetClass");
        Document document = DocumentUtility.newInstance().getDocument(url);
        NodeList metadataNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//Metadata", document, XPathConstants.NODESET);
        for (int i = 0; i < metadataNodes.getLength(); ++i) {
            Node metadataNode = metadataNodes.item(i);
            Node amsNode = (Node)XPathFactory.newInstance().newXPath().evaluate("AMS", metadataNode, XPathConstants.NODE);
            if (!amsNode.getAttributes().getNamedItem(ASSET_CLASS).getTextContent().equals(assetClass)) continue;
            Node appDataNode = (Node)XPathFactory.newInstance().newXPath().evaluate(this.getXPath(), metadataNode, XPathConstants.NODE);
            if (appDataNode == null) break;
            appDataNode.getAttributes().getNamedItem(APP_DATA_VALUE).setTextContent(value);
            break;
        }
        DocumentUtility.newInstance().write(document, url);
        return WorkflowMessageFactory.createAckMessage((WorkflowMessage)requestMsg);
    }
}

