/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.actions.snapshot;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class InitializeGenerateSnapShotImageTemplate
implements ActionHandler {
    private static final long serialVersionUID = 4526472295622776348L;

    public void execute(ExecutionContext context) throws Exception {
        long tokenId = context.getToken().getId();
        long processId = context.getProcessInstance().getId();
        String videoFullPath = context.getVariable("videoFilePath").toString();
        int lastIndexOfFileSeparator = videoFullPath.lastIndexOf("/");
        if (lastIndexOfFileSeparator < 0) {
            lastIndexOfFileSeparator = videoFullPath.lastIndexOf("\\");
        }
        String videoFileName = lastIndexOfFileSeparator < 0 ? videoFullPath : videoFullPath.substring(lastIndexOfFileSeparator + 1);
        int indexOfFileExtension = videoFileName.lastIndexOf(".");
        String fileName = indexOfFileExtension < 0 ? videoFileName : videoFileName.substring(0, indexOfFileExtension);
        String basePath = "/content/derived";
        String providerId = context.getVariable("providerId").toString();
        String imageFolder = this.getImageFolder(basePath, providerId);
        String imageFullPath = imageFolder + fileName + "-1.jpg";
        context.setVariable("imageFolder", (Object)imageFolder);
        context.setVariable("numOfFrames", (Object)"1");
        context.setVariable("numOfFramesPerSec", (Object)"1");
        context.setVariable("imageFilePath", (Object)imageFullPath);
        context.setVariable("tokenId", (Object)Long.toString(tokenId));
        context.setVariable("processId", (Object)Long.toString(processId));
    }

    String getImageFolder(String basePath, String providerId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String timeStamp = format.format(new Date());
        String imageFolder = basePath + "/" + providerId + "/" + timeStamp + "/";
        return imageFolder;
    }
}

