/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.actions.target;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class UpdateTargetingTemplateLoopVariables
implements ActionHandler {
    private static final long serialVersionUID = 4860895485280005433L;
    private static final Logger logger = Logger.getLogger(UpdateTargetingTemplateLoopVariables.class);

    public void execute(ExecutionContext context) throws IOException {
        List<Object> siteIdsList = new ArrayList();
        String siteIds = this.getStringValue(context, "siteIds");
        logger.debug((Object)("siteIds=" + siteIds));
        if (siteIds != null) {
            siteIdsList = this.convertCommaSepListtoList(siteIds);
        }
        int loopIndex = this.getIntegerValue(context, "siteIndex", -1) + 1;
        String siteId = ((String)siteIdsList.get(loopIndex)).trim();
        boolean hasMoreSites = loopIndex + 1 < siteIdsList.size();
        logger.debug((Object)("siteId=" + siteId + "."));
        context.setVariable("siteId", (Object)siteId);
        context.setVariable("hasMoreSites", (Object)hasMoreSites);
        context.setVariable("siteIndex", (Object)loopIndex);
        context.setVariable("siteCount", (Object)new Integer(siteIdsList.size()));
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private int getIntegerValue(ExecutionContext context, String variableName, int defaultValue) {
        int intValue = defaultValue;
        Object value = context.getVariable(variableName);
        if (value == null) {
            intValue = defaultValue;
        } else if (value instanceof Integer) {
            intValue = (Integer)value;
        } else {
            try {
                intValue = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Failed to parse value: " + value + " to an integer when getting Site Loop Index, using default value: " + defaultValue), (Throwable)e);
            }
        }
        return intValue;
    }
}

