/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.commons;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public abstract class AbstractEventHandler
implements IColleague {
    protected WorkflowProcessEventType[] eventTypes;
    protected ISchedulerService<Void> schedulerService;

    protected AbstractEventHandler(String schedulerName, int size, int max) {
        this.schedulerService = new Scheduler(schedulerName, size, max);
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    protected boolean isEventTypeToBeHandled(WorkflowProcessEventType type) {
        for (WorkflowProcessEventType et : this.eventTypes) {
            if (et != type) continue;
            return true;
        }
        return false;
    }

    protected boolean isSubprocess(WorkflowProcess process) {
        return process.getSuperProcessToken() != null;
    }

    protected boolean isDistributionTemplate(WorkflowProcess process) {
        return this.isTemplateWithCategory(process, "Distribution");
    }

    protected boolean isContentProcessingTemplate(WorkflowProcess process) {
        return this.isTemplateWithCategory(process, "ContentProcessing");
    }

    private boolean isTemplateWithCategory(WorkflowProcess process, String annotationName) {
        WorkflowTemplate template = process.getProcessDefinition();
        for (String annotation : template.getAnnotations("Category")) {
            if (!annotation.contains("\"" + annotationName + "\"")) continue;
            return true;
        }
        return false;
    }

    protected boolean isBranchedProcess(Token token) {
        CustomToken customToken = (CustomToken)token;
        return customToken.hasParent() && customToken.getParent().getStatus() == ProcessStatus.BRANCHED && customToken.getStatus() != ProcessStatus.ERROR;
    }

    protected String getTitleId(WorkflowProcess process) {
        ContextInstance contextInstance = process.getContextInstance();
        return (String)contextInstance.getVariable("titleId");
    }

    protected boolean isTitleIdValid(String titleId) {
        return null != titleId && !titleId.isEmpty();
    }
}

