/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.distributionretryhandler;

import com.tandbergtv.cms.workflow.eventhandler.commons.AbstractEventHandler;
import com.tandbergtv.cms.workflow.eventhandler.distributionretryhandler.DistributionRetryNotificationTask;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class DistributionRetryHandler
extends AbstractEventHandler {
    private static final Logger LOGGER = Logger.getLogger(DistributionRetryHandler.class);
    private static final String PATH = "%s/workorderid/%s/eventtype/%s";

    public DistributionRetryHandler() {
        super("DistributionRetryScheduler", 1, 2);
        this.eventTypes = new WorkflowProcessEventType[]{WorkflowProcessEventType.FAILED, WorkflowProcessEventType.CANCELLED};
    }

    public String getColleagueName() {
        return "Distribution Retry Handler";
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof WorkflowProcessEvent)) {
            return;
        }
        WorkflowProcessEvent processEvent = (WorkflowProcessEvent)event;
        WorkflowProcessEventType eventType = processEvent.getType();
        WorkflowProcess process = processEvent.getProcess();
        long processId = process.getId();
        LOGGER.debug((Object)("DistributionRetryHandler receives Event: " + eventType + ", workorder id: " + processId));
        if (!this.isEventTypeToBeHandled(eventType)) {
            LOGGER.debug((Object)("DistributionRetryHandler doesn't handle event: " + eventType + ", workorder id: " + processId));
            return;
        }
        if (!this.isDistributionTemplate(process)) {
            LOGGER.debug((Object)("DistributionRetryHandler doesn't handle non-distribution template, workorder id: " + processId));
            return;
        }
        if (this.isBranchedProcess(processEvent.getToken())) {
            LOGGER.debug((Object)("DistributionRetryHandler doesn't handle branched process, workorder id: " + processId));
            return;
        }
        if (this.isSubprocess(process)) {
            LOGGER.debug((Object)("DistributionRetryHandler doesn't handle subprocess, workorder id: " + processId));
            return;
        }
        String titleId = this.getTitleId(process);
        if (!this.isTitleIdValid(titleId)) {
            LOGGER.debug((Object)("DistributionRetryHandler doesn't handle invalid title id, workorder id: " + processId));
            return;
        }
        String requestUrl = this.buildRequestUrl(eventType, processId, titleId);
        this.schedulerService.schedule((Callable)DistributionRetryNotificationTask.newInstance(requestUrl));
    }

    private String buildRequestUrl(WorkflowProcessEventType eventType, long processId, String titleId) {
        return String.format(PATH, titleId, processId, eventType);
    }
}

