/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.distributionretryhandler;

import com.ericsson.neptune.configuration.settings.client.NeptuneClient;
import com.tandbergtv.cms.workflow.eventhandler.utils.Util;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class DistributionRetryNotificationTask
implements Callable<Void> {
    private static final Logger LOGGER = Logger.getLogger(DistributionRetryNotificationTask.class);
    private static final String NUMBER_OF_RETRIES = "distribution_retry_notification_retries";
    private static final String NUMBER_OF_RETRIES_INTERVAL = "distribution_retry_notification_retries_interval";
    private static final int RETRY_NUMBER = Util.getProperty("distribution_retry_notification_retries", 1);
    private static final long RETRY_INTERVAL = Util.getProperty("distribution_retry_notification_retries_interval", 10) * 1000;
    private String url;

    private DistributionRetryNotificationTask(String url) {
        this.url = url;
    }

    @Override
    public Void call() {
        this.sendRequest(this.url);
        return null;
    }

    private void sendRequest(String url) {
        int toDo = RETRY_NUMBER;
        NeptuneClient client = new NeptuneClient(NeptuneClient.Route.TITLE_SERVICE, new String[]{url});
        while (toDo > 0) {
            try {
                client.invoke(Void.class, "");
                return;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception occurs when calling REST API.", (Throwable)e);
                toDo = this.isTransient(e) ? --toDo : 0;
                this.waitForRetry();
            }
        }
        LOGGER.warn((Object)"Fail to call REST API.");
    }

    private boolean isTransient(Exception ex) {
        return ex instanceof IOException;
    }

    private void waitForRetry() {
        Util.sleep(RETRY_INTERVAL);
    }

    public static DistributionRetryNotificationTask newInstance(String url) {
        return new DistributionRetryNotificationTask(url);
    }
}

