/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.cms.workflow.eventhandler.commons.AbstractEventHandler;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.AwaitingTitleProcessingStatusCache;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.TitleProcessingStatusUpdateTask;
import com.tandbergtv.cms.workflow.eventhandler.utils.Util;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import org.apache.log4j.Logger;

public class AggregatedTitleProcessHandler
extends AbstractEventHandler {
    private static final Logger LOGGER = Logger.getLogger(AggregatedTitleProcessHandler.class);
    private static final String NUMBER_OF_INTERVAL = "title_processing_status_update_interval";
    private static final long INTERVAL = Util.getProperty("title_processing_status_update_interval", 15) * 1000;
    private IClusterService hzcs;
    private AwaitingTitleProcessingStatusCache cache;
    private boolean hasStartedScheduler;

    public AggregatedTitleProcessHandler() {
        super("AggregatedTitleProcessScheduler", 1, 1);
        this.eventTypes = new WorkflowProcessEventType[]{WorkflowProcessEventType.STARTED, WorkflowProcessEventType.FAILED, WorkflowProcessEventType.CANCELLED, WorkflowProcessEventType.STOPPED, WorkflowProcessEventType.RESUMED, WorkflowProcessEventType.DELETED};
        this.initClusterService();
        this.cache = AwaitingTitleProcessingStatusCache.getInstance();
        this.hasStartedScheduler = false;
        if (this.hzcs.isMaster()) {
            LOGGER.debug((Object)"Local member node is master.");
            this.startScheduler();
        }
        this.registerHazelCastMembershipListener();
    }

    private void initClusterService() {
        this.hzcs = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
    }

    private void registerHazelCastMembershipListener() {
        this.hzcs.getInstance().getCluster().addMembershipListener((MembershipListener)new HazelCastMembershipListener());
    }

    private void startScheduler() {
        if (!this.hasStartedScheduler) {
            this.schedulerService.schedule((Runnable)TitleProcessingStatusUpdateTask.getInstance(), 0L, INTERVAL);
            this.hasStartedScheduler = true;
            LOGGER.debug((Object)"Local member node starts title processing status update task.");
        }
    }

    public String getColleagueName() {
        return "Aggregated Title Process Handler";
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof WorkflowProcessEvent)) {
            return;
        }
        WorkflowProcessEvent processEvent = (WorkflowProcessEvent)event;
        WorkflowProcessEventType eventType = processEvent.getType();
        WorkflowProcess process = processEvent.getProcess();
        long processId = process.getId();
        LOGGER.debug((Object)("AggregatedTitleProcessHandler receives Event: " + eventType + ", workorder id: " + processId));
        if (!this.isEventTypeToBeHandled(eventType)) {
            LOGGER.debug((Object)("AggregatedTitleProcessHandler doesn't handle event: " + eventType + ", workorder id: " + processId));
            return;
        }
        if (this.isDistributionTemplate(process) && !this.isContentProcessingTemplate(process)) {
            LOGGER.debug((Object)("AggregatedTitleProcessHandler doesn't handle distribution template, workorder id: " + processId));
            return;
        }
        if (this.isBranchedProcess(processEvent.getToken())) {
            LOGGER.debug((Object)("AggregatedTitleProcessHandler doesn't handle branched process, workorder id: " + processId));
            return;
        }
        if (this.isSubprocess(process)) {
            LOGGER.debug((Object)("AggregatedTitleProcessHandler doesn't handle subprocess, workorder id: " + processId));
            return;
        }
        String titleId = this.getTitleId(process);
        if (!this.isTitleIdValid(titleId)) {
            LOGGER.debug((Object)("DistributionRetryHandler doesn't handle invalid title id, workorder id: " + processId));
            return;
        }
        this.cache.put(titleId, eventType);
    }

    private class HazelCastMembershipListener
    implements MembershipListener {
        private HazelCastMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            LOGGER.debug((Object)"Local member node receives an event of member removed.");
            if (AggregatedTitleProcessHandler.this.hzcs.isMaster()) {
                AggregatedTitleProcessHandler.this.startScheduler();
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

