/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.AwaitingTitleProcessingStatusCacheItem;
import com.tandbergtv.cms.workflow.eventhandler.utils.DateUtil;
import com.tandbergtv.cms.workflow.eventhandler.utils.Util;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;

public class AwaitingTitleProcessingStatusCache {
    private static final Logger LOGGER = Logger.getLogger(AwaitingTitleProcessingStatusCache.class);
    private static final String EVENT_TYPE = "eventType";
    private static final String TIMESTAMP = "timestamp";
    private static final String NUMBER_OF_LIFETIME = "title_processing_status_update_lifetime";
    private static final String NUMBER_OF_DELAY = "title_processing_status_update_delay";
    private static final long LIFETIME = Util.getProperty("title_processing_status_update_lifetime", 60) * 1000;
    private static final long DELAY = Util.getProperty("title_processing_status_update_delay", 15) * 1000;
    private IMap<String, Map<String, Object>> hazelcastMap;

    private AwaitingTitleProcessingStatusCache() {
        HazelcastInstance hazelcastInstance = this.getHazelcastInstance();
        this.hazelcastMap = hazelcastInstance.getMap(this.getClass().getName());
    }

    private HazelcastInstance getHazelcastInstance() {
        return ((IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class)).getInstance();
    }

    public void put(String titleId, WorkflowProcessEventType eventType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EVENT_TYPE, eventType);
        map.put(TIMESTAMP, DateUtil.getCurrentTime());
        this.hazelcastMap.put((Object)titleId, map);
    }

    public void remove(String titleId, Long originalTimestamp) {
        Map map = (Map)this.hazelcastMap.get((Object)titleId);
        Long currentTimestamp = (Long)map.get(TIMESTAMP);
        if (originalTimestamp.equals(currentTimestamp)) {
            this.hazelcastMap.remove((Object)titleId, (Object)map);
        }
    }

    public void removeIfTimeout(String titleId) {
        Map map = (Map)this.hazelcastMap.get((Object)titleId);
        Long currentTimestamp = (Long)map.get(TIMESTAMP);
        if (this.isTimeout(currentTimestamp)) {
            this.hazelcastMap.remove((Object)titleId, (Object)map);
            LOGGER.warn((Object)("The Title [" + titleId + "] is kicked out of the processing queque when the timeout of [" + LIFETIME + " milliseconds] reached."));
        }
    }

    private boolean isTimeout(Long timestamp) {
        return timestamp + LIFETIME < DateUtil.getCurrentTime();
    }

    public boolean isEmpty() {
        return this.hazelcastMap.isEmpty();
    }

    public Map<String, AwaitingTitleProcessingStatusCacheItem> getQualifiedItems() {
        Set entrySet = this.hazelcastMap.entrySet();
        if (Objects.isNull(entrySet) || entrySet.isEmpty()) {
            return new HashMap<String, AwaitingTitleProcessingStatusCacheItem>();
        }
        HashMap<String, AwaitingTitleProcessingStatusCacheItem> map = new HashMap<String, AwaitingTitleProcessingStatusCacheItem>();
        entrySet.forEach(entry -> {
            String titleId = (String)entry.getKey();
            Map m = (Map)entry.getValue();
            Long timestamp = (Long)m.get(TIMESTAMP);
            if (!this.isQualified(timestamp)) {
                LOGGER.debug((Object)("Title [" + titleId + "] cannot be processed until it waits " + DELAY + " milliseconds for system to do some coordination work, such as data synchronization."));
                return;
            }
            WorkflowProcessEventType eventType = (WorkflowProcessEventType)m.get(EVENT_TYPE);
            AwaitingTitleProcessingStatusCacheItem item = AwaitingTitleProcessingStatusCacheItem.newInstance(eventType, timestamp);
            map.put(titleId, item);
        });
        return map;
    }

    private boolean isQualified(Long timestamp) {
        long currentTime = new Date().getTime();
        return currentTime - timestamp > DELAY;
    }

    public static AwaitingTitleProcessingStatusCache getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private static class SingletonHelper {
        private static final AwaitingTitleProcessingStatusCache INSTANCE = new AwaitingTitleProcessingStatusCache();

        private SingletonHelper() {
        }
    }
}

