/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler;

import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class ProcessSearchHelper {
    private static final Logger LOGGER = Logger.getLogger(ProcessSearchHelper.class);
    private boolean processSearchServiceInitFlag = false;
    private IProcessSearchService processSearchService;

    private ProcessSearchHelper() {
    }

    public void init() {
        if (this.isInitialized()) {
            return;
        }
        if (Objects.isNull(this.processSearchService)) {
            this.processSearchService = (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
        }
        if (Objects.nonNull(this.processSearchService) && this.canSearchProcess()) {
            this.processSearchServiceInitFlag = true;
        }
    }

    private boolean canSearchProcess() {
        try {
            this.searchWOForTitle(String.valueOf(-1));
            return true;
        }
        catch (NullPointerException npe) {
            LOGGER.warn((Object)"Fails to contact the service. Processing Search Service doesn't start up completely yet.");
            return false;
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Fails to contact the service. Processing Search Service doesn't start up completely yet.", (Throwable)e);
            return false;
        }
    }

    public boolean isInitialized() {
        return this.processSearchServiceInitFlag;
    }

    public List<WFSearchResult> searchWOForTitle(String titleId) {
        SearchCriteria criteria = new SearchCriteria();
        ValueParameter titleIdParameter = new ValueParameter("titleId");
        titleIdParameter.setValue((Object)titleId);
        titleIdParameter.setVarInstance(true);
        criteria.addParameter((SearchParameterBase)titleIdParameter);
        criteria.addParameter((SearchParameterBase)this.getExcludeSubprocessSearchParameter());
        return this.processSearchService.expressSearch(criteria);
    }

    public List<WFSearchResult> searchWOForEndTime(String from) {
        return this.searchWOForDate("endTime", from);
    }

    public List<WFSearchResult> searchWOForErrorTime(String from) {
        return this.searchWOForDate("errorTime", from);
    }

    private List<WFSearchResult> searchWOForDate(String parameterName, String from) {
        SearchCriteria criteria = new SearchCriteria();
        RangeParameter dateRangeParameter = new RangeParameter(parameterName, SearchType.DATE);
        dateRangeParameter.setFrom(from);
        dateRangeParameter.setVarInstance(true);
        criteria.addParameter((SearchParameterBase)dateRangeParameter);
        criteria.addParameter((SearchParameterBase)this.getExcludeSubprocessSearchParameter());
        return this.processSearchService.expressSearch(criteria);
    }

    private ValueParameter getExcludeSubprocessSearchParameter() {
        ValueParameter parameter = new ValueParameter("parentProcessId", SearchType.NUMERIC);
        parameter.setValue((Object)0);
        parameter.setVarInstance(true);
        return parameter;
    }

    public static ProcessSearchHelper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private static class SingletonHelper {
        private static final ProcessSearchHelper INSTANCE = new ProcessSearchHelper();

        private SingletonHelper() {
        }
    }
}

