/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler;

import com.ericsson.neptune.configuration.settings.client.NeptuneClient;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.AwaitingTitleProcessingStatusCache;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.AwaitingTitleProcessingStatusCacheItem;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.ProcessSearchHelper;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.ProcessStatusDetermination;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.TitleProcessingStatus;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class TitleProcessingStatusUpdateSubTask
implements Callable<Void> {
    private static final Logger LOGGER = Logger.getLogger(TitleProcessingStatusUpdateSubTask.class);
    private static final String PATH = "%s/status/%s";
    private String titleId;
    private AwaitingTitleProcessingStatusCacheItem item;
    private CountDownLatch latch;

    private TitleProcessingStatusUpdateSubTask(String titleId, AwaitingTitleProcessingStatusCacheItem item, CountDownLatch latch) {
        this.titleId = titleId;
        this.item = item;
        this.latch = latch;
    }

    @Override
    public Void call() {
        try {
            this.performOperation();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexpected exception occurs.", (Throwable)e);
        }
        finally {
            this.latch.countDown();
        }
        return null;
    }

    private void performOperation() {
        String url = this.buildUrl();
        boolean isOk = this.sendRequest(url);
        AwaitingTitleProcessingStatusCache cache = AwaitingTitleProcessingStatusCache.getInstance();
        if (isOk) {
            LOGGER.debug((Object)("The request to update Title [" + this.titleId + "] processing status is sent successfully."));
            Long originalTimestamp = this.item.getTimestamp();
            cache.remove(this.titleId, originalTimestamp);
        } else {
            LOGGER.debug((Object)("The request to update Title [" + this.titleId + "] processing fails to send."));
            cache.removeIfTimeout(this.titleId);
        }
    }

    private String buildUrl() {
        WorkflowProcessEventType eventType = this.item.getEventType();
        TitleProcessingStatus status = this.getTitleProcessingStatus(eventType);
        return String.format(PATH, this.titleId, status.ordinal());
    }

    private boolean sendRequest(String url) {
        NeptuneClient client = new NeptuneClient(NeptuneClient.Route.TITLE_SERVICE, new String[]{url});
        try {
            client.invoke(Void.class, "");
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception occurs during sending request to update title processing status.", (Throwable)e);
            return false;
        }
    }

    private TitleProcessingStatus getTitleProcessingStatus(WorkflowProcessEventType eventType) {
        if (WorkflowProcessEventType.STARTED == eventType || WorkflowProcessEventType.RESUMED == eventType) {
            return TitleProcessingStatus.PROCESSING;
        }
        List<WFSearchResult> workOrders = ProcessSearchHelper.getInstance().searchWOForTitle(this.titleId);
        boolean hasFailed = false;
        boolean hasCompleted = false;
        for (WFSearchResult workOrder : workOrders) {
            ProcessStatus processStatus = workOrder.getToken().getStatus();
            if (!ProcessStatusDetermination.NOT_IN_PROGRESS.contains(processStatus)) {
                return TitleProcessingStatus.PROCESSING;
            }
            if (!hasFailed && ProcessStatusDetermination.FAILED.contains(processStatus)) {
                hasFailed = true;
            }
            if (hasCompleted || !ProcessStatusDetermination.COMPLETED.contains(processStatus)) continue;
            hasCompleted = true;
        }
        if (hasFailed) {
            return TitleProcessingStatus.FAILED;
        }
        if (hasCompleted) {
            return TitleProcessingStatus.COMPLETED;
        }
        return TitleProcessingStatus.NONE;
    }

    public static TitleProcessingStatusUpdateSubTask newInstance(String titleId, AwaitingTitleProcessingStatusCacheItem item, CountDownLatch latch) {
        return new TitleProcessingStatusUpdateSubTask(titleId, item, latch);
    }
}

