/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.HazelcastInstance;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.AwaitingTitleProcessingStatusCache;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.AwaitingTitleProcessingStatusCacheItem;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.ProcessSearchHelper;
import com.tandbergtv.cms.workflow.eventhandler.titleprocesshandler.TitleProcessingStatusUpdateSubTask;
import com.tandbergtv.cms.workflow.eventhandler.utils.DateUtil;
import com.tandbergtv.cms.workflow.eventhandler.utils.Util;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TitleProcessingStatusUpdateTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(TitleProcessingStatusUpdateTask.class);
    private static final String NUMBER_OF_TIMEOUT = "process_searchservice_init_timeout";
    private static final String NUMBER_OF_INTERVAL = "process_searchservice_init_retries_interval";
    private static final String NUMBER_OF_RECOVER_RANGE = "title_processing_status_update_recover_range";
    private static final String NUMBER_OF_THREAD_CORE = "title_processing_status_update_thread_core";
    private static final String NUMBER_OF_THREAD_MAX = "title_processing_status_update_thread_max";
    private static final String NUMBER_OF_THREAD_KEEP_ALIVE_TIME = "title_processing_status_update_thread_keep_alive_time";
    private static final String FLAG_OF_RECOVER_ENABLE = "title_processing_status_update_recover_enabled";
    private static final String TITLE_ID = "titleId";
    private static final String RECOVERED_FLAG = "recoveredFlag";
    private static final long TIMEOUT = Util.getProperty("process_searchservice_init_timeout", 300) * 1000;
    private static final long INTERVAL = Util.getProperty("process_searchservice_init_retries_interval", 1) * 1000;
    private static final int RECOVER_RANGE = Util.getProperty("title_processing_status_update_recover_range", 7200);
    private static final boolean RECOVER_ENABLED = Util.getProperty("title_processing_status_update_recover_enabled", true);
    private static final int THREAD_CORE = Util.getProperty("title_processing_status_update_thread_core", 10);
    private static final int THREAD_MAX = Util.getProperty("title_processing_status_update_thread_max", 20);
    private static final int THREAD_KEEP_ALIVE_TIME = Util.getProperty("title_processing_status_update_thread_keep_alive_time", 60);
    private long timeWaited = 0L;
    private AwaitingTitleProcessingStatusCache cache = AwaitingTitleProcessingStatusCache.getInstance();
    private ProcessSearchHelper processSearchHelper = ProcessSearchHelper.getInstance();
    private boolean recoveredFlag = false;
    private ExecutorService threadPool = new ThreadPoolExecutor(THREAD_CORE, THREAD_MAX, THREAD_KEEP_ALIVE_TIME, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private TitleProcessingStatusUpdateTask() {
        if (RECOVER_ENABLED) {
            LOGGER.debug((Object)"Title processing status update recover on start up is enabled.");
        } else {
            LOGGER.debug((Object)"Title processing status update recover on start up is disabled.");
        }
    }

    @Override
    public void run() {
        try {
            this.performOperation();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexpected exception occurs.", (Throwable)e);
        }
    }

    private void performOperation() {
        long startTime = System.currentTimeMillis();
        while (!this.processSearchHelper.isInitialized() && !this.isTimeout()) {
            LOGGER.debug((Object)"Instance of IProcessSearchService is not initialized.");
            this.processSearchHelper.init();
            if (this.processSearchHelper.isInitialized()) {
                LOGGER.debug((Object)"Instance of IProcessSearchService is initialized.");
                break;
            }
            this.waitForRetry();
        }
        if (!this.processSearchHelper.isInitialized()) {
            LOGGER.error((Object)"Instance of IProcessSearchService cannot be initialized.");
            return;
        }
        if (RECOVER_ENABLED && !this.hasRecovered()) {
            this.recover();
            this.updateRecoverFlag();
            LOGGER.debug((Object)"Local member node recovers on startup.");
        }
        if (this.cache.isEmpty()) {
            LOGGER.debug((Object)"Awaiting title processing status cache is empty.");
            return;
        }
        this.processTitlesInCache();
        LOGGER.debug((Object)("Title processing status update task spends time(milliseconds): " + (System.currentTimeMillis() - startTime)));
    }

    private boolean isTimeout() {
        return this.timeWaited >= TIMEOUT;
    }

    private void waitForRetry() {
        Util.sleep(INTERVAL);
        this.timeWaited += INTERVAL;
    }

    private Map<String, Boolean> getHazelcastMap() {
        IClusterService clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        HazelcastInstance hazelcastInstance = clusterService.getInstance();
        return hazelcastInstance.getMap(this.getClass().getName());
    }

    private boolean hasRecovered() {
        if (this.recoveredFlag) {
            return true;
        }
        Map<String, Boolean> map = this.getHazelcastMap();
        Boolean flag = map.get(RECOVERED_FLAG);
        if (Objects.isNull(flag)) {
            return false;
        }
        if (flag.booleanValue()) {
            this.recoveredFlag = true;
        }
        return flag;
    }

    private void updateRecoverFlag() {
        this.recoveredFlag = true;
        Map<String, Boolean> map = this.getHazelcastMap();
        map.put(RECOVERED_FLAG, true);
    }

    private Date getStartDate(int val) {
        Calendar now = Calendar.getInstance();
        now.add(13, -val);
        return now.getTime();
    }

    private void recover() {
        Date startDate = this.getStartDate(RECOVER_RANGE);
        String from = DateUtil.parseDateToStr(startDate, "yyyy-MM-dd");
        List<WFSearchResult> workOrders = this.processSearchHelper.searchWOForErrorTime(from);
        this.handleWOList(workOrders, WorkflowProcessEventType.FAILED);
        workOrders = this.processSearchHelper.searchWOForEndTime(from);
        this.handleWOList(workOrders, WorkflowProcessEventType.STOPPED);
    }

    private void handleWOList(List<WFSearchResult> workOrders, WorkflowProcessEventType eventType) {
        if (Objects.isNull(workOrders) || workOrders.isEmpty()) {
            return;
        }
        HashSet titleIds = new HashSet();
        workOrders.forEach(workOrder -> {
            String titleId = this.getTitleId((WFSearchResult)workOrder);
            if (StringUtils.isEmpty((String)titleId)) {
                return;
            }
            titleIds.add(titleId);
        });
        titleIds.forEach(titleId -> this.cache.put((String)titleId, eventType));
    }

    private String getTitleId(WFSearchResult workOrder) {
        Map variables = workOrder.getVariables();
        WFVariable variable = (WFVariable)variables.get(TITLE_ID);
        if (Objects.isNull(variable)) {
            return null;
        }
        return ((WFVariable)variables.get(TITLE_ID)).getValue();
    }

    private void processTitlesInCache() {
        Map<String, AwaitingTitleProcessingStatusCacheItem> map = this.cache.getQualifiedItems();
        if (map.isEmpty()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(map.size());
        map.entrySet().forEach(entry -> {
            String titleId = (String)entry.getKey();
            AwaitingTitleProcessingStatusCacheItem item = (AwaitingTitleProcessingStatusCacheItem)entry.getValue();
            this.threadPool.submit(TitleProcessingStatusUpdateSubTask.newInstance(titleId, item, latch));
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Exception occurs during CountDownLatch#await.", (Throwable)e);
        }
    }

    public static TitleProcessingStatusUpdateTask getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private static class SingletonHelper {
        private static final TitleProcessingStatusUpdateTask INSTANCE = new TitleProcessingStatusUpdateTask();

        private SingletonHelper() {
        }
    }
}

