/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.workflow.eventhandler.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class);
    private static final String WORKFLOW_CONF_DIR = "/conf/workflow";
    private static final String SERVICE_PROPERTIES = "/service.properties";
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final Properties properties = new Properties();
    private static boolean isLoaded = true;

    private Util() {
    }

    private static void loadProperties() {
        File file = new File(System.getProperty(PRODUCT_DIR) + WORKFLOW_CONF_DIR, SERVICE_PROPERTIES);
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to load properties file. Default values will be used", (Throwable)e);
            isLoaded = false;
        }
    }

    public static Integer getProperty(String key, int defaultVal) {
        if (!isLoaded) {
            return defaultVal;
        }
        String s = properties.getProperty(key);
        if (StringUtils.isEmpty((String)s)) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"NumberFormatException.", (Throwable)e);
            return defaultVal;
        }
    }

    public static Boolean getProperty(String key, boolean defaultVal) {
        if (!isLoaded) {
            return defaultVal;
        }
        String s = properties.getProperty(key);
        if (StringUtils.isEmpty((String)s)) {
            return defaultVal;
        }
        return Boolean.parseBoolean(s);
    }

    public static void sleep(long interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Exception occurs in Thread#sleep.", (Throwable)e);
        }
    }

    static {
        Util.loadProperties();
    }
}

