/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.amsadi;

import com.tandbergtv.amsadi.AmsAdiException;
import com.tandbergtv.amsadi.ISAUtil;
import com.tandbergtv.amsadi.ProvisionProfile;
import com.twc.isa.PackageModule.Package;
import com.twc.isa.PackageModule.PackageFactory;
import com.twc.isa.PackageModule.PackageFactoryHelper;
import com.twc.isa.PackageModule.PackageHelper;
import com.twc.isa.PackageModule.TransferException;
import com.twc.isa.PackageModule.VersionException;
import com.twc.isa.PackageModule.XmlProcessingException;
import com.twc.isa.ServerModule.AdministrativeState;
import com.twc.isa.ServerModule.DuplicateServant;
import com.twc.isa.ServerModule.InvalidName;
import com.twc.isa.ServerModule.InvalidStateChange;
import com.twc.isa.ServerModule.NameNotFound;
import com.twc.isa.ServerModule.OutOfService;
import com.twc.isa.ServerModule.ProvisioningFailed;
import com.twc.isa.ServerModule.ServantBase;
import com.twc.isa.ServerModule.ServantCreateFailed;
import com.twc.isa.ServerModule.UnspecifiedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class AMSADIManager {
    private static final Logger logger = Logger.getLogger(AMSADIManager.class);
    private static final String CL10 = "CableLabsVOD1.0";
    private static final String MOD13 = "MOD1.3";
    private static final String ISA1_2 = "ISA1.2";
    private static final String ISA1_4 = "ISA1.4";
    private static final String FTPPROTOCOL = "ftp";
    private ProvisionProfile profile;

    public AMSADIManager(ProvisionProfile profile) {
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provisionPackage() throws AmsAdiException {
        if (this.profile.getAmsServerIP() == null || this.profile.getAmsPort() == null || this.profile.getAmsServerIP().trim().length() == 0 || this.profile.getAmsPort().trim().length() == 0) {
            String reason = "AMS server IP and/or port number not set";
            throw new AmsAdiException(reason);
        }
        String nameservice = "corbaloc::" + this.profile.getAmsServerIP() + ":" + this.profile.getAmsPort() + "/NameService";
        String[] args = new String[]{"-ORBInitRef", "NameService=" + nameservice};
        ORB orb = ISAUtil.orb_main(args);
        if (orb == null) {
            String reason = "Could not create org.omg.CORBA.ORB object";
            throw new AmsAdiException(reason);
        }
        logger.debug((java.lang.Object)("ORB implementation: " + orb.getClass().getName()));
        try {
            Package package_;
            String servantName;
            block32: {
                String[] strFullPath = new String[]{"Factories", "PackageFactory"};
                Object obj = ISAUtil.getFactoryObject(orb, strFullPath);
                if (obj == null) {
                    String reason = "Could not create org.omg.CORBA.Object object";
                    throw new AmsAdiException(reason);
                }
                if (this.profile.getAdiVersion() == null || this.profile.getAdiVODSpecVersion() == null || this.profile.getAdiVersion().trim().length() == 0 || this.profile.getAdiVODSpecVersion().trim().length() == 0) {
                    String reason = "ADI version and/or ADI VOD specification version not set";
                    throw new AmsAdiException(reason);
                }
                servantName = this.profile.getAdiVersion().equals(ISA1_4) && !this.profile.getAdiVODSpecVersion().equals(MOD13) && !this.profile.getAdiVODSpecVersion().equals(CL10) ? this.profile.getUniqueProviderId() + "/" + this.profile.getPackageAssetId() : this.profile.getProviderName() + "::" + this.profile.getPackageType() + "::" + this.profile.getPackageName();
                PackageFactory Packagefactory = PackageFactoryHelper.narrow((Object)obj);
                package_ = null;
                try {
                    if (this.profile.getAdiVersion().equals(ISA1_4) && !this.profile.getAdiVODSpecVersion().equals(MOD13) && !this.profile.getAdiVODSpecVersion().equals(CL10)) {
                        ServantBase existingServant = null;
                        try {
                            existingServant = Packagefactory.find(servantName);
                        }
                        catch (UnspecifiedException e) {
                            String reason = e.message;
                            throw new AmsAdiException(reason);
                        }
                        catch (NameNotFound e) {
                            // empty catch block
                        }
                        package_ = existingServant != null ? PackageHelper.narrow((Object)existingServant) : PackageHelper.narrow((Object)Packagefactory.createServant(servantName));
                        break block32;
                    }
                    package_ = PackageHelper.narrow((Object)Packagefactory.createServant(servantName));
                }
                catch (ServantCreateFailed e) {
                    String reason = e.message;
                    throw new AmsAdiException(reason);
                }
                catch (UnspecifiedException e) {
                    String reason = e.message;
                    throw new AmsAdiException(reason);
                }
                catch (InvalidName e) {
                    String reason = e.message;
                    throw new AmsAdiException(reason);
                }
                catch (OutOfService e) {
                    String reason = e.message;
                    throw new AmsAdiException(reason);
                }
                catch (DuplicateServant e) {
                    String reason = e.message;
                    throw new AmsAdiException(reason);
                }
            }
            if (package_ == null) {
                String reason = "Failed to lookup the package servant " + servantName;
                throw new AmsAdiException(reason);
            }
            try {
                InetAddress thisIp = InetAddress.getLocalHost();
                if (this.profile.getFtpServerIP() == null || this.profile.getFtpServerIP().trim().length() == 0) {
                    this.profile.setFtpServerIP(thisIp.getHostAddress());
                }
            }
            catch (UnknownHostException e1) {
                String reason = e1.getMessage();
                throw new AmsAdiException(reason);
            }
            if (this.profile.getPackagedir() == null) {
                String reason = "Package directory is not set";
                throw new AmsAdiException(reason);
            }
            String metadataFileName = "ADI.XML";
            if (this.profile.getMetadataFileName() != null && !this.profile.getMetadataFileName().isEmpty()) {
                metadataFileName = this.profile.getMetadataFileName();
            }
            String strURLName = "ftp://" + this.profile.getFtpUsername() + ":" + this.profile.getFtpPassword() + "@" + this.profile.getFtpServerIP() + AMSADIManager.dos2unix(this.profile.getPackagedir()) + "/" + metadataFileName;
            try {
                if (this.profile.getAdiVersion().equals(ISA1_2)) {
                    package_.provision(AdministrativeState.as_Unprovisioned, strURLName);
                } else {
                    package_.provision(AdministrativeState.as_InService, strURLName);
                }
            }
            catch (ProvisioningFailed e) {
                String reason = e.message;
                throw new AmsAdiException(reason);
            }
            catch (VersionException e) {
                String reason = e.message;
                throw new AmsAdiException(reason);
            }
            catch (InvalidStateChange e) {
                String reason = e.message;
                throw new AmsAdiException(reason);
            }
            catch (UnspecifiedException e) {
                String reason = e.message;
                throw new AmsAdiException(reason);
            }
            catch (XmlProcessingException e) {
                String reason = e.message;
                throw new AmsAdiException(reason);
            }
            catch (TransferException e) {
                String reason = e.message;
                throw new AmsAdiException(reason);
            }
        }
        finally {
            logger.debug((java.lang.Object)"Destroying ORB");
            orb.shutdown(true);
            orb.destroy();
            logger.debug((java.lang.Object)"ORB destroyed");
        }
    }

    private static String dos2unix(String s) {
        String unixstring = new String(s);
        String nobackslash = unixstring.replace('\\', '/');
        int index = nobackslash.indexOf(":");
        if (index != -1) {
            return nobackslash.substring(index + 1);
        }
        return nobackslash;
    }
}

