/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.util.List;

abstract class AbstractMessageDispatcher
extends AbstractDispatcher {
    private WorkflowMessage request;

    public AbstractMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public final IMessage send(IMessage message) throws DispatcherException {
        WPCLConverter converter = new WPCLConverter();
        IMessage ret = null;
        try {
            this.request = converter.convert(message);
            WorkflowMessage response = this.send();
            ret = converter.convert(response);
        }
        catch (Exception e) {
            WorkflowMessage response = this.generateNackMessage(e.getMessage());
            try {
                ret = converter.convert(response);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected WorkflowMessage getRequest() {
        return this.request;
    }

    protected WorkflowMessage createAckResponse() {
        return WorkflowMessageFactory.createAckMessage((WorkflowMessage)this.request);
    }

    protected abstract WorkflowMessage send() throws Exception;

    protected String getParameter(String name) {
        Object value = this.request.getParameterValue(name);
        if (value instanceof String) {
            return value.toString();
        }
        throw new RuntimeException("Parameter " + name + " is required");
    }

    protected int getIntegerParameter(String name) {
        Object value = this.request.getParameterValue(name);
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new RuntimeException("Parameter " + name + " is required");
    }

    protected List<String> getListParameter(String name) {
        Object value = this.request.getParameterValue(name);
        if (value instanceof List) {
            return (List)value;
        }
        throw new RuntimeException("Parameter " + name + " is required");
    }

    protected WorkflowMessage generateNackMessage(String errorMessage) {
        WorkflowMessage response = WorkflowMessageFactory.createNackMessage((WorkflowMessage)this.request);
        response.putValue("error-message", errorMessage);
        return response;
    }
}

