/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConvertListToString
extends AbstractMessageDispatcher {
    private static final Logger logger = Logger.getLogger(ConvertListToString.class);
    private static final String PARAM_DELIMITER = "delimiter";
    private static final String PARAM_STRRESULT = "strResult";
    private static final String PARAM_LIST = "list";
    private static final String DEFAULT_DELIMITER = ",";

    public ConvertListToString(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        String dlm = this.getDelimiterParameter();
        logger.debug((Object)String.format("delimiter to use: %s", dlm));
        List<Object> origList = this.getListParameter();
        StringBuilder res = new StringBuilder();
        for (Object obj : origList) {
            res.append(String.valueOf(obj)).append(dlm);
        }
        if (res.toString().endsWith(dlm)) {
            res.deleteCharAt(res.lastIndexOf(dlm));
        }
        logger.debug((Object)String.format("result string: %s", res.toString()));
        WorkflowMessage response = this.createAckResponse();
        response.putValue(PARAM_STRRESULT, res.toString());
        return response;
    }

    private List<Object> getListParameter() {
        ArrayList objList = (ArrayList)this.getRequest().getParameterValue(PARAM_LIST);
        if (objList == null) {
            objList = new ArrayList();
        }
        return objList;
    }

    private String getDelimiterParameter() {
        Object value = this.getRequest().getParameterValue(PARAM_DELIMITER);
        if (value != null && !value.toString().isEmpty()) {
            return value.toString();
        }
        return DEFAULT_DELIMITER;
    }
}

