/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GetFileListUnderDirectory
extends AbstractMessageDispatcher {
    protected static final String DIRECTORY = "directory";
    protected static final String FILTER = "filter";
    protected static final String FILELIST = "fileList";
    private static final Logger logger = Logger.getLogger(GetFileListUnderDirectory.class);

    public GetFileListUnderDirectory(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = this.createAckResponse();
        String dir = this.getParameter(DIRECTORY);
        String filter = this.getParameter(FILTER);
        logger.debug((Object)("directory " + dir + ", filter " + filter));
        response.putValue(FILELIST, this.getFileList(dir, filter));
        return response;
    }

    protected List<String> getFileList(String dir, final String filter) throws IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        File directory = new File(dir);
        if (this.validateParameters(directory)) {
            File[] allFiles;
            File[] fileArray = allFiles = filter == null || filter.trim().isEmpty() ? directory.listFiles() : directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().matches(filter);
                }
            });
            if (allFiles != null) {
                for (File file : allFiles) {
                    fileList.add(file.getAbsolutePath());
                    logger.debug((Object)("Adding the file to fileList:" + file.getAbsolutePath()));
                }
            }
        }
        return fileList;
    }

    protected boolean validateParameters(File dir) {
        boolean flag = true;
        if (!dir.exists()) {
            logger.error((Object)("The directory " + dir + " is not exist!"));
            flag = false;
        }
        return flag;
    }
}

