/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GetPreference
extends AbstractMessageDispatcher {
    protected static final String WORKFLOW_DIR = "workflow";
    protected static final String DEFAULT_LOCATION = "/opt/tandbergtv/cms";
    protected static final String USER = "user";
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    protected static final String SYSTEM_USER = "system";
    protected static final String PREFERENCES_FOLDER = "preferences";
    private static final Logger logger = Logger.getLogger(GetPreference.class);

    public GetPreference(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = this.createAckResponse();
        String user = this.getRequest().getValue(USER);
        String key = this.getParameter(KEY);
        logger.debug((Object)("User " + user + ", key " + key));
        response.putValue(VALUE, this.getPreference(user, key));
        return response;
    }

    protected String getPreference(String user, String key) throws IOException {
        return this.getPreferences(user).getProperty(key);
    }

    protected Properties getPreferences(String users) throws IOException {
        File dir = this.getRootDirectory();
        Properties mergedProperties = new Properties();
        logger.debug((Object)("Root directory " + dir.getAbsolutePath()));
        if (!dir.exists()) {
            return mergedProperties;
        }
        if (users == null || users.isEmpty()) {
            users = SYSTEM_USER;
        }
        ArrayList<Properties> properties = new ArrayList<Properties>();
        HashSet<Object> keys = new HashSet<Object>();
        String[] userList = users.split(",");
        String notExistsFiles = "";
        for (String user : userList) {
            File file = new File(dir, user + ".xml");
            if (!file.exists()) {
                notExistsFiles = notExistsFiles.isEmpty() ? file.getName() : notExistsFiles.concat("," + file.getName());
                continue;
            }
            logger.debug((Object)("Preference file " + file.getAbsolutePath()));
            Properties prop = this.getPreferences(file);
            if (prop.isEmpty()) continue;
            properties.add(prop);
            keys.addAll(prop.keySet());
        }
        if (!notExistsFiles.isEmpty()) {
            throw new RuntimeException("Can not find file(s): " + notExistsFiles);
        }
        for (Object e : keys) {
            String keyStr = (String)e;
            for (Properties prop : properties) {
                if (!prop.containsKey(e) || mergedProperties.containsKey(e)) continue;
                logger.debug((Object)("key " + keyStr + ", value " + prop.getProperty(keyStr)));
                mergedProperties.setProperty(keyStr, prop.getProperty(keyStr));
            }
        }
        return mergedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getPreferences(File preferencesFile) throws IOException {
        Properties preferences = new Properties();
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(preferencesFile));
            preferences.loadFromXML(stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return preferences;
    }

    protected File getRootDirectory() {
        String directory = System.getProperty(PRODUCT_DIR);
        if (directory == null) {
            directory = this.getConfiguration().getParameterValue(PRODUCT_DIR);
        }
        if (directory == null) {
            directory = DEFAULT_LOCATION;
        }
        directory = directory + File.separator + WORKFLOW_DIR;
        return new File(directory, PREFERENCES_FOLDER);
    }
}

