/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class GetRelativePath
extends AbstractMessageDispatcher {
    private static final Logger logger = Logger.getLogger(GetRelativePath.class);
    private static final String PARAM_FROM_PATH = "currentPath";
    private static final String PARAM_TO_PATH = "destPath";
    private static final String RELATIVE_PATH = "relativePath";

    public GetRelativePath(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = this.createAckResponse();
        String fromPath = this.getParameter(PARAM_FROM_PATH);
        String toPath = this.getParameter(PARAM_TO_PATH);
        StringBuilder relativePathSB = new StringBuilder("");
        if (fromPath == null || fromPath.isEmpty()) {
            logger.error((Object)"currentPath can NOT be empty.");
            throw new Exception("currentPath can NOT be empty.");
        }
        logger.info((Object)("currentPath=" + fromPath));
        if (toPath == null || toPath.isEmpty()) {
            logger.info((Object)"destPath can NOT be empty.");
            throw new Exception("destPath can NOT be empty.");
        }
        logger.info((Object)("destPath=" + toPath));
        boolean seperatorFlagEnd = toPath.endsWith(File.separator);
        fromPath = fromPath.replaceAll(File.separator + "+", File.separator);
        toPath = toPath.replaceAll(File.separator + "+", File.separator);
        fromPath = this.trimLeadingAndEndingSeperators(fromPath);
        toPath = this.trimLeadingAndEndingSeperators(toPath);
        String currentFolder = "." + File.separator;
        List<String> fromPathFolderList = Arrays.asList(fromPath.split(File.separator));
        List<String> toPathFolderList = Arrays.asList(toPath.split(File.separator));
        int commonFolderNum = this.getCommonFolderNum(fromPathFolderList, toPathFolderList);
        if (commonFolderNum < fromPathFolderList.size()) {
            for (int i = commonFolderNum; i < fromPathFolderList.size(); ++i) {
                relativePathSB.append("..").append(File.separator);
            }
        }
        if ("".equals(relativePathSB.toString())) {
            relativePathSB.append(currentFolder);
        }
        if (commonFolderNum < toPathFolderList.size()) {
            for (int j = commonFolderNum; j < toPathFolderList.size(); ++j) {
                relativePathSB.append(toPathFolderList.get(j)).append(File.separator);
            }
        }
        String relativePath = relativePathSB.toString();
        if (!seperatorFlagEnd && !currentFolder.equals(relativePath)) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        response.putValue(RELATIVE_PATH, relativePath);
        return response;
    }

    protected String trimLeadingAndEndingSeperators(String path) {
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    protected int getCommonFolderNum(List<String> fromPathFolderList, List<String> toPathFolderList) {
        int commonFolderNum = 0;
        for (int i = 0; i < fromPathFolderList.size() && i < toPathFolderList.size() && fromPathFolderList.get(i).equals(toPathFolderList.get(i)); ++i) {
            ++commonFolderNum;
        }
        return commonFolderNum;
    }
}

