/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.web.neptune.NeptuneSettingsProvider;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetSetting
extends AbstractMessageDispatcher {
    private static final String PATH = "path";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final Logger logger = Logger.getLogger(GetSetting.class);

    public GetSetting(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = null;
        try {
            response = this.createAckResponse();
            String name = this.getParameter(NAME);
            String path = this.getParameter(PATH);
            logger.debug((Object)("path " + path + ", path " + path));
            response.putValue(VALUE, this.getSetting(path, name));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return response;
    }

    private String getSetting(String path, String name) {
        String result = "";
        NeptuneSettingsProvider settingProvider = new NeptuneSettingsProvider();
        Map setting = settingProvider.getProperties(path);
        if (setting != null) {
            result = (String)setting.get(name);
        }
        return result;
    }
}

