/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.device.utilities.GetSetting;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.web.neptune.NeptuneSettingsProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GetSettings
extends AbstractMessageDispatcher {
    private static final String PATH = "path";
    private static final String VALUES = "values";
    private static final String NAMES = "names";
    private static final Logger logger = Logger.getLogger(GetSetting.class);

    public GetSettings(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = null;
        try {
            response = this.createAckResponse();
            String path = this.getParameter(PATH);
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            logger.debug((Object)("path (aka groupPath) " + path));
            String[][] responses = this.getSettings(path);
            for (int i = 0; i < responses[0].length; ++i) {
                names.add(responses[0][i]);
                values.add(responses[1][i]);
            }
            response.putValue(NAMES, names);
            response.putValue(VALUES, values);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return response;
    }

    private String[][] getSettings(String path) {
        NeptuneSettingsProvider settingProvider = new NeptuneSettingsProvider();
        Map workflowSetting = settingProvider.getProperties(path);
        String[][] responses = new String[2][workflowSetting.size()];
        Set keys = workflowSetting.keySet();
        int counter = 0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            responses[0][counter] = key = (String)iterator.next();
            responses[1][counter] = (String)workflowSetting.get(key);
            ++counter;
        }
        return responses;
    }
}

