/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetSpecialOperationTemplatesPreference
extends AbstractMessageDispatcher {
    private static final Logger logger = Logger.getLogger(GetSpecialOperationTemplatesPreference.class);
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_SPECIALTEMPLATESTORUN = "specialTemplatesToRun";
    private static final String INSTALLED_COMP_FILE_PATH = "/opt/tandbergtv/cms/prepack/installedcomponent.json";
    private static final String SPECIAL_OPER_CONFIG_DIR = "/opt/tandbergtv/cms/prepack/special-oper/";

    public GetSpecialOperationTemplatesPreference(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        String opType = this.getParameter(PARAM_TYPE);
        ObjectMapper objectMapper = new ObjectMapper();
        File compFile = new File(INSTALLED_COMP_FILE_PATH);
        JsonNode jroot = objectMapper.readTree(compFile);
        if (!jroot.isObject()) {
            throw new Exception("Invalid installed component json: /opt/tandbergtv/cms/prepack/installedcomponent.json");
        }
        StringBuilder specialTemplateNames = new StringBuilder();
        Set<String> components = this.getInstalledComponents(jroot);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found these components in system: " + components));
        }
        for (String cmp : components) {
            String operFileName = cmp + "_" + opType;
            File operFile = new File(SPECIAL_OPER_CONFIG_DIR + operFileName);
            if (!operFile.exists() || operFile.length() <= 0L) continue;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(operFile));
                String tplName = br.readLine();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found one special operation template to run: " + tplName + " in file: " + operFileName));
                }
                specialTemplateNames.append(tplName).append(",");
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (br == null) continue;
                br.close();
            }
        }
        if (specialTemplateNames.lastIndexOf(",") >= 0 && specialTemplateNames.lastIndexOf(",") == specialTemplateNames.length() - 1) {
            specialTemplateNames.deleteCharAt(specialTemplateNames.length() - 1);
        }
        WorkflowMessage response = this.createAckResponse();
        response.putValue(PARAM_SPECIALTEMPLATESTORUN, specialTemplateNames.toString());
        return response;
    }

    private Set<String> getInstalledComponents(JsonNode jnode) {
        JsonNode subCmp;
        HashSet<String> values = new HashSet<String>();
        if (null == jnode || !jnode.isObject()) {
            return values;
        }
        JsonNode cmpName = jnode.get("componentName");
        if (cmpName != null && cmpName.isValueNode()) {
            values.add(cmpName.getTextValue());
        }
        if ((subCmp = jnode.get("subComponents")) != null && subCmp.isArray()) {
            Iterator cmps = subCmp.getElements();
            while (cmps.hasNext()) {
                values.addAll(this.getInstalledComponents((JsonNode)cmps.next()));
            }
        }
        return values;
    }
}

