/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GetTitleIdsFromSearchResult
extends AbstractMessageDispatcher {
    private static final Logger logger = Logger.getLogger(GetTitleIdsFromSearchResult.class);
    private static final String PARAM_FILE_PATH = "filepath";
    private static final String PARAM_ID_LIST = "ids";
    private static final String SEARCH_RESULT_HEADER = "Title ID";

    public GetTitleIdsFromSearchResult(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WorkflowMessage send() throws Exception {
        String filePath = this.getParameter(PARAM_FILE_PATH);
        ArrayList<String> ids = new ArrayList<String>();
        WorkflowMessage response = this.createAckResponse();
        if (filePath.isEmpty() || !new File(filePath).exists()) {
            logger.debug((Object)"filepath is not exists.");
            response.putValue(PARAM_ID_LIST, ids);
            return response;
        }
        try (BufferedReader searchResult = null;){
            searchResult = new BufferedReader(new FileReader(filePath));
            String header = searchResult.readLine();
            if (header == null || !header.startsWith(SEARCH_RESULT_HEADER)) {
                response.setType(WorkflowMessage.MessageType.nack);
                response.putValue("error-message", "The file format is incorrect!");
                WorkflowMessage workflowMessage = response;
                return workflowMessage;
            }
            String line = null;
            while ((line = searchResult.readLine()) != null) {
                logger.debug((Object)("content: " + line));
                String[] infors = line.split(",");
                if (infors == null && infors.length <= 0) continue;
                String id = infors[0].trim();
                logger.debug((Object)("content: " + line + " | id: " + id));
                ids.add(id);
            }
            logger.info((Object)("ids: " + ids));
            response.putValue(PARAM_ID_LIST, ids);
        }
        return response;
    }
}

