/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;

public class ListIterator
extends AbstractMessageDispatcher {
    protected static final String HAS_NEXT = "hasNext";
    protected static final String NEXT = "next";
    protected static final String ELEMENT = "element";
    protected static final String INDEX = "index";
    protected static final String LIST = "list";

    public ListIterator(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = this.createAckResponse();
        List<String> list = this.getListParameter(LIST);
        int i = this.getIntegerParameter(INDEX);
        if (i < 0 || i >= list.size()) {
            throw new DispatcherException("Index out of bounds: " + i);
        }
        response.putValue(ELEMENT, list.get(i));
        response.putValue(NEXT, (Object)(i + 1));
        response.putValue(HAS_NEXT, (Object)(i < list.size() - 1 ? 1 : 0));
        return response;
    }
}

