/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.AbstractMessageDispatcher;
import com.tandbergtv.workflow.device.utilities.GetSetting;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.web.neptune.NeptuneSettingsProvider;
import org.apache.log4j.Logger;

public class UpdateSetting
extends AbstractMessageDispatcher {
    private static final String SETTINGS_PATH = "settingspath";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final Logger logger = Logger.getLogger(GetSetting.class);

    public UpdateSetting(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        WorkflowMessage response = null;
        try {
            response = this.createAckResponse();
            String name = this.getParameter(NAME);
            String settingsPath = this.getParameter(SETTINGS_PATH);
            String value = this.getParameter(VALUE);
            logger.debug((Object)("SettingPath (aka SettingGroup) " + settingsPath + ", name (aka path) " + name + ", value (aka setting value) " + value));
            this.updateSetting(settingsPath, name, value);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return response;
    }

    private void updateSetting(String settingGroup, String name, String value) throws Exception {
        NeptuneSettingsProvider settingProvider = new NeptuneSettingsProvider();
        settingProvider.saveSingleSetting(settingGroup, name, value);
    }
}

