/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities.commondistribution;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.commondistribution.CommonDistributionPreferenceBase;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GetActualLookupKeysForDistribution
extends CommonDistributionPreferenceBase {
    protected static final String ACTUAL_LOOKUP_KEYS = "actualLookupKeys";
    protected static final String IS_METADATA_INCLUDED = "isMetadataIncluded";

    public GetActualLookupKeysForDistribution(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        Util.validateRequired((WorkflowMessage)this.getRequest(), (String[])new String[]{"lookupKeyType"});
        WorkflowMessage response = this.createAckResponse();
        String lookupKeyType = this.getParameter("lookupKeyType");
        String siteLookupKeys = this.getParameter("siteLookupKeys");
        String configuredLookupKeys = this.getParameter("configuredLookupKeys");
        List<Object> siteLookupKeyList = new ArrayList();
        if (siteLookupKeys != null && !siteLookupKeys.isEmpty()) {
            siteLookupKeyList = Arrays.asList(siteLookupKeys.split(",\\s*"));
        }
        List<Object> configuredLookupKeyList = new ArrayList();
        if (configuredLookupKeys != null && !configuredLookupKeys.isEmpty()) {
            configuredLookupKeyList = Arrays.asList(configuredLookupKeys.split(",\\s*"));
        }
        ArrayList<String> actualLookupKeys = new ArrayList<String>();
        boolean isMetadataIncluded = false;
        for (String configuredLookupKey : configuredLookupKeyList) {
            if (configuredLookupKey.equals("SITE_CONFIGURED")) {
                if (lookupKeyType.equals("PLATFORM_KEY")) continue;
                for (String string : siteLookupKeyList) {
                    if (actualLookupKeys.contains(string)) continue;
                    actualLookupKeys.add(string);
                }
                continue;
            }
            if (configuredLookupKey.equals("METADATA")) {
                isMetadataIncluded = true;
                continue;
            }
            if (actualLookupKeys.contains(configuredLookupKey)) continue;
            actualLookupKeys.add(configuredLookupKey);
        }
        response.putValue(ACTUAL_LOOKUP_KEYS, this.getCVSString(actualLookupKeys));
        response.putValue(IS_METADATA_INCLUDED, (Object)isMetadataIncluded);
        return response;
    }
}

