/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities.commondistribution;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.commondistribution.CommonDistributionPreferenceBase;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class GetAssetOutputFilesTypeForDistribution
extends CommonDistributionPreferenceBase {
    protected static final String TRANSCODE_PROFILE = "transcodeProfile";
    protected static final String PLATFORM = "platform";
    protected static final String OUTPUT_TYPE = "outputType";

    public GetAssetOutputFilesTypeForDistribution(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        String platformOutputFilesType;
        Util.validateRequired((WorkflowMessage)this.getRequest(), (String[])new String[]{PLATFORM, "distConfigFile", "step"});
        WorkflowMessage response = this.createAckResponse();
        String distConfigFile = this.getParameter("distConfigFile");
        String step = this.getParameter("step");
        String platform = this.getParameter(PLATFORM);
        String transcodeProfiles = this.getParameter(TRANSCODE_PROFILE);
        List<Object> profileList = new ArrayList();
        if (transcodeProfiles != null && !transcodeProfiles.isEmpty()) {
            profileList = Arrays.asList(transcodeProfiles.split(","));
        }
        if ((platformOutputFilesType = this.getPreference(distConfigFile, step + "." + platform + "." + "output.files")) != null && !platformOutputFilesType.isEmpty()) {
            response.putValue(OUTPUT_TYPE, platformOutputFilesType);
            return response;
        }
        String encryptedOutputFilesType = this.getPreference(distConfigFile, step + ".encrypted." + "output.files");
        if (encryptedOutputFilesType != null && !encryptedOutputFilesType.isEmpty()) {
            response.putValue(OUTPUT_TYPE, encryptedOutputFilesType);
            return response;
        }
        String transocdeProfileOutputFilesType = "";
        if (!profileList.isEmpty()) {
            String string;
            String string2;
            Iterator<Object> iterator = profileList.iterator();
            while (iterator.hasNext() && ((transocdeProfileOutputFilesType = this.getPreference(string2 = (string = (String)iterator.next()).trim(), platform + "." + "output.files")) == null || transocdeProfileOutputFilesType.isEmpty())) {
            }
        }
        response.putValue(OUTPUT_TYPE, transocdeProfileOutputFilesType);
        return response;
    }
}

