/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.utilities.commondistribution;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.device.utilities.commondistribution.CommonDistributionPreferenceBase;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GetDirectoryStructureForDistribution
extends CommonDistributionPreferenceBase {
    protected static final String DIR_STRUCTURE = "dirStructure";

    public GetDirectoryStructureForDistribution(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage send() throws Exception {
        String lookupKeyDirectoryStructure;
        Util.validateRequired((WorkflowMessage)this.getRequest(), (String[])new String[]{"lookupKeyType", "lookupKey", "distConfigFile", "step"});
        WorkflowMessage response = this.createAckResponse();
        String distConfigFile = this.getParameter("distConfigFile");
        String step = this.getParameter("step");
        String lookupKey = this.getParameter("lookupKey");
        String lookupKeyType = this.getParameter("lookupKeyType");
        String siteLookupKeys = this.getParameter("siteLookupKeys");
        List<Object> siteLookupKeyList = new ArrayList();
        if (siteLookupKeys != null && !siteLookupKeys.isEmpty()) {
            siteLookupKeyList = Arrays.asList(siteLookupKeys.split(","));
        }
        if ((lookupKeyDirectoryStructure = this.getPreference(distConfigFile, step + "." + lookupKey + "." + "directorystructure")) != null) {
            response.putValue(DIR_STRUCTURE, lookupKeyDirectoryStructure);
            return response;
        }
        String siteConfiguredDirectoryStructure = this.getPreference(distConfigFile, step + "." + "SITE_CONFIGURED" + "." + "directorystructure");
        if (siteConfiguredDirectoryStructure != null && !lookupKeyType.equals("PLATFORM_KEY") && siteLookupKeyList.contains(lookupKey)) {
            response.putValue(DIR_STRUCTURE, siteConfiguredDirectoryStructure);
            return response;
        }
        response.putValue(DIR_STRUCTURE, "");
        return response;
    }
}

