/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.studio.action;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.device.adhoc.action.AdhocActionConstants;
import com.tandbergtv.workflow.device.adhoc.action.AdhocVariableFunctionsExecutor;
import com.tandbergtv.workflow.device.studio.action.Constants;
import com.tandbergtv.workflow.device.studio.action.VariableFunctionsExecutor;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import org.apache.log4j.Logger;

public class VariableFunctionsAdaptor
implements IAdaptor {
    private static final Logger logger = Logger.getLogger(VariableFunctionsAdaptor.class);
    private IAdaptorConfiguration conf = null;

    public void destroy() {
    }

    public boolean canDeliver(IAdaptorRequest request) {
        try {
            WorkflowMessage message = new WPCLConverter().convert(request.getMessage());
            if (Constants.MESSAGE_LIST.contains(message.getMessageUID().getUID())) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to handle message " + request.getMessage().getPayload().getContent()), (Throwable)ex);
        }
        return false;
    }

    public void init(IAdaptorConfiguration conf) {
        this.conf = conf;
        logger.info((Object)"Variable Function Resource Type initialized");
    }

    public IAdaptorResponse transmit(IAdaptorRequest request) throws AdaptorException {
        WorkflowMessage message = null;
        try {
            message = new WPCLConverter().convert(request.getMessage());
        }
        catch (Exception e) {
            throw new AdaptorException((Throwable)e);
        }
        WorkflowMessage responseMessage = null;
        responseMessage = AdhocActionConstants.MESSAGE_LIST.contains(message.getMessageUID().getUID()) ? AdhocVariableFunctionsExecutor.execute(message) : VariableFunctionsExecutor.execute(message);
        try {
            return new AdaptorResponseImpl(new WPCLConverter().convert(responseMessage));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new AdaptorException("Problem sending response message.");
        }
    }
}

