/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.studio.action;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.WorkflowCreationMessageDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VariableFunctionsExecutor {
    private static final Logger logger = Logger.getLogger(VariableFunctionsExecutor.class);
    private static final String STRING = "string";
    private static final String LIST = "list";
    private static final String REGEX = ",";
    public static final String ERROR_MESSAGE = "error-message";
    private static final String NEW_LIST = "newlist";
    private static final String REMOVE_LIST = "removeList";
    private static final String KEY_LIST = "keylist";
    private static final String VALUE_LIST = "valuelist";
    private static final String NEW_KEY_LIST = "newKeylist";
    private static final String NEW_VALUE_LIST = "newValuelist";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String INDEX = "index";
    private static final String CREATE_COMMAND = "create";
    private static final String MESSAGE_UID = "120106";

    public static WorkflowMessage execute(WorkflowMessage message) {
        String UID = message.getMessageUID().getUID();
        if (UID.equals("01VF03")) {
            return VariableFunctionsExecutor.addStringToList(message);
        }
        if (UID.equals("01VF04")) {
            return VariableFunctionsExecutor.addUniqueStringToList(message);
        }
        if (UID.equals("01VF02")) {
            return VariableFunctionsExecutor.copyIntVariables(message);
        }
        if (UID.equals("01VF08")) {
            return VariableFunctionsExecutor.copyListVariable(message);
        }
        if (UID.equals("01VF07")) {
            return VariableFunctionsExecutor.copyMixedVariables(message);
        }
        if (UID.equals("01VF01")) {
            return VariableFunctionsExecutor.copyStringVariables(message);
        }
        if (UID.equals("01VF06")) {
            return VariableFunctionsExecutor.deleteItemFromListAtIndex(message);
        }
        if (UID.equals("01VF05")) {
            return VariableFunctionsExecutor.deleteStringFromList(message);
        }
        if (UID.equals("01VF09") || UID.equals("01VF11")) {
            return VariableFunctionsExecutor.copyStringVariable(message);
        }
        if (UID.equals("01VF10")) {
            return VariableFunctionsExecutor.listContains(message);
        }
        if (UID.equals("01VF12")) {
            return VariableFunctionsExecutor.joinList(message);
        }
        if (UID.equals("01VF13")) {
            return VariableFunctionsExecutor.logVariable(message);
        }
        if (UID.equals("01VF14")) {
            return VariableFunctionsExecutor.triggerTemplate(message);
        }
        if (UID.equals("01VF15")) {
            return VariableFunctionsExecutor.getMapValueFromList(message);
        }
        if (UID.equals("01VF16")) {
            return VariableFunctionsExecutor.putMapValueIntoList(message);
        }
        if (UID.equals("01VF17")) {
            return VariableFunctionsExecutor.sortList(message);
        }
        if (UID.equals("01VF18")) {
            return VariableFunctionsExecutor.deleteFromList(message);
        }
        if (UID.equals("01VF19")) {
            return VariableFunctionsExecutor.reverseList(message);
        }
        throw new RuntimeException("Message UID \"" + UID + "\" cannot be processed.");
    }

    private static WorkflowMessage triggerTemplate(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            WorkflowMessage wpclMessage = WorkflowMessageFactory.createControlMessage((String)MESSAGE_UID);
            VariableFunctionsExecutor.fillCommandParameters(message, wpclMessage);
            VariableFunctionsExecutor.fillSimpleParameters(message, wpclMessage);
            VariableFunctionsExecutor.getRabbitServiceDispatcher();
            WorkflowCreationMessageDispatcher.send((ComponentType)ComponentType.RESOURCE_01VF14, (WorkflowMessage)wpclMessage);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.triggerTemplate() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static void fillSimpleParameters(WorkflowMessage message, WorkflowMessage wpclMessage) {
        Object titleId = message.getParameterValue("titleId");
        wpclMessage.putValue("titleId", titleId);
        Object providerId = message.getParameterValue("providerId");
        wpclMessage.putValue("providerId", providerId);
        for (int i = 1; i < 12; ++i) {
            String name = (String)message.getParameterValue("parameterName" + i);
            Object value = message.getParameterValue("parameterValue" + i);
            if (!StringUtils.isNotEmpty((String)name)) continue;
            wpclMessage.putValue(name, value);
        }
    }

    private static void fillCommandParameters(WorkflowMessage message, WorkflowMessage wpclMessage) {
        WPCLCommand createCommand = new WPCLCommand(CREATE_COMMAND);
        createCommand.addParameter("_template", (String)message.getParameterValue("templateName"));
        createCommand.addParameter("priority", (String)message.getParameterValue("priority"));
        wpclMessage.setCommand(createCommand);
    }

    private static WorkflowMessage logVariable(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            String name = message.getValue("name");
            String value = message.getValue("value");
            String level = message.getValue("level").toUpperCase();
            logger.log((Priority)Level.toLevel((String)level), (Object)("Variable \"" + name + "\" = " + value));
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.logVariable() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage joinList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        return null;
    }

    private static WorkflowMessage listContains(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> list = VariableFunctionsExecutor.getListParameter(message, LIST);
            Pattern pattern = Pattern.compile(message.getValue(STRING));
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!pattern.matcher(list.get(i)).matches()) continue;
                responseMessage.putValue(INDEX, (Object)i);
                found = true;
                break;
            }
            if (!found) {
                responseMessage.putValue(INDEX, (Object)-1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.listContains() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage copyStringVariable(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            responseMessage.putValue(TO, message.getValue(FROM));
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.copyStringVariable() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage deleteStringFromList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> list = VariableFunctionsExecutor.getListParameter(message, LIST);
            list.remove(message.getValue(STRING));
            responseMessage.putValue(NEW_LIST, list);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.deleteStringFromList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage deleteItemFromListAtIndex(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> list = VariableFunctionsExecutor.getListParameter(message, LIST);
            list.remove(VariableFunctionsExecutor.getIntParameter(message, INDEX));
            responseMessage.putValue(NEW_LIST, list);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.deleteItemFromListAtIndex() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage copyStringVariables(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            responseMessage.putValue("to1", message.getValue("from1"));
            responseMessage.putValue("to2", message.getValue("from2"));
            responseMessage.putValue("to3", message.getValue("from3"));
            responseMessage.putValue("to4", message.getValue("from4"));
            responseMessage.putValue("to5", message.getValue("from5"));
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.copyStringVariables() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage copyMixedVariables(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            responseMessage.putValue("toint1", message.getValue("fromint1"));
            responseMessage.putValue("toint2", message.getValue("fromint2"));
            responseMessage.putValue("toint3", message.getValue("fromint3"));
            responseMessage.putValue("tostring1", message.getValue("fromstring1"));
            responseMessage.putValue("tostring2", message.getValue("fromstring2"));
            responseMessage.putValue("tostring3", message.getValue("fromstring3"));
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.copyMixedVariables() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage copyListVariable(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            responseMessage.putValue(TO, VariableFunctionsExecutor.getListParameter(message, FROM));
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.copyListVariable() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage copyIntVariables(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            responseMessage.putValue("to1", message.getValue("from1"));
            responseMessage.putValue("to2", message.getValue("from2"));
            responseMessage.putValue("to3", message.getValue("from3"));
            responseMessage.putValue("to4", message.getValue("from4"));
            responseMessage.putValue("to5", message.getValue("from5"));
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.copyIntVariables() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage addUniqueStringToList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> list = VariableFunctionsExecutor.getListParameter(message, LIST);
            String s = message.getValue(STRING);
            if (!list.contains(s)) {
                list.add(s);
            }
            responseMessage.putValue(NEW_LIST, list);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.addUniqueStringToList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage addStringToList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> list = VariableFunctionsExecutor.getListParameter(message, LIST);
            list.add(message.getValue(STRING));
            responseMessage.putValue(NEW_LIST, list);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.addStringToList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage getMapValueFromList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> keylist = VariableFunctionsExecutor.getListParameter(message, KEY_LIST);
            List<String> valuelist = VariableFunctionsExecutor.getListParameter(message, VALUE_LIST);
            String key = message.getValue("key");
            int matchedIndex = -1;
            for (int i = 0; i < keylist.size(); ++i) {
                if (!keylist.get(i).equals(key)) continue;
                matchedIndex = i;
                break;
            }
            if (matchedIndex > -1) {
                responseMessage.putValue("value", valuelist.get(matchedIndex));
            } else {
                responseMessage.putValue("value", "");
            }
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.getMapValueFromList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage putMapValueIntoList(WorkflowMessage message) {
        List<String> keylist = VariableFunctionsExecutor.getListParameter(message, KEY_LIST);
        List<String> valuelist = VariableFunctionsExecutor.getListParameter(message, VALUE_LIST);
        String key = message.getValue("key");
        String value = message.getValue("value");
        keylist.add(key);
        valuelist.add(value);
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        responseMessage.putValue(NEW_KEY_LIST, keylist);
        responseMessage.putValue(NEW_VALUE_LIST, valuelist);
        return responseMessage;
    }

    private static WorkflowMessage sortList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> origList = VariableFunctionsExecutor.getListParameter(message, LIST);
            if (!origList.isEmpty()) {
                Collections.sort(origList);
                responseMessage.putValue(NEW_LIST, origList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.sortList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage deleteFromList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> origList = VariableFunctionsExecutor.getListParameter(message, LIST);
            List<String> removeList = VariableFunctionsExecutor.getListParameter(message, REMOVE_LIST);
            String strings = VariableFunctionsExecutor.getStringParameter(message, STRING);
            if (!origList.isEmpty() && !removeList.isEmpty()) {
                origList.removeAll(removeList);
            }
            if (!origList.isEmpty() && !strings.isEmpty()) {
                String[] list;
                for (String item : list = strings.split(REGEX)) {
                    origList.remove(item.trim());
                }
                origList.removeAll(removeList);
            }
            responseMessage.putValue(NEW_LIST, origList);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.sortList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static WorkflowMessage reverseList(WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        try {
            List<String> origList = VariableFunctionsExecutor.getListParameter(message, LIST);
            Collections.reverse(origList);
            responseMessage.putValue(NEW_LIST, origList);
        }
        catch (Exception e) {
            logger.error((Object)"VariableFunctionsExecutor.reverseList() encountered error!", (Throwable)e);
            responseMessage.setType(WorkflowMessage.MessageType.nack);
            responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        }
        return responseMessage;
    }

    private static ArrayList<String> getList(List<String> list) {
        ArrayList<String> array = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            array.add(list.get(i).trim());
        }
        return array;
    }

    private static ArrayList<String> getList(String string) {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        String[] array = string.split(REGEX);
        if (array == null || array.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            arrayList.add(array[i].trim());
        }
        return arrayList;
    }

    private static List<String> getListParameter(WorkflowMessage message, String name) {
        try {
            return VariableFunctionsExecutor.getList((List)message.getParameterValue(name));
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private static int getIntParameter(WorkflowMessage message, String name) {
        try {
            return Integer.valueOf((String)message.getParameterValue(name));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static String getStringParameter(WorkflowMessage message, String name) {
        try {
            return (String)message.getParameterValue(name);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static WorkflowCreationMessageDispatcher getRabbitServiceDispatcher() {
        return (WorkflowCreationMessageDispatcher)ServiceRegistry.getDefault().lookup("com.tandbergtv.workflow.message.producer.CreationMessageDispatcher");
    }
}

