/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.graphics.ChartTextStyle;
import chart.properties.ChartLabelProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class ChartLabelBase {
    public static final int LEFT_TOP = 0;
    public static final int LEFT_CENTER = 1;
    public static final int LEFT_BOTTOM = 2;
    public static final int RIGHT_TOP = 3;
    public static final int RIGHT_CENTER = 4;
    public static final int RIGHT_BOTTOM = 5;
    public static final int CENTER_TOP = 6;
    public static final int CENTER_BOTTOM = 7;
    private ChartLabelProperties QOIV;
    private Dimension ceil;
    private float clone = 0.0f;
    private float cos = 0.0f;
    private float drawText = 0.0f;
    private float getDimension = 0.0f;
    private boolean getHeight;
    private boolean getIcon;
    private float getIconAlignment = 0.0f;

    public ChartLabelBase(ChartLabelProperties chartLabelProperties) {
        this.QOIV = chartLabelProperties;
        this.ceil();
        this.getHeight = false;
    }

    public ChartLabelBase(String string) {
        this.QOIV = new ChartLabelProperties();
        this.QOIV.setText(string);
        this.getHeight = false;
    }

    public ChartLabelBase(String string, ChartLabelProperties chartLabelProperties) {
        this.QOIV = chartLabelProperties;
        this.QOIV.setText(string);
        this.getHeight = false;
    }

    public void locate() {
        this.QOIV();
        float f = 0.0f;
        float f2 = 0.0f;
        this.clone = 0.0f;
        this.cos = 0.0f;
        this.drawText = 0.0f;
        this.getDimension = 0.0f;
        ChartTextStyle chartTextStyle = this.QOIV.getTextStyle();
        String string = this.QOIV.getText();
        Rectangle2D.Float float_ = (Rectangle2D.Float)chartTextStyle.getDimension(string);
        float f3 = float_.width;
        float f4 = float_.height;
        if (this.QOIV.getIcon() != null) {
            f = this.QOIV.getIcon().getIconWidth();
            f2 = this.QOIV.getIcon().getIconHeight();
        }
        if (chartTextStyle.getUnderline() != 0 && chartTextStyle.getRotation() == 0.0) {
            this.getIcon = true;
            this.getIconAlignment = chartTextStyle.getUnderlineHeight();
            f4 += this.getIconAlignment;
        }
        if (chartTextStyle.getRotation() == 0.0) {
            this.cos = chartTextStyle.getWordWrapper() ? (float)((int)Math.ceil(chartTextStyle.getWordWrapFristLineHeight())) : f4;
        } else {
            double d = Math.PI;
            double d2 = chartTextStyle.getRotation();
            d2 = d2 < 0.0 ? d * 2.0 + d2 % (d * 2.0) : d2 % (d * 2.0);
            String string2 = "";
            ChartTextStyle chartTextStyle2 = (ChartTextStyle)chartTextStyle.clone();
            chartTextStyle2.setRotation(0.0);
            if (string != null && string.length() > 1) {
                string2 = string.substring(0, 1);
            }
            double d3 = chartTextStyle2.getDimension(string2).getHeight();
            double d4 = d2 / Math.PI * 180.0;
            if (d4 != 0.0) {
                if (d4 <= 90.0) {
                    this.cos += (float)Math.ceil(d3 * Math.cos(d2));
                } else if (d4 > 90.0 && d4 <= 180.0) {
                    this.clone += f3;
                    this.cos += (float)Math.ceil(-d3 * Math.cos(d2));
                } else if (d4 > 180.0 && d4 <= 270.0) {
                    this.clone += f3;
                    this.cos += f4 - (float)Math.ceil(-d3 * Math.cos(d2));
                } else if (d4 > 270.0) {
                    this.clone += (float)Math.ceil(-d3 * Math.sin(d2));
                    this.cos += f4;
                }
            }
        }
        int n = (int)this.QOIV.getIconTextGap();
        float f5 = f3;
        float f6 = f4;
        if (this.QOIV.getIcon() != null && !this.QOIV.getIcon().isNoIcon()) {
            f5 = f3 + f + (float)n;
            f6 = f2 + f4;
            switch (this.QOIV.getIconAlignment()) {
                case 0: {
                    this.clone += f + (float)n;
                    this.cos += f2;
                    break;
                }
                case 1: {
                    this.clone += f + (float)n;
                    float f7 = f6 = f2 < f4 ? f2 : f4;
                    if (f4 > f2) {
                        this.getDimension += (f4 - f2) / 2.0f;
                        f6 = f4;
                        break;
                    }
                    this.cos += (f2 - f4) / 2.0f;
                    f6 = f2;
                    break;
                }
                case 2: {
                    this.getDimension += f4;
                    this.clone += f + (float)n;
                    break;
                }
                case 6: {
                    this.cos += f2 + (float)n;
                    f6 += (float)n;
                    if (f > f3) {
                        this.clone += (f - f3) / 2.0f;
                        f5 = f;
                        break;
                    }
                    this.drawText += (f3 - f) / 2.0f;
                    f5 = f3;
                    break;
                }
                case 7: {
                    this.getDimension += f4 + (float)n;
                    f6 += (float)n;
                    if (f > f3) {
                        this.clone += (f - f3) / 2.0f;
                        f5 = f;
                        break;
                    }
                    this.drawText = (f3 - f) / 2.0f;
                    f5 = f3;
                    break;
                }
                case 3: {
                    this.drawText = f3 + (float)n;
                    this.cos += f2;
                    break;
                }
                case 4: {
                    this.drawText = f3 + (float)n;
                    if (f2 > f4) {
                        this.cos += (f2 - f4) / 2.0f;
                        f6 = f2;
                        break;
                    }
                    this.getDimension += (f4 - f2) / 2.0f;
                    f6 = f4;
                    break;
                }
                case 5: {
                    this.drawText = f3 + (float)n;
                    this.getDimension += f4;
                    break;
                }
            }
        }
        this.ceil.width = (int)f5;
        this.ceil.height = (int)f6;
        this.getHeight = true;
    }

    public void paint(Graphics2D graphics2D, float f, float f2) {
        if (!this.getHeight) {
            this.locate();
        }
        if (this.QOIV.getIcon() != null) {
            this.QOIV.getIcon().paintIcon(graphics2D, (int)(f + this.drawText), (int)(f2 + this.getDimension));
        }
        if (this.getIcon) {
            this.QOIV.getTextStyle().drawText(graphics2D, this.QOIV.getText(), f + this.clone, f2 + this.cos - this.getIconAlignment);
        } else {
            this.QOIV.getTextStyle().drawText(graphics2D, this.QOIV.getText(), f + this.clone, f2 + this.cos);
        }
    }

    public void paintTextNoRotation(Graphics2D graphics2D, float f, float f2) {
        if (!this.getHeight) {
            this.locate();
        }
        this.QOIV.getTextStyle().drawText(graphics2D, this.QOIV.getText(), f, f2);
    }

    private void QOIV() {
        this.getHeight = false;
        this.ceil = new Dimension();
    }

    private void ceil() {
        if (this.QOIV.getText() == null) {
            this.QOIV.setText("");
        }
    }

    public Dimension getLabelBaseDimension() {
        return this.ceil;
    }

    public boolean isNoIcon() {
        return this.QOIV.getIcon() == null || this.QOIV.getIcon().isNoIcon();
    }

    public ChartTextStyle getChartTextStyle() {
        return this.QOIV.getTextStyle();
    }

    public void setChartTextStyle(ChartTextStyle chartTextStyle) {
        this.getHeight = false;
        this.QOIV.setTextStyle(chartTextStyle);
    }

    public String getLabelText() {
        return this.QOIV.getText();
    }

    public void setLabelText(String string) {
        this.getHeight = false;
        this.QOIV.setText(string);
    }

    public ChartLabelProperties getLabelBaseProperties() {
        return this.QOIV;
    }

    public void setLabelBaseProperties(ChartLabelProperties chartLabelProperties) {
        this.QOIV = chartLabelProperties;
        this.getHeight = false;
        this.ceil();
    }
}

