/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Graph2DBubble
extends Chart2DObject {
    private Shape[] append;
    private Shape[][] availableValue;
    private ChartPenStyle availableValueX;
    private float black;
    private float contains;
    private int draw;
    private int drawBubble;
    private float fill;
    private float floatValue;
    private float[][] getAxisX;
    private float[][] getBackground;
    private float[] getCategoryName;
    private float[] getCategoryNmae;
    private float[][] getCategorySize;
    private float getColor;
    private double getContourPen;
    private String[][][] getEndColor;

    Graph2DBubble(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        int n;
        super.init();
        this.availableValueX = this.objectProperties.getContourPen();
        this.draw = this.dataset.getSeriesSize();
        this.drawBubble = this.dataset.getCategorySize();
        this.fill = this.layer.I();
        this.floatValue = this.layer.Z();
        this.getCategoryName = new float[this.draw * this.drawBubble];
        this.getCategoryNmae = new float[this.draw * this.drawBubble];
        this.getAxisX = new float[this.draw * this.drawBubble][2];
        this.getBackground = new float[this.draw * this.drawBubble][2];
        this.getCategorySize = new float[this.draw * this.drawBubble][2];
        this.availableValue = new Shape[this.draw][this.drawBubble];
        this.append = new Shape[this.draw];
        this.getEndColor = new String[this.draw][this.drawBubble][3];
        int n2 = 0;
        while (n2 < this.draw) {
            int n3 = 0;
            while (n3 < this.drawBubble) {
                this.availableValue[n2][n3] = new GeneralPath();
                ++n3;
            }
            this.append[n2] = new GeneralPath();
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < this.draw) {
            n = 0;
            while (n < this.drawBubble) {
                Number number = ((Chart3DDataSet)this.dataset).getX(n4, n);
                if (this.layer.isShowCategoryAndSeries()) {
                    this.getEndColor[n4][n] = this.hintLabelShowCategoryAndSeries(5, n4, n, number);
                } else {
                    if (number != null) {
                        this.getCategorySize[n4 * this.drawBubble + n][0] = number.floatValue();
                        stringBuffer.append("X: ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getEndColor[n4][n][0] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart3DDataSet)this.dataset).getY(n4, n)) != null) {
                        this.getCategorySize[n4 * this.drawBubble + n][1] = number.floatValue();
                        stringBuffer.append("Y: ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getEndColor[n4][n][1] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart3DDataSet)this.dataset).getZ(n4, n)) != null) {
                        this.getCategoryName[n4 * this.drawBubble + n] = number.floatValue();
                        stringBuffer.append("R: ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getEndColor[n4][n][2] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                }
                this.getColor = this.getColor < this.getCategoryName[n4 * this.drawBubble + n] ? this.getCategoryName[n4 * this.drawBubble + n] : this.getColor;
                ++n;
            }
            ++n4;
        }
        this.black = (float)((ChartNumericAxis)this.layer.getAxisX()).getMax();
        this.contains = (float)((ChartNumericAxis)this.layer.getAxisX()).getMin();
        this.getContourPen = ((ChartNumericAxis)this.layer.getAxisX()).getTickPace();
        n = 0;
        while (n < this.draw) {
            int n5 = 0;
            while (n5 < this.drawBubble) {
                this.getAxisX[n * this.drawBubble + n5][0] = this.fill * this.layer.availableValueX(this.getCategorySize[n * this.drawBubble + n5][0]);
                this.getAxisX[n * this.drawBubble + n5][1] = this.floatValue * this.layer.availableValue(this.getCategorySize[n * this.drawBubble + n5][1]);
                if (this.getColor == 0.0f) {
                    this.getColor = 1.0f;
                }
                this.getCategoryNmae[n * this.drawBubble + n5] = (float)((double)(this.getCategoryName[n * this.drawBubble + n5] / this.getColor) * this.getContourPen * (double)this.fill);
                ++n5;
            }
            ++n;
        }
    }

    public void locate() {
        int n;
        int n2 = 0;
        while (n2 < this.draw) {
            n = 0;
            while (n < this.drawBubble) {
                ((GeneralPath)this.availableValue[n2][n]).reset();
                ++n;
            }
            ((GeneralPath)this.append[n2]).reset();
            ++n2;
        }
        this.layer.I(this.getAxisX, this.getBackground);
        n = 0;
        while (n < this.draw) {
            int n3 = 0;
            while (n3 < this.drawBubble) {
                if (((Chart3DDataSet)this.dataset).getX(n, n3) != null && ((Chart3DDataSet)this.dataset).getY(n, n3) != null && ((Chart3DDataSet)this.dataset).getZ(n, n3) != null && !(this.getCategoryNmae[n * this.drawBubble + n3] < 0.0f)) {
                    this.availableValue[n][n3] = new GeneralPath(new Arc2D.Double(this.getBackground[n * this.drawBubble + n3][0] - (float)((int)this.getCategoryNmae[n * this.drawBubble + n3]) / 2.0f, this.getBackground[this.drawBubble * n + n3][1] - this.getCategoryNmae[n * this.drawBubble + n3] / 2.0f, this.getCategoryNmae[n * this.drawBubble + n3], this.getCategoryNmae[n * this.drawBubble + n3], 0.0, 360.0, 0));
                    ((GeneralPath)this.append[n]).append(this.availableValue[n][n3], false);
                }
                ++n3;
            }
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.draw) {
            this.drawBubble(graphics2D, n);
            ++n;
        }
    }

    public void drawBubble(Graphics2D graphics2D, int n) {
        boolean bl = true;
        if (this.seriesPattern[n] != null) {
            int n2 = 0;
            while (n2 < this.drawBubble) {
                if (this.objectProperties.isUse3DEffect()) {
                    Color color = Color.black;
                    if (this.seriesPattern[n] instanceof ChartColorPattern) {
                        color = ((ChartColorPattern)this.seriesPattern[n]).getColor();
                    } else if (this.seriesPattern[n] instanceof ChartGradientPattern) {
                        color = ((ChartGradientPattern)this.seriesPattern[n]).getEndColor().getColor();
                    } else if (this.seriesPattern[n] instanceof ChartTexturePattern) {
                        color = ((ChartTexturePattern)this.seriesPattern[n]).getBackground().getColor();
                    }
                    ChartColorPattern chartColorPattern = new ChartColorPattern(Color.white);
                    ChartColorPattern chartColorPattern2 = new ChartColorPattern(color);
                    Point2D.Float float_ = new Point2D.Float(0.28f, 0.19f);
                    Point2D.Float float_2 = new Point2D.Float(0.98f, 0.75f);
                    ChartGradientPattern chartGradientPattern = new ChartGradientPattern(3, false, chartColorPattern, float_, chartColorPattern2, float_2);
                    chartGradientPattern.fill(graphics2D, this.availableValue[n][n2]);
                    bl = false;
                } else {
                    this.seriesPattern[n].fill(graphics2D, this.availableValue[n][n2]);
                }
                ++n2;
            }
        }
        if (this.objectProperties.isContour() && bl) {
            this.availableValueX.draw(graphics2D, this.append[n]);
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    public Shape getShapeBySeries(int n) {
        return this.append[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.availableValue[n][n2];
    }

    public Shape[][] getItemShapes() {
        return this.availableValue;
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = this.draw - 1;
        while (n3 >= 0) {
            int n4 = this.drawBubble - 1;
            while (n4 >= 0) {
                if (this.availableValue[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.getEndColor[n3][n4];
                }
                --n4;
            }
            --n3;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.append.length) {
            if (this.append[n3].contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public String[] hintLabelShowCategoryAndSeries(int n, int n2, int n3, Number number) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[n];
        stringBuffer.append(this.paper.model.getCategoryNmae() + ": ");
        stringBuffer.append(this.dataset.getFormatedHintCategoryValue(this.paper.model.getCategoryName(n3), n3));
        stringArray[0] = stringBuffer.toString();
        stringBuffer.setLength(0);
        if (this.paper.model.getSeriesN() != null) {
            stringBuffer.append(this.paper.model.getSeriesN() + ": ");
            stringBuffer.append(this.dataset.getFormatedHintSeriesValue(this.paper.model.getSeriesName(n2 % this.paper.model.getSeriesNames().size()), n2 % this.paper.model.getSeriesNames().size()));
            stringArray[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
        } else {
            stringArray[1] = "";
            stringBuffer.setLength(0);
        }
        if (number != null) {
            this.getCategorySize[n2 * this.drawBubble + n3][0] = number.floatValue();
            stringBuffer.append("X: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if ((number = ((Chart3DDataSet)this.dataset).getY(n2, n3)) != null) {
            this.getCategorySize[n2 * this.drawBubble + n3][1] = number.floatValue();
            stringBuffer.append("Y: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[3] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if ((number = ((Chart3DDataSet)this.dataset).getZ(n2, n3)) != null) {
            this.getCategoryName[n2 * this.drawBubble + n3] = number.floatValue();
            stringBuffer.append("R: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[4] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray;
    }
}

