/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageBall;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Graph2DGuageBalls
extends Chart2DObject {
    Graph2DGuageBall[][] append;
    ChartLabelBase[] contains;
    ChartLabelBase[] draw;
    String[][][] drawCategoryNames;
    float[] equals;
    float[] floatValue;
    float[][] getAxisXProperties;
    private Shape[] getAxisY;
    private Shape[][] getAxisZProperties;
    int getBounds;
    int getCategorySize;
    float[][] getChartDataSetModel;
    float[][] getContourPen;
    boolean[][] getFilteredCategoryNames;
    ChartGradientPattern[][] getFilteredSeriesNames;
    Color[] getFormatedHintValue;
    int getGaugeAlertColor;
    int getGaugeAlertValueMax;
    Line2D[] getGaugeAlertValueMin;
    Line2D[] getGaugeErrorColor;
    float[][] getGaugeErrorValueMax;
    float[][] getGaugeErrorValueMin;
    float getGaugeNormalColor;
    float getGaugeNormalValueMax;

    Graph2DGuageBalls(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        super.init();
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.getBounds = bl ? 3 : this.dataset.getSeriesSize();
        this.getCategorySize = this.dataset.getCategorySize();
        if (this.getBounds == 0 || this.getCategorySize == 0) {
            return;
        }
        this.getGaugeNormalColor = this.paper.getProperties().getScaleX() == 1.0f ? 1.0f : this.paper.getProperties().getScaleX();
        this.getGaugeNormalValueMax = this.paper.getProperties().getScaleY() == 1.0f ? 1.0f : this.paper.getProperties().getScaleY();
        this.QOIV();
        this.append();
        this.contains();
        this.dataset();
        this.drilldown();
        this.append = new Graph2DGuageBall[this.getBounds][this.getCategorySize];
        this.getAxisY = new Shape[this.getBounds];
        this.getAxisZProperties = new Shape[this.getBounds][this.getCategorySize];
        this.getChartDataSetModel = new float[this.getBounds][this.getCategorySize];
        this.getContourPen = new float[this.getBounds][this.getCategorySize];
        int n = 0;
        while (n < this.getBounds) {
            int n2 = 0;
            while (n2 < this.getCategorySize) {
                this.append[n][n2] = new Graph2DGuageBall();
                this.append[n][n2].setContour(this.objectProperties.isContour());
                this.append[n][n2].setContourPen(this.objectProperties.getContourPen());
                ++n2;
            }
            ++n;
        }
    }

    private void QOIV() {
        this.getFormatedHintValue = new Color[3];
        this.getFormatedHintValue[0] = this.objectProperties.getGaugeNormalColor();
        this.getFormatedHintValue[1] = this.objectProperties.getGaugeAlertColor();
        this.getFormatedHintValue[2] = this.objectProperties.getGaugeErrorColor();
    }

    private void append() {
        int n;
        int n2;
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        String[] stringArray2 = this.dataset.getChartDataSetModel().getFilteredSeriesNames();
        if (stringArray != null) {
            n2 = stringArray.length;
            this.contains = new ChartLabelBase[n2];
            n = 0;
            while (n < n2) {
                this.contains[n] = new ChartLabelBase(stringArray[n]);
                this.contains[n].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
                ++n;
            }
        }
        if (stringArray2 != null) {
            n2 = stringArray2.length;
            this.draw = new ChartLabelBase[n2];
            n = 0;
            while (n < n2) {
                this.draw[n] = new ChartLabelBase(stringArray2[n]);
                this.draw[n].setChartTextStyle(this.paper.getProperties().getAxisZProperties().getLabelTextStyle());
                ++n;
            }
        }
    }

    private void contains() {
        float f;
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f3 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.equals = new float[3];
        this.floatValue = new float[3];
        this.equals[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.equals[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.equals[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.floatValue[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.floatValue[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.floatValue[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        int n = 0;
        while (n < 3) {
            if (this.equals[n] > this.floatValue[n]) {
                f = this.equals[n];
                this.equals[n] = this.floatValue[n];
                this.floatValue[n] = f;
            }
            bl = this.floatValue[n] == this.floatValue[n] && this.floatValue[n] == 0.0f && bl;
            ++n;
        }
        if (bl) {
            f = (f2 - f3) / 3.0f;
            int n2 = 0;
            while (n2 < 3) {
                this.equals[n2] = f3 + (float)n2 * f;
                this.floatValue[n2] = this.equals[n2] + f;
                ++n2;
            }
        }
    }

    private void dataset() {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.getFilteredCategoryNames = ((Chart1DDataSet)this.dataset).isNullValue();
        if (bl) {
            this.getAxisXProperties = new float[1][this.getCategorySize];
            this.drawCategoryNames = new String[1][this.getCategorySize][3];
            int n = 0;
            while (n < this.getCategorySize) {
                if (!this.getFilteredCategoryNames[0][n]) {
                    Number number = ((Chart1DDataSet)this.dataset).getValue(0, n);
                    this.getAxisXProperties[0][n] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.drawCategoryNames[0][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(0, n);
                    } else {
                        this.drawCategoryNames[0][n][0] = this.dataset.getFormatedHintValue(number);
                    }
                }
                ++n;
            }
        } else {
            this.getAxisXProperties = new float[this.getBounds][this.getCategorySize];
            this.drawCategoryNames = new String[this.getBounds][this.getCategorySize][3];
            int n = 0;
            while (n < this.getBounds) {
                int n2 = 0;
                while (n2 < this.getCategorySize) {
                    if (!this.getFilteredCategoryNames[n][n2]) {
                        Number number = ((Chart1DDataSet)this.dataset).getValue(n, n2);
                        this.getAxisXProperties[n][n2] = number.floatValue();
                        if (this.layer.isShowCategoryAndSeries()) {
                            ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                            this.drawCategoryNames[n][n2] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n, n2);
                        } else {
                            this.drawCategoryNames[n][n2][0] = this.dataset.getFormatedHintValue(number);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void locate() {
        this.drawCategoryNames();
        this.draw();
        int n = 0;
        while (n < this.getBounds) {
            int n2 = 0;
            while (n2 < this.getCategorySize) {
                this.append[n][n2].setArc((Arc2D)this.getAxisZProperties[n][n2]);
                this.append[n][n2].setPattern(this.getFilteredSeriesNames[n][n2]);
                ++n2;
            }
            ++n;
        }
        this.getAxisZProperties();
        this.getBounds();
        this.getAxisXProperties();
        this.getAxisY();
    }

    private void draw() {
        int n;
        if (this.draw != null) {
            n = 0;
            while (n < this.draw.length) {
                this.draw[n].locate();
                ++n;
            }
        }
        if (this.contains != null) {
            n = 0;
            while (n < this.contains.length) {
                this.contains[n].locate();
                ++n;
            }
        }
    }

    private void drawCategoryNames() {
        float f = this.objectProperties.getHorizonalMargin();
        float f2 = this.objectProperties.getVerticalMargin();
        this.getGaugeAlertColor = (int)(((float)this.paper.getBounds().width * this.getGaugeNormalColor - f) / (float)this.getCategorySize);
        this.getGaugeAlertValueMax = (int)(((float)this.paper.getBounds().height * this.getGaugeNormalValueMax - f2) / (float)this.getBounds);
        float f3 = (float)Math.min(this.getGaugeAlertColor / 2, this.getGaugeAlertValueMax / 2) * this.paper.getProperties().getGraphProperties().getRadiusRange();
        float f4 = (float)this.paper.getBounds().width * (1.0f - this.getGaugeNormalColor) / 2.0f;
        float f5 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeNormalValueMax) / 2.0f;
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        int n = 0;
        while (n < this.getBounds) {
            this.getAxisY[n] = new GeneralPath();
            int n2 = 0;
            while (n2 < this.getCategorySize) {
                if (!(bl ? this.getFilteredCategoryNames[0][n2] : this.getFilteredCategoryNames[n][n2])) {
                    this.getChartDataSetModel[n][n2] = f4 + (float)(n2 * this.getGaugeAlertColor) + (float)(this.getGaugeAlertColor / 2) - f3 + f;
                    this.getContourPen[n][n2] = f5 + (float)(n * this.getGaugeAlertValueMax) + (float)(this.getGaugeAlertValueMax / 2) - f3 + f2;
                    this.getAxisZProperties[n][n2] = new Arc2D.Float(this.getChartDataSetModel[n][n2], this.getContourPen[n][n2], 2.0f * f3, 2.0f * f3, 0.0f, 360.0f, 0);
                    ((GeneralPath)this.getAxisY[n]).append(this.getAxisZProperties[n][n2], false);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void drilldown() {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.getFilteredSeriesNames = new ChartGradientPattern[this.getBounds][this.getCategorySize];
        if (bl) {
            this.equals();
        } else {
            this.floatValue();
        }
    }

    private void equals() {
        int n = 0;
        while (n < this.getCategorySize) {
            int n2 = 0;
            while (n2 < 3) {
                if (this.getAxisXProperties[0][n] > this.equals[n2] && this.getAxisXProperties[0][n] <= this.floatValue[n2]) {
                    ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 255, 255));
                    ChartColorPattern chartColorPattern2 = new ChartColorPattern(this.getFormatedHintValue[n2]);
                    this.getFilteredSeriesNames[n2][n] = new ChartGradientPattern(3);
                    this.getFilteredSeriesNames[n2][n].setStartColor(chartColorPattern);
                    this.getFilteredSeriesNames[n2][n].setEndColor(chartColorPattern2);
                } else {
                    this.getFilteredSeriesNames[n2][n] = new ChartGradientPattern(3);
                    this.getFilteredSeriesNames[n2][n].setStartColor(new ChartColorPattern(new Color(255, 255, 255)));
                    this.getFilteredSeriesNames[n2][n].setEndColor(new ChartColorPattern(new Color(0, 0, 0)));
                }
                ++n2;
            }
            ++n;
        }
    }

    private void floatValue() {
        int n = 0;
        while (n < this.getBounds) {
            int n2 = 0;
            while (n2 < this.getCategorySize) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < 3) {
                    if (this.getAxisXProperties[n][n2] > this.equals[n3] && this.getAxisXProperties[n][n2] <= this.floatValue[n3]) {
                        ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 255, 255));
                        ChartColorPattern chartColorPattern2 = new ChartColorPattern(this.getFormatedHintValue[n3]);
                        this.getFilteredSeriesNames[n][n2] = new ChartGradientPattern(3);
                        this.getFilteredSeriesNames[n][n2].setStartColor(chartColorPattern);
                        this.getFilteredSeriesNames[n][n2].setEndColor(chartColorPattern2);
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    this.getFilteredSeriesNames[n][n2] = new ChartGradientPattern(3);
                    this.getFilteredSeriesNames[n][n2].setStartColor(new ChartColorPattern(new Color(255, 255, 255)));
                    this.getFilteredSeriesNames[n][n2].setEndColor(new ChartColorPattern(new Color(0, 0, 0)));
                }
                ++n2;
            }
            ++n;
        }
    }

    private void getAxisXProperties() {
        if (this.contains == null || this.contains.length == 0) {
            return;
        }
        float f = this.paper.getProperties().getGraphProperties().getHorizonalMargin();
        float f2 = this.paper.getProperties().getGraphProperties().getVerticalMargin();
        float f3 = (float)this.paper.getBounds().width * (1.0f - this.getGaugeNormalColor) / 2.0f;
        float f4 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeNormalValueMax) / 2.0f;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisXProperties().getLabelTextStyle();
        this.getGaugeErrorValueMax = new float[this.contains.length][2];
        int n = 0;
        while (n < this.contains.length) {
            if (this.contains[n] != null && !this.contains[n].getLabelText().equals("")) {
                this.contains[n].locate();
                Dimension dimension = this.contains[n].getLabelBaseDimension();
                float f5 = (float)((double)(f3 + f + (float)(n * this.getGaugeAlertColor)) + ((double)this.getGaugeAlertColor - dimension.getWidth()) / 2.0);
                float f6 = f4 + (float)((double)f2 - dimension.getHeight()) / 2.0f;
                this.getGaugeErrorValueMax[n][0] = f5;
                this.getGaugeErrorValueMax[n][1] = f6;
            }
            ++n;
        }
    }

    private void getAxisY() {
        if (this.draw == null || this.draw.length == 0) {
            return;
        }
        float f = this.paper.getProperties().getGraphProperties().getHorizonalMargin();
        float f2 = this.paper.getProperties().getGraphProperties().getVerticalMargin();
        float f3 = (float)this.paper.getBounds().width * (1.0f - this.getGaugeNormalColor) / 2.0f;
        float f4 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeNormalValueMax) / 2.0f;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisZProperties().getLabelTextStyle();
        this.getGaugeErrorValueMin = new float[this.draw.length][2];
        int n = 0;
        while (n < this.draw.length) {
            if (this.draw[n] != null && !this.draw[n].getLabelText().equals("")) {
                this.draw[n].locate();
                Dimension dimension = this.draw[n].getLabelBaseDimension();
                float f5 = (float)((double)f3 + ((double)f - dimension.getWidth()) / 2.0);
                float f6 = (float)((double)(f4 + f2 + (float)(n * this.getGaugeAlertValueMax)) + ((double)this.getGaugeAlertValueMax - dimension.getHeight()) / 2.0);
                this.getGaugeErrorValueMin[n][0] = f5;
                this.getGaugeErrorValueMin[n][1] = f6;
            }
            ++n;
        }
    }

    private void getAxisZProperties() {
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            f = (float)this.paper.getBounds().width * (1.0f - this.getGaugeNormalColor) / 2.0f + (float)this.objectProperties.getHorizonalMargin();
            f2 = f + (float)(this.getCategorySize * this.getGaugeAlertColor);
        } else {
            f = (float)this.paper.getBounds().width * (1.0f - this.getGaugeNormalColor) / 2.0f;
            f2 = f + (float)this.objectProperties.getHorizonalMargin() + (float)(this.getCategorySize * this.getGaugeAlertColor);
        }
        float f3 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeNormalValueMax) / 2.0f;
        float f4 = f3 + (float)this.objectProperties.getVerticalMargin() + (float)(this.getBounds * this.getGaugeAlertValueMax);
        this.getGaugeErrorColor = new Line2D[this.getBounds + 2];
        this.getGaugeErrorColor[0] = new Line2D.Float(f, f3, f2, f3);
        int n = 0;
        while (n < this.getBounds + 1) {
            float f5 = f3 + (float)(n * this.getGaugeAlertValueMax) + (float)this.objectProperties.getVerticalMargin();
            this.getGaugeErrorColor[n + 1] = new Line2D.Float(f, f5, f2, f5);
            ++n;
        }
    }

    private void getBounds() {
        float f = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f2 = f + (float)this.objectProperties.getHorizonalMargin() + (float)(this.getCategorySize * this.getGaugeAlertColor);
        float f3 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeNormalValueMax) / 2.0f;
        float f4 = f3 + (float)this.objectProperties.getVerticalMargin() + (float)(this.getBounds * this.getGaugeAlertValueMax);
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.getGaugeAlertValueMin = new Line2D[this.getCategorySize + 1];
            int n = 0;
            while (n < this.getCategorySize + 1) {
                float f5 = f + (float)(n * this.getGaugeAlertColor) + (float)this.objectProperties.getHorizonalMargin();
                this.getGaugeAlertValueMin[n] = new Line2D.Float(f5, f3, f5, f4);
                ++n;
            }
        } else {
            this.getGaugeAlertValueMin = new Line2D[this.getCategorySize + 2];
            this.getGaugeAlertValueMin[0] = new Line2D.Float(f, f3, f, f4);
            int n = 0;
            while (n < this.getCategorySize + 1) {
                float f6 = f + (float)(n * this.getGaugeAlertColor) + (float)this.objectProperties.getHorizonalMargin();
                this.getGaugeAlertValueMin[n + 1] = new Line2D.Float(f6, f3, f6, f4);
                ++n;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.getBounds) {
            int n2 = 0;
            while (n2 < this.getCategorySize) {
                this.append[n][n2].paint(graphics2D);
                ++n2;
            }
            ++n;
        }
        if (this.paper.getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            this.drawCategoryNames(graphics2D);
        }
        if (this.paper.getProperties().getAxisZProperties().isShowTickMarkLabels()) {
            this.getCategorySize(graphics2D);
        }
        if (this.paper.getProperties().getAxisZProperties().isShowGrid()) {
            this.getChartDataSetModel(graphics2D);
        }
        if (this.paper.getProperties().getAxisXProperties().isShowGrid()) {
            this.getContourPen(graphics2D);
        }
    }

    public void drawCategoryNames(Graphics2D graphics2D) {
        if (this.contains == null || this.contains.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.contains.length) {
            if (this.contains[n] != null && !this.contains[n].getLabelText().equals("")) {
                this.contains[n].locate();
                this.contains[n].paint(graphics2D, this.getGaugeErrorValueMax[n][0], this.getGaugeErrorValueMax[n][1]);
            }
            ++n;
        }
    }

    private void getCategorySize(Graphics2D graphics2D) {
        if (this.draw == null || this.draw.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.draw.length) {
            if (this.draw[n] != null && !this.draw[n].getLabelText().equals("")) {
                this.draw[n].locate();
                this.draw[n].paint(graphics2D, this.getGaugeErrorValueMin[n][0], this.getGaugeErrorValueMin[n][1]);
            }
            ++n;
        }
    }

    private void getChartDataSetModel(Graphics2D graphics2D) {
        int n = this.getGaugeErrorColor.length;
        int n2 = 0;
        while (n2 < n) {
            this.paper.getProperties().getAxisZProperties().getGridPen().draw(graphics2D, this.getGaugeErrorColor[n2]);
            ++n2;
        }
    }

    private void getContourPen(Graphics2D graphics2D) {
        int n = this.getGaugeAlertValueMin.length;
        int n2 = 0;
        while (n2 < n) {
            this.paper.getProperties().getAxisXProperties().getGridPen().draw(graphics2D, this.getGaugeAlertValueMin[n2]);
            ++n2;
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    Shape[][] getItemShapes() {
        return this.getAxisZProperties;
    }

    public Shape getShapeBySeries(int n) {
        return this.getAxisY[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.getAxisZProperties[n][n2];
    }

    public String[] search(int n, int n2) {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.drilldown = null;
        if (bl) {
            int n3 = 0;
            while (n3 < this.getBounds) {
                int n4 = 0;
                while (n4 < this.getCategorySize) {
                    if (this.getAxisZProperties[n3][n4] != null && this.getAxisZProperties[n3][n4].contains(n, n2)) {
                        this.drilldown = new int[2];
                        this.drilldown[0] = n3;
                        this.drilldown[1] = n4;
                        return this.drawCategoryNames[0][n4];
                    }
                    ++n4;
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < this.getBounds) {
                int n6 = 0;
                while (n6 < this.getCategorySize) {
                    if (this.getAxisZProperties[n5][n6] != null && this.getAxisZProperties[n5][n6].contains(n, n2)) {
                        this.drilldown = new int[2];
                        return this.drawCategoryNames[n5][n6];
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        return null;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.getBounds) {
            if (this.getAxisY[n3].contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public boolean searchHorizonalGrid(int n, int n2) {
        if (this.getGaugeErrorColor == null || !this.paper.properties.getAxisZProperties().isShowGrid()) {
            return false;
        }
        int n3 = this.getGaugeErrorColor.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.getGaugeErrorColor[n4].intersects(n - 2, n2 - 2, 5.0, 5.0)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public boolean searchVerticalGrid(int n, int n2) {
        if (this.getGaugeAlertValueMin == null || !this.paper.properties.getAxisXProperties().isShowGrid()) {
            return false;
        }
        int n3 = this.getGaugeAlertValueMin.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.getGaugeAlertValueMin[n4].intersects(n - 2, n2 - 2, 5.0, 5.0)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public Shape[] getHorizonalGrid() {
        return this.getGaugeErrorColor;
    }

    public Shape[] getVerticalGrid() {
        return this.getGaugeAlertValueMin;
    }
}

