/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DScatterCurve;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Graph2DMeanLine
extends Chart2DObject {
    private GeneralPath F = new GeneralPath();
    private GeneralPath[] append;
    private int contains;
    private int createStroke;
    private float[][] draw;
    private float[][] drawNode;
    private Graph2DLineNode getAbsoluteValueSumOfCategory;
    private Graph2DScatterCurve getCategorySize = new Graph2DScatterCurve();
    private boolean getChartDataSetModel;
    private boolean getDimension;
    private boolean getFormatedHintValue;
    private double[] v;
    private ChartPenStyle getGraphProperties = new ChartPenStyle();
    private ChartColorPattern getHintTextStyle = new ChartColorPattern();
    private String[][] getLineNodeHeight;
    private ChartTextStyle getLineNodeWidth;
    private float getMeanLineColor = 0.0f;

    Graph2DMeanLine(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, boolean bl, boolean bl2, float f) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.getChartDataSetModel = bl;
        this.getDimension = bl2;
        this.createStroke = chartDataSet.getCategorySize();
        this.contains = chartDataSet.getSeriesSize();
        this.getMeanLineColor = f;
        this.getLineNodeWidth = chart2DPaper.getProperties().getHintTextStyle();
        this.getLineNodeWidth.setWordWrapper(false);
    }

    public void init() {
        this.draw = new float[this.createStroke][2];
        this.drawNode = new float[this.createStroke][2];
        this.v = ((Chart1DDataSet)this.dataset).getMeanValue();
        this.getLineNodeHeight = new String[this.createStroke][1];
        float f = this.layer.I();
        float f2 = this.layer.Z();
        this.getAbsoluteValueSumOfCategory = new Graph2DLineNode();
        float f3 = f * this.getMeanLineColor;
        this.append = new GeneralPath[this.createStroke];
        this.getHintTextStyle.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
        this.getGraphProperties.setPenColor(this.getHintTextStyle);
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.createStroke) {
            this.append[n] = new GeneralPath();
            this.draw[n][0] = f3 + (float)n * f;
            this.draw[n][1] = this.getFormatedHintValue ? (float)((double)f2 * this.v[n] / ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n)) : (float)((double)f2 * this.v[n]);
            if (this.getDimension) {
                stringBuffer.append("Y1: ");
            } else {
                stringBuffer.append("Y2: ");
            }
            stringBuffer.append(this.v[n]);
            this.getLineNodeHeight[n][0] = stringBuffer.toString();
            ++n;
        }
    }

    public void paint(Graphics2D graphics2D) {
        switch (this.paper.getProperties().getGraphProperties().getMeanLineType()) {
            case 0: {
                break;
            }
            case 1: {
                this.F(graphics2D);
                break;
            }
            case 2: {
                graphics2D.setStroke(this.getGraphProperties.createStroke());
                graphics2D.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
                this.getCategorySize.isBench = !this.getChartDataSetModel;
                this.getCategorySize.col = this.createStroke;
                this.getCategorySize.tpoint1 = this.drawNode;
                this.getCategorySize.paint(graphics2D, this.paper.getProperties().getGraphProperties().getMeanLineType());
                break;
            }
            case 3: {
                graphics2D.setStroke(this.getGraphProperties.createStroke());
                graphics2D.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
                this.getCategorySize.tpoint1 = this.drawNode;
                this.getCategorySize.paint(graphics2D, this.paper.getProperties().getGraphProperties().getMeanLineType());
                break;
            }
        }
        this.QOIV(graphics2D, this.paper.getProperties().getGraphProperties().getMeanLineNodeStyle());
    }

    public Shape getShapeBySeries(int n) {
        return null;
    }

    public Shape getShapeByItem(int n, int n2) {
        return this.append[n2];
    }

    private void F(Graphics2D graphics2D) {
        if (this.createStroke <= 1) {
            return;
        }
        this.F.reset();
        this.F.moveTo(this.drawNode[0][0], this.drawNode[0][1]);
        int n = 1;
        while (n < this.createStroke) {
            this.F.lineTo(this.drawNode[n][0], this.drawNode[n][1]);
            ++n;
        }
        this.getGraphProperties.draw(graphics2D, this.F);
    }

    private void QOIV(Graphics2D graphics2D, int n) {
        int n2 = 0;
        while (n2 < this.createStroke) {
            this.getAbsoluteValueSumOfCategory.drawNode(graphics2D, (int)this.drawNode[n2][0], (int)this.drawNode[n2][1], n, this.paper.getProperties().getGraphProperties().getLineNodeWidth(), this.paper.getProperties().getGraphProperties().getLineNodeHeight());
            ++n2;
        }
    }

    public void drawMeanValueY(Graphics2D graphics2D, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.paper.getProperties().getHintTextStyle().getDimension(graphics2D, stringBuffer.toString());
        ChartLabelBase chartLabelBase = new ChartLabelBase("");
        int n3 = 0;
        while (n3 < this.createStroke) {
            if (this.append[n3].contains(n, n2)) {
                stringBuffer.setLength(0);
                if (this.getDimension) {
                    stringBuffer.append("Y1: ");
                } else {
                    stringBuffer.append("Y2: ");
                }
                stringBuffer.append(this.dataset.getChartDataSetModel().getFormatedHintValue(this.v[n3]));
                chartLabelBase.setLabelText(stringBuffer.toString());
                chartLabelBase.locate();
                chartLabelBase.paint(graphics2D, n + 10, n2 - 10);
                return;
            }
            ++n3;
        }
    }

    public String[] search(int n, int n2) {
        int n3 = 0;
        while (n3 < this.createStroke) {
            if (this.append[n3].contains(n, n2)) {
                return this.getLineNodeHeight[n3];
            }
            ++n3;
        }
        return null;
    }

    public void locate() {
        int n;
        this.layer.I(this.draw, this.drawNode);
        if (this.layer.isDepth()) {
            n = 0;
            while (n < this.createStroke) {
                float[] fArray = this.drawNode[n];
                fArray[0] = fArray[0] - this.layer.I;
                float[] fArray2 = this.drawNode[n];
                fArray2[1] = fArray2[1] + this.layer.Z;
                ++n;
            }
        }
        n = 5;
        int n2 = 0;
        while (n2 < this.createStroke) {
            this.append[n2].reset();
            this.append[n2].moveTo(this.drawNode[n2][0] - (float)n, this.drawNode[n2][1] + (float)n);
            this.append[n2].lineTo(this.drawNode[n2][0] - (float)n, this.drawNode[n2][1] - (float)n);
            this.append[n2].lineTo(this.drawNode[n2][0] + (float)n, this.drawNode[n2][1] - (float)n);
            this.append[n2].lineTo(this.drawNode[n2][0] + (float)n, this.drawNode[n2][1] + (float)n);
            this.append[n2].lineTo(this.drawNode[n2][0] - (float)n, this.drawNode[n2][1] + (float)n);
            ++n2;
        }
    }

    float[][] getStaticHintLocation() {
        return null;
    }

    Shape[][] getItemShapes() {
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        return 0;
    }

    public void setPercent(boolean bl) {
        this.getFormatedHintValue = bl;
    }
}

