/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DRadarLayer;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Graph2DRadar
extends Chart2DObject {
    private float abs;
    private float contains;
    private float cos;
    private double draw;
    private ChartPenStyle drawNode;
    private ChartPenStyle fill;
    private GeneralPath[][] floatValue;
    private Graph2DLineNode formatLineNode = new Graph2DLineNode();
    private double getBounds;
    private int getCategorySize = 5;
    private int getChartDataSetModel;
    private int getChartLegend;
    private float[] getColor = new float[2];
    private GeneralPath[] getContourPen;
    private Line2D.Float[][] getFormatedHintValue;
    private float v;
    protected float[][] value;
    private float[][] getGraphProperties;
    private float[][] getIconStyleList;
    private int[] getLineNodeHeight;
    private String[][][] getLineNodeStyle;
    private double[] getLineNodeWidth;

    Graph2DRadar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    public void init() {
        int n;
        super.init();
        this.fill = this.paper.getProperties().getGraphProperties().getContourPen();
        this.getBounds = Math.PI;
        this.getChartDataSetModel = ((Chart1DDataSet)this.dataset).getSeriesSize();
        this.getChartLegend = ((Chart1DDataSet)this.dataset).getCategorySize();
        this.value = new float[this.getChartDataSetModel][this.getChartLegend];
        this.paper.Z.setRadarArrowStyle(this.objectProperties.getRadarArrowStyle());
        this.getContourPen = new GeneralPath[this.getChartDataSetModel];
        this.draw = (double)(2.0f / (float)this.getChartLegend) * this.getBounds;
        this.floatValue = new GeneralPath[this.getChartDataSetModel][this.getChartLegend];
        this.getFormatedHintValue = new Line2D.Float[this.getChartDataSetModel][this.getChartLegend];
        this.getLineNodeStyle = new String[this.getChartDataSetModel][this.getChartLegend][1];
        if (this.paper.I.getChartLegend() != null) {
            this.getLineNodeHeight = this.paper.I.getChartLegend().getIconStyleList();
        }
        int n2 = 0;
        while (n2 < this.getChartDataSetModel) {
            this.getContourPen[n2] = new GeneralPath();
            int n3 = 0;
            while (n3 < this.getChartLegend) {
                this.floatValue[n2][n3] = new GeneralPath();
                this.getFormatedHintValue[n2][n3] = new Line2D.Float();
                ++n3;
            }
            ++n2;
        }
        this.getGraphProperties = new float[this.getChartLegend * this.getChartDataSetModel][2];
        this.getIconStyleList = new float[this.getChartDataSetModel * this.getChartLegend][2];
        this.contains = (float)((ChartNumericAxis)this.paper.Z).getMax();
        this.cos = (float)((ChartNumericAxis)this.paper.Z).getMin();
        this.getColor[0] = this.paper.getBounds().width;
        this.getColor[1] = this.paper.getBounds().height;
        this.contains -= this.cos;
        this.abs = this.getColor[1] > this.getColor[0] ? this.getColor[0] : this.getColor[1];
        this.abs = ((Chart2DRadarLayer)this.layer).getRadarAxisLength((int)this.abs);
        int n4 = 0;
        while (n4 < this.getChartDataSetModel) {
            this.v = 0.0f;
            n = 0;
            while (n < this.getChartLegend) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n4, n);
                if (number == null) {
                    this.v = 0.0f;
                } else {
                    this.v = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.getLineNodeStyle[n4][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n4, n);
                    } else {
                        this.getLineNodeStyle[n4][n][0] = this.dataset.getFormatedHintValue(number);
                    }
                }
                this.v = this.v - this.cos > 0.0f ? this.v - this.cos : 0.0f;
                this.v = this.v > this.contains ? this.contains : this.v;
                this.getGraphProperties[this.getChartLegend * n4 + n][0] = this.getColor[0] / 2.0f + this.v / this.contains * this.abs * (float)Math.cos(this.draw * (double)n + 0.5 * this.getBounds);
                this.getGraphProperties[this.getChartLegend * n4 + n][1] = this.getColor[1] / 2.0f + this.v / this.contains * this.abs * (float)Math.sin(this.draw * (double)n + 0.5 * this.getBounds);
                this.value[n4][n] = this.v;
                ++n;
            }
            ++n4;
        }
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.getLineNodeWidth = new double[this.getChartDataSetModel];
            n = 0;
            while (n < this.getChartDataSetModel) {
                int n5 = 0;
                while (n5 < this.getChartLegend) {
                    int n6 = n;
                    this.getLineNodeWidth[n6] = this.getLineNodeWidth[n6] + (double)Math.abs(this.value[n][n5]);
                    ++n5;
                }
                if (this.getLineNodeWidth[n] == 0.0) {
                    this.getLineNodeWidth[n] = 1.0;
                }
                ++n;
            }
        } else {
            this.getLineNodeWidth = new double[this.getChartLegend];
            n = 0;
            while (n < this.getChartLegend) {
                int n7 = 0;
                while (n7 < this.getChartDataSetModel) {
                    int n8 = n;
                    this.getLineNodeWidth[n8] = this.getLineNodeWidth[n8] + (double)Math.abs(this.value[n7][n]);
                    ++n7;
                }
                if (this.getLineNodeWidth[n] == 0.0) {
                    this.getLineNodeWidth[n] = 1.0;
                }
                ++n;
            }
        }
    }

    public void locate() {
        this.layer.I(this.getGraphProperties, this.getIconStyleList);
    }

    public void paint(Graphics2D graphics2D) {
        this.dataset();
        this.abs(graphics2D);
        int n = 0;
        while (n < this.getChartLegend) {
            int n2 = 0;
            while (n2 < this.getChartDataSetModel) {
                if (((Chart1DDataSet)this.dataset).getValue(n2, n) != null) {
                    this.contains(graphics2D, n2, n);
                }
                ++n2;
            }
            ++n;
        }
        try {
            this.cos();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.valueLabelPosition != 0) {
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.getIconStyleList, 0, this.getChartDataSetModel, this.valueLabelPosition, this.getLineNodeWidth);
            graph2DStaticHint.paint();
        }
        if (this.objectProperties.isRadarIsFill()) {
            int n3 = 0;
            while (n3 < this.getChartDataSetModel) {
                if (this.seriesPattern[n3] != null) {
                    if (this.seriesPattern[n3] instanceof ChartColorPattern) {
                        this.drawNode.setPenColor((ChartColorPattern)this.seriesPattern[n3]);
                        graphics2D.setColor(this.drawNode.getPenColor().getColor());
                        this.seriesPattern[n3] = new ChartColorPattern(ChartColorPattern.transparent(graphics2D.getColor(), this.objectProperties.getRadarFillTransparence()));
                        this.seriesPattern[n3].fill(graphics2D, this.getContourPen[n3]);
                        if (this.seriesPattern[n3] instanceof ChartColorPattern) {
                            this.seriesPattern[n3] = new ChartColorPattern(ChartColorPattern.transparent(graphics2D.getColor(), 0.0f));
                        }
                    } else {
                        this.seriesPattern[n3].fill(graphics2D, this.getContourPen[n3]);
                    }
                }
                if (this.paper.getProperties().getGraphProperties().isContour()) {
                    this.QOIV(graphics2D);
                }
                ++n3;
            }
        }
    }

    private void QOIV(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.getChartDataSetModel) {
            this.paper.getProperties().getGraphProperties().getContourPen();
            if (this.fill != null) {
                this.fill.draw(graphics2D, this.getContourPen[n]);
            }
            ++n;
        }
    }

    private void abs(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.getChartDataSetModel) {
            this.drawNode = new ChartPenStyle();
            this.paper.getProperties().getGraphProperties().getContourPen();
            if (this.seriesPattern[n] instanceof ChartColorPattern) {
                this.drawNode.setPenColor((ChartColorPattern)this.seriesPattern[n]);
                this.drawNode.setPenWidth(this.objectProperties.getLineThickness());
                this.drawNode.draw(graphics2D, this.getContourPen[n]);
            }
            ++n;
        }
    }

    private void contains(Graphics2D graphics2D, int n, int n2) {
        int n3 = 0;
        if (this.seriesPattern[n] instanceof ChartColorPattern) {
            this.drawNode.setPenColor((ChartColorPattern)this.seriesPattern[n]);
            graphics2D.setColor(this.drawNode.getPenColor().getColor());
            if (((Chart1DDataSet)this.dataset).getValue(n, n2) != null) {
                n3 = this.objectProperties.getLineNodeStyle();
            }
            if (this.getLineNodeHeight != null) {
                n3 = this.paper.formatLineNode(this.objectProperties.getLineNodeStyle(), this.getLineNodeHeight[n % this.getLineNodeHeight.length]);
            }
            this.formatLineNode.drawNode(graphics2D, (int)this.getIconStyleList[this.getChartLegend * n + n2][0], (int)this.getIconStyleList[this.getChartLegend * n + n2][1], n3, this.paper.getProperties().getGraphProperties().getLineNodeWidth(), this.paper.getProperties().getGraphProperties().getLineNodeHeight());
        }
    }

    Shape[][] getItemShapes() {
        return this.floatValue;
    }

    private void cos() {
        int n = 0;
        while (n < this.getChartDataSetModel) {
            int n2 = 0;
            while (n2 < this.getChartLegend) {
                this.floatValue[n][n2].reset();
                this.floatValue[n][n2].moveTo(this.getIconStyleList[n * this.getChartLegend + n2][0] - (float)this.getCategorySize, this.getIconStyleList[n * this.getChartLegend + n2][1] + (float)this.getCategorySize);
                this.floatValue[n][n2].lineTo(this.getIconStyleList[n * this.getChartLegend + n2][0] - (float)this.getCategorySize, this.getIconStyleList[n * this.getChartLegend + n2][1] - (float)this.getCategorySize);
                this.floatValue[n][n2].lineTo(this.getIconStyleList[n * this.getChartLegend + n2][0] + (float)this.getCategorySize, this.getIconStyleList[n * this.getChartLegend + n2][1] - (float)this.getCategorySize);
                this.floatValue[n][n2].lineTo(this.getIconStyleList[n * this.getChartLegend + n2][0] + (float)this.getCategorySize, this.getIconStyleList[n * this.getChartLegend + n2][1] + (float)this.getCategorySize);
                this.floatValue[n][n2].lineTo(this.getIconStyleList[n * this.getChartLegend + n2][0] - (float)this.getCategorySize, this.getIconStyleList[n * this.getChartLegend + n2][1] + (float)this.getCategorySize);
                ++n2;
            }
            ++n;
        }
    }

    private void dataset() {
        int n = 0;
        while (n < this.getChartDataSetModel) {
            this.getContourPen[n].reset();
            this.getContourPen[n].moveTo(this.getIconStyleList[n * this.getChartLegend][0], this.getIconStyleList[n * this.getChartLegend][1]);
            if (this.getChartLegend > 1) {
                int n2 = 0;
                while (n2 < this.getChartLegend) {
                    if (n2 > 0) {
                        this.getContourPen[n].lineTo(this.getIconStyleList[n * this.getChartLegend + n2][0], this.getIconStyleList[n * this.getChartLegend + n2][1]);
                    }
                    this.draw(n, n2);
                    ++n2;
                }
            }
            this.getContourPen[n].lineTo(this.getIconStyleList[n * this.getChartLegend][0], this.getIconStyleList[n * this.getChartLegend][1]);
            ++n;
        }
    }

    private void draw(int n, int n2) {
        if (n2 == this.getChartLegend - 1) {
            this.getFormatedHintValue[n][n2].setLine(this.getIconStyleList[n * this.getChartLegend + n2][0], this.getIconStyleList[n * this.getChartLegend + n2][1], this.getIconStyleList[n * this.getChartLegend][0], this.getIconStyleList[n * this.getChartLegend][1]);
        } else {
            this.getFormatedHintValue[n][n2].setLine(this.getIconStyleList[n * this.getChartLegend + n2][0], this.getIconStyleList[n * this.getChartLegend + n2][1], this.getIconStyleList[n * this.getChartLegend + n2 + 1][0], this.getIconStyleList[n * this.getChartLegend + n2 + 1][1]);
        }
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public int searchSeries(int n, int n2) {
        int n3 = 0;
        while (n3 < this.getChartDataSetModel) {
            int n4 = 0;
            while (n4 < this.getChartLegend) {
                if (this.getFormatedHintValue[n3][n4].intersects(n - 5, n2 - 5, 10.0, 10.0)) {
                    return n3;
                }
                ++n4;
            }
            ++n3;
        }
        return -1;
    }

    public float[][] getStaticHintLocation() {
        return null;
    }

    public Shape getShapeBySeries(int n) {
        return this.getContourPen[n];
    }

    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    public String[] search(int n, int n2) {
        this.drilldown = null;
        int n3 = 0;
        while (n3 < this.getChartDataSetModel) {
            int n4 = 0;
            while (n4 < this.getChartLegend) {
                if (this.floatValue[n3][n4].contains(n, n2)) {
                    this.drilldown = new int[2];
                    this.drilldown[0] = n3;
                    this.drilldown[1] = n4;
                    return this.getLineNodeStyle[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }
}

