/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartCoordinatePaper;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DAxes;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DWalls;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.chart3d.Graph3DAreaA;
import chart.chart3d.Graph3DAreaP;
import chart.chart3d.Graph3DAreaSt;
import chart.chart3d.Graph3DBarA;
import chart.chart3d.Graph3DBarP;
import chart.chart3d.Graph3DBarSi;
import chart.chart3d.Graph3DBarSt;
import chart.chart3d.Graph3DLineA;
import chart.chart3d.Graph3DSurface;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartGraphicsUtil;
import chart.properties.ChartCoordinatePaperProperties;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;
import java.util.Vector;

public class Chart3DPaper
extends ChartCoordinatePaper {
    public static final int ROTATION = 0;
    public static final int RESIZING = 1;
    private int IsShowLabelTips = 0;
    ChartPlatform QOIV;
    public ChartDataSetModel model;
    List abs;
    ChartAxis I;
    ChartAxis Z;
    ChartAxis C;
    GridLine add;
    GridLine adjustDistance;
    GridLine benchmarkmirror;
    int calculateGraphArea;
    int contains;
    int drawSelectedShape;
    int get;
    private Chart3DWalls getAutoOritention;
    private Chart3DAxes getAxisAreaPath;
    private Chart3DObject[] getAxisShapes;
    private ChartCompass getAxisWithTickLength;
    private ChartMatrix getAxisXProperties = new ChartMatrix();
    private ChartMatrix getAxisYProperties = new ChartMatrix();
    private ChartMatrix getAxisZProperties = new ChartMatrix();
    float[] getBackground = new float[3];
    float[] getBounds = new float[3];
    int getCategoryFilter;
    private boolean getCategoryName = false;
    private boolean getCategoryNames = true;
    float[] B = new float[3];
    private float[] getChartDataSetInfo = new float[3];
    private float[] getChartDataSets = new float[3];
    private int getChartType = 10;
    private float getCoreArea;
    private float getDataFilter;
    private float getDataSetModel;
    private int[] getDatasetInfos = new int[2];
    private int getGridXAreaPath;
    private int getGridYAreaPath = -1;
    private int getGridZAreaPath = -1;
    private String getItemShapes;
    private String getLabelTextStyle;
    private int[] getLabelsForHtml;
    private Rectangle getMax;

    public Chart3DPaper(ChartPlatform chartPlatform) {
        this.QOIV = chartPlatform;
    }

    public Chart3DPaper(ChartPlatform chartPlatform, ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.QOIV = chartPlatform;
        this.properties = chartCoordinatePaperProperties;
    }

    public void init() {
        this.setBackground(this.properties.getBackground());
        this.model = this.QOIV.getDataSetModel();
        this.abs = this.model.getChartDataSets();
        if (this.abs.size() > 1) {
            throw new RuntimeException("datasets.size() > 1");
        }
        ChartDataSet chartDataSet = (ChartDataSet)this.abs.get(0);
        this.getGridXAreaPath = chartDataSet.getChartDataSetInfo().getChartType();
        this.getDatasetInfos[0] = ChartTypeInfo.getPrimType(this.getGridXAreaPath);
        this.getDatasetInfos[1] = ChartTypeInfo.getSubType(this.getGridXAreaPath);
        this.IsShowLabelTips();
        if (this.getDatasetInfos[0] != 4) {
            this.getDataFilter = (float)((ChartNumericAxis)this.Z).getMin();
            this.getDataSetModel = (float)((ChartNumericAxis)this.Z).getMax();
        }
        this.getAxisShapes = new Chart3DObject[1];
        this.getAxisShapes[0] = this.abs(chartDataSet);
    }

    public void doLayout() {
        this.locate();
    }

    public void paint(Graphics2D graphics2D) {
        this.background = this.properties.getBackground();
        super.paint(graphics2D);
        this.transform();
        if (this.getAutoOritention != null) {
            this.getAutoOritention.paint(graphics2D);
            this.getAxisAreaPath.paintGridLines(graphics2D);
        }
        int n = 0;
        while (n < this.getAxisShapes.length) {
            this.getAxisShapes[n].paint(graphics2D);
            ++n;
        }
        if (this.getDatasetInfos[0] != 4) {
            this.getAxisAreaPath.paint(graphics2D);
        }
        this.adjustDistance(graphics2D);
        super.paintBorder(graphics2D);
    }

    private void IsShowLabelTips() {
        ChartDataSet chartDataSet = (ChartDataSet)this.abs.get(0);
        int n = chartDataSet.getChartDataSetInfo().getChartType();
        switch (ChartTypeInfo.getPrimType(n)) {
            case 4: {
                this.I = null;
                this.Z = null;
                this.C = null;
                this.getAutoOritention = null;
                break;
            }
            default: {
                List list;
                List list2;
                if (!(!this.model.isOneGroup() || this.getDatasetInfos[0] != 0 && this.getDatasetInfos[0] != 1 && this.getDatasetInfos[0] != 3 || this.getDatasetInfos[1] != 0 && this.getDatasetInfos[1] != 256 && this.getDatasetInfos[1] != 512)) {
                    list2 = this.model.getCategoryNames();
                    list = null;
                } else if (this.getDatasetInfos[1] == 0 || this.getDatasetInfos[1] == 256 || this.getDatasetInfos[1] == 512) {
                    list2 = this.model.getCategoryNames();
                    list = this.model.getSeriesNames();
                } else {
                    list2 = this.model.getCategoryNames();
                    list = this.model.getSeriesNames();
                }
                this.I = new ChartCategoryAxis(this.properties.getAxisXProperties(), list2);
                this.I.setType("x1");
                this.I.setAxisPosition(5);
                this.add = new GridLine();
                this.add.setType("x1");
                this.add.setAxis(this.I);
                this.Z = new ChartNumericAxis(this.properties.getAxisYProperties(), chartDataSet.getMin(), chartDataSet.getMax());
                this.Z.setType("y1");
                this.Z.setAxisPosition(5);
                this.adjustDistance = new GridLine();
                this.adjustDistance.setType("y1");
                this.adjustDistance.setAxis(this.Z);
                if (ChartTypeInfo.getSubType(n) != 256) {
                    ((ChartNumericAxis)this.Z).setAutoExpand(true);
                    ((ChartNumericAxis)this.Z).setIntegerIncrement(chartDataSet.isIntegerData());
                }
                this.C = new ChartCategoryAxis(this.properties.getAxisZProperties(), list);
                this.C.setType("z");
                this.benchmarkmirror = new GridLine();
                this.benchmarkmirror.setType("z");
                this.C.setAxisPosition(5);
                this.benchmarkmirror.setAxis(this.C);
                this.I.setShow(this.properties.isShowAxisX());
                this.Z.setShow(this.properties.isShowAxisY());
                this.C.setShow(this.properties.isShowAxisZ());
                this.getAutoOritention = new Chart3DWalls(this);
                this.getAutoOritention.init();
                this.getAxisAreaPath = new Chart3DAxes(this);
                this.getAxisAreaPath.init();
            }
        }
        if (this.I != null) {
            this.I.setFilter(this.model.getCategoryFilter());
            this.I.init();
        }
        if (this.C != null) {
            this.C.setFilter(this.model.getSeriesFilter());
            this.C.init();
        }
        if (this.Z != null) {
            this.Z.setFilter(chartDataSet.getDataFilter());
            this.Z.init();
        }
        if (this.getDatasetInfos[0] == 2 || this.getDatasetInfos[0] == 3 || this.getDatasetInfos[0] == 7) {
            ((ChartCategoryAxis)this.I).setIsLineUnit(true);
        }
        if (ChartTypeInfo.getPrimType(n) == 7) {
            ((ChartCategoryAxis)this.C).setIsLineUnit(true);
        }
    }

    public void calculateGraphArea() {
        ChartAxis chartAxis = null;
        ChartAxis chartAxis2 = null;
        Rectangle rectangle = super.getBounds();
        Rectangle rectangle2 = super.getCoreArea();
        this.calculateGraphArea = rectangle2.y;
        this.contains = rectangle2.x;
        this.drawSelectedShape = rectangle.width - rectangle2.x - rectangle2.width;
        this.get = rectangle.height - rectangle2.y - rectangle2.height;
        ChartDataSet chartDataSet = (ChartDataSet)this.abs.get(0);
        int n = chartDataSet.getChartDataSetInfo().getChartType();
        if (ChartTypeInfo.getPrimType(n) == 1) {
            chartAxis = this.Z;
            chartAxis2 = this.I;
        } else {
            chartAxis = this.I;
            chartAxis2 = this.Z;
        }
        if (chartAxis2 != null && chartAxis2.isShow()) {
            this.contains += chartAxis2.getAxisWithTickLength();
            this.contains += chartAxis2.getMaxDimensionOfLabelsFor3D().width;
        }
        if (chartAxis != null && chartAxis.isShow()) {
            this.get += chartAxis.getAxisWithTickLength();
            this.get += chartAxis.getMaxDimensionOfLabelsFor3D().height;
        }
        this.get = this.get < rectangle.height - 10 ? this.get : rectangle.height - 10;
        this.contains = this.contains < rectangle.width / 2 ? this.contains : rectangle.width / 2;
        this.calculateGraphArea += 10;
        this.drawSelectedShape += this.contains;
        this.getMax = new Rectangle(this.contains, this.calculateGraphArea, rectangle.width - this.contains - this.drawSelectedShape, rectangle.height - this.calculateGraphArea - this.get);
    }

    public void locate() {
        this.calculateGraphArea();
        this.getAxisZProperties.reset(this.properties.getRotationMatrix());
        this.getChartDataSets[0] = this.properties.getScaleX() * 0.9f;
        this.getChartDataSets[1] = this.properties.getScaleY() * 0.86f;
        this.getChartDataSets[2] = this.properties.getScaleZ() * 0.9f;
        this.getChartType = this.properties.getPerspective();
        float f = super.getBounds().width;
        float f2 = super.getBounds().height;
        if (this.getDatasetInfos[0] == 1) {
            this.getCategoryNames = false;
            this.getBounds[0] = (int)(f2 - (float)(2 * this.get));
            this.getBounds[1] = (int)(f - (float)this.contains);
        } else {
            this.getCategoryNames = true;
            this.getBounds[0] = (int)(f - (float)(2 * this.contains));
            this.getBounds[1] = (int)(f2 - (float)this.get);
        }
        if (this.getBounds[0] < 0.0f) {
            this.getBounds[0] = 0.0f;
        }
        if (this.getBounds[1] < 0.0f) {
            this.getBounds[1] = 0.0f;
        }
        if (this.getDatasetInfos[0] != 4) {
            this.getBackground[0] = this.I.getUnit(this.getBounds[0]);
        }
        if (this.I.getAutoOritention(this.getBackground[0])) {
            this.I.getProperties().getLabelTextStyle().setRotation(-0.5235987912027583);
            this.calculateGraphArea();
            if (this.getDatasetInfos[0] == 1) {
                this.getBounds[0] = (int)(f2 - (float)(2 * this.get));
                this.getBounds[1] = (int)(f - (float)this.contains);
            } else {
                this.getBounds[0] = (int)(f - (float)(2 * this.contains));
                this.getBounds[1] = (int)(f2 - (float)this.get);
            }
        } else {
            this.calculateGraphArea();
            if (this.getDatasetInfos[0] == 1) {
                this.getBounds[0] = (int)(f2 - (float)(2 * this.get));
                this.getBounds[1] = (int)(f - (float)this.contains);
            } else {
                this.getBounds[0] = (int)(f - (float)(2 * this.contains));
                this.getBounds[1] = (int)(f2 - (float)this.get);
            }
        }
        this.getBounds[2] = this.getDatasetInfos[1] == 768 && !this.model.isOneGroup() ? (this.getBounds[1] < this.getBounds[0] ? this.getBounds[1] : this.getBounds[0]) : this.getBounds[0] * 2.0f / 5.0f;
        if (this.getDatasetInfos[0] != 4) {
            this.getBackground[2] = this.C.getUnit(this.getBounds[2]);
        }
        if (this.I.getProperties().getLabelTextStyle().getWordWrapper() || this.C.getProperties().getLabelTextStyle().getWordWrapper()) {
            if (this.getDatasetInfos[0] != 1) {
                this.I.setUnitWidth((int)((double)this.getBackground[0] * 0.8));
                this.C.setUnitWidth((int)((double)this.getBackground[2] * 0.8));
            }
            this.calculateGraphArea();
        }
        this.getChartDataSetInfo[0] = this.getBounds[0] / 2.0f;
        this.getChartDataSetInfo[2] = this.getBounds[2] / 2.0f;
        this.getChartDataSetInfo[1] = (this.getBounds[1] - (float)this.get) / 2.0f;
        this.B[0] = f / 2.0f;
        this.B[1] = f2 / 2.0f;
        if (this.getDatasetInfos[0] != 4) {
            this.getBackground[1] = this.Z.getUnit(this.getBounds[1]);
            this.getCoreArea = -((float)((ChartNumericAxis)this.Z).getMin() * this.getBackground[1]);
        }
        if (this.getAutoOritention != null) {
            this.QOIV();
            this.getAutoOritention.locate();
            this.getAxisAreaPath.locate();
            this.getCategoryName = false;
        }
        int n = 0;
        while (n < this.getAxisShapes.length) {
            this.getAxisShapes[n].init();
            this.getAxisShapes[n].locate();
            ++n;
        }
    }

    private void QOIV() {
        this.getAxisWithTickLength = new ChartCompass(this.getChartDataSetInfo[0], this.getChartDataSetInfo[1], this.getChartDataSetInfo[2], this.getGridXAreaPath);
    }

    public void transform() {
        block13: {
            block14: {
                float f;
                float f2;
                float f3;
                float f4;
                if (this.getCategoryName || this.getAxisWithTickLength == null) {
                    return;
                }
                if (this.getDatasetInfos[0] == 4) break block13;
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (this.getDatasetInfos[0] == 2) {
                    f4 = this.B[0] + this.getChartDataSetInfo[0];
                    f3 = this.B[0] - this.getChartDataSetInfo[0];
                    f2 = this.B[1] + this.getChartDataSetInfo[1];
                    f = this.B[1] - this.getChartDataSetInfo[1];
                    this.getChartType = this.getChartType < 1 ? 9 : this.getChartType;
                } else {
                    f4 = this.B[0] + this.getChartDataSetInfo[1];
                    f3 = this.B[0] - this.getChartDataSetInfo[1];
                    f2 = this.B[1] + this.getChartDataSetInfo[0];
                    f = this.B[1] - this.getChartDataSetInfo[0];
                    this.getChartType = this.getChartType < 1 ? 9 : this.getChartType;
                }
                do {
                    this.getAxisYProperties.unit();
                    this.getAxisYProperties.setVisualEffect(this.B[0], this.B[1], Math.min(this.B[0], this.B[1]) * (float)this.getChartType);
                    this.getAxisYProperties.shift(-this.getChartDataSetInfo[0], -this.getChartDataSetInfo[1], -this.getChartDataSetInfo[2]);
                    this.getAxisYProperties.mul(this.getAxisZProperties);
                    this.getAxisYProperties.scale(this.getChartDataSets[0], this.getChartDataSets[1], this.getChartDataSets[2]);
                    if (this.getCategoryNames) {
                        this.getAxisXProperties.mirror();
                    } else {
                        this.getAxisXProperties.benchmarkmirror();
                    }
                    this.getAxisXProperties.shift(this.B[0], this.B[1], this.B[2] - f5);
                    this.getAxisYProperties.mul(this.getAxisXProperties);
                    this.getAxisWithTickLength.transform(this.getAxisYProperties);
                    f6 = this.getAxisWithTickLength.adjustDistance(f4, f3, f2, f);
                    f5 += f6;
                } while (f6 > 1.0f);
                if (this.getAutoOritention == null) break block14;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 3;
                this.getAutoOritention.transform(this.getAxisYProperties);
                n3 = this.getAxisWithTickLength.shownFace(this.getAutoOritention.getWalls().tVertex, 0);
                int n5 = 0;
                while (n5 < 3) {
                    block17: {
                        block16: {
                            block15: {
                                if ((n3 >> n5 * 2 & 1) != 1) {
                                    n2 = n5 * 2;
                                }
                                if ((n3 >> n5 * 2 + 1 & 1) == 1) break block15;
                                n2 = n5 * 2 + 1;
                                break block16;
                            }
                            if (n5 * 2 + 1 == n4) break block17;
                        }
                        n |= 1 << n2;
                    }
                    ++n5;
                }
                this.getCategoryFilter = n;
            }
            if (this.getAxisAreaPath != null) {
                this.getAxisAreaPath.transform(this.getAxisYProperties);
            }
            if (this.getAxisShapes != null && this.getAxisShapes[0] != null) {
                this.getAxisShapes[0].transform(this.getAxisYProperties);
            }
        }
        this.getCategoryName = true;
    }

    private Chart3DObject abs(ChartDataSet chartDataSet) {
        Chart3DObject chart3DObject = null;
        switch (this.getDatasetInfos[0]) {
            case 0: {
                switch (this.getDatasetInfos[1]) {
                    case 0: {
                        chart3DObject = new Graph3DBarSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DBarP(chartDataSet, this);
                        break;
                    }
                    case 512: {
                        chart3DObject = new Graph3DBarSi(chartDataSet, this);
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DBarA(chartDataSet, this);
                    }
                }
                break;
            }
            case 1: {
                switch (this.getDatasetInfos[1]) {
                    case 0: {
                        chart3DObject = new Graph3DBarSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DBarP(chartDataSet, this);
                        break;
                    }
                    case 512: {
                        chart3DObject = new Graph3DBarSi(chartDataSet, this);
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DBarA(chartDataSet, this);
                    }
                }
                break;
            }
            case 2: {
                switch (this.getDatasetInfos[1]) {
                    case 0: {
                        break;
                    }
                    case 256: {
                        break;
                    }
                    case 512: {
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DLineA(chartDataSet, this);
                    }
                }
                break;
            }
            case 3: {
                switch (this.getDatasetInfos[1]) {
                    case 768: {
                        chart3DObject = new Graph3DAreaA(chartDataSet, this);
                        break;
                    }
                    case 0: {
                        chart3DObject = new Graph3DAreaSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DAreaP(chartDataSet, this);
                    }
                }
                break;
            }
            case 7: {
                chart3DObject = new Graph3DSurface(chartDataSet, this);
            }
        }
        return chart3DObject;
    }

    public ChartCompass getCompass() {
        return this.getAxisWithTickLength;
    }

    public float availableLength(float f) {
        if (f < this.getDataFilter * this.getBackground[1]) {
            return 0.0f;
        }
        if (f > this.getDataSetModel * this.getBackground[1]) {
            return this.getBounds[1];
        }
        return f + this.getCoreArea;
    }

    public float availableOriginY(float f) {
        if (f < this.getDataFilter * this.getBackground[1]) {
            return 0.0f;
        }
        if (f > (this.getDataSetModel - this.getDataFilter) * this.getBackground[1]) {
            return this.getBounds[1];
        }
        return f;
    }

    public float availableValue(float f) {
        f = f < this.getDataFilter ? this.getDataFilter : (f > this.getDataSetModel ? this.getDataSetModel : f);
        return f;
    }

    public float[] getUnit() {
        return this.getBackground;
    }

    public float[] getLength() {
        return this.getBounds;
    }

    public int getShownFace() {
        return this.getCategoryFilter;
    }

    public float[] getOrigin() {
        return this.B;
    }

    public void setOriginY(float f) {
        this.getCoreArea = f;
    }

    public float getOriginY() {
        return this.getCoreArea;
    }

    public void setMode(int n) {
        this.IsShowLabelTips = n;
    }

    public int getMode() {
        return this.IsShowLabelTips;
    }

    public int[] getIntType() {
        return this.getDatasetInfos;
    }

    public int getChartType() {
        return this.getGridXAreaPath;
    }

    public void setYUnit(float f) {
        this.getBackground[1] = f;
    }

    public Chart3DWalls getWalls() {
        return this.getAutoOritention;
    }

    public ChartPlatform getChartPlatform() {
        return this.QOIV;
    }

    public ChartDataSetInfo[] getDataSetInfos() {
        return this.model.getDatasetInfos();
    }

    public ChartNumericAxis getAxisY1() {
        return (ChartNumericAxis)this.Z;
    }

    public Shape[][] getItemShapes(int n) {
        return this.getAxisShapes[n].getItemShapes(n);
    }

    public void setXDimValue(Vector vector) {
        ((ChartCategoryAxis)this.I).setDimValue(vector);
    }

    public void setZDimValue(Vector vector) {
        ((ChartCategoryAxis)this.C).setDimValue(vector);
    }

    public String[] getXLabels() {
        return ((ChartCategoryAxis)this.I).getLabelsForHtml();
    }

    public String[] getZLabels() {
        return ((ChartCategoryAxis)this.C).getLabelsForHtml();
    }

    public Shape[] getAxisXShapes() {
        return this.I.getAxisShapes();
    }

    public Shape[] getAxisZShapes() {
        return this.C.getAxisShapes();
    }

    public String[] getHintValue(int n, int n2) {
        this.getGridYAreaPath = n;
        this.getGridZAreaPath = n2;
        String[] stringArray = null;
        this.getLabelsForHtml = null;
        if (this.getAxisShapes != null && this.getAxisShapes[0] != null) {
            stringArray = this.getAxisShapes[0].search(n, n2);
            this.getLabelsForHtml = this.getAxisShapes[0].drilldown;
            if (stringArray != null) {
                return stringArray;
            }
        }
        stringArray = new String[]{this.add(n, n2)};
        return stringArray;
    }

    private String add(int n, int n2) {
        String string;
        if (this.I != null) {
            string = this.I.searchAxisLabel(n, n2);
            if (string != null) {
                this.getItemShapes = string;
                if (this.I.IsShowLabelTips()) {
                    return string;
                }
            } else {
                this.getItemShapes = null;
            }
        }
        if (this.C != null) {
            string = this.C.searchAxisLabel(n, n2);
            if (string != null) {
                this.getLabelTextStyle = string;
                if (this.C.IsShowLabelTips()) {
                    return string;
                }
            } else {
                this.getLabelTextStyle = null;
            }
        }
        if (this.Z != null && (string = this.Z.searchAxisLabel(n, n2)) != null && this.Z.IsShowLabelTips()) {
            return string;
        }
        return null;
    }

    public String getXDim() {
        return this.getItemShapes;
    }

    public String getZDim() {
        return this.getLabelTextStyle;
    }

    public int[] getDrilldown() {
        return this.getLabelsForHtml;
    }

    public String[] getDrilldownGroup() {
        String[] stringArray = new String[2];
        if (this.getLabelsForHtml != null) {
            if (this.model.isTurnedXZ()) {
                stringArray[0] = null;
                stringArray[1] = this.model.getSeriesName(this.getLabelsForHtml[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getLabelsForHtml[0] % this.model.getSeriesCount()).toString());
            } else {
                stringArray[0] = this.model.getSeriesName(this.getLabelsForHtml[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getLabelsForHtml[0] % this.model.getSeriesCount()).toString());
                stringArray[1] = this.model.getCategoryName(this.getLabelsForHtml[1]) == null ? null : this.model.getCategoryName(this.getLabelsForHtml[1]).toString();
            }
        }
        return stringArray;
    }

    protected Chart3DAxes getAxes() {
        return this.getAxisAreaPath;
    }

    public float[] getWordWrapUnit() {
        float[] fArray = new float[]{Math.abs(this.getBackground[0] * 0.8f), Math.abs(this.getBackground[2] * 0.8f)};
        return fArray;
    }

    public ChartObject getChartObject(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.getBounds().contains(n, n2)) {
            this.searchSelectedSeriesIndex(n -= this.getBounds().x, n2 -= this.getBounds().y);
            if (this.I != null && this.I.searchSelectedAxis(n, n2)) {
                return this.I;
            }
            if (this.Z != null && this.Z.searchSelectedAxis(n, n2)) {
                return this.Z;
            }
            if (this.C != null && this.C.searchSelectedAxis(n, n2)) {
                return this.C;
            }
            if (this.selectedSeriesIndex != -1) {
                return this.getAxisShapes[0];
            }
            if (this.getAxisAreaPath != null && this.getAxisAreaPath.searchSelectedGridX(n, n2)) {
                return this.add;
            }
            if (this.getAxisAreaPath != null && this.getAxisAreaPath.searchSelectedGridY(n, n2)) {
                return this.adjustDistance;
            }
            if (this.getAxisAreaPath != null && this.getAxisAreaPath.searchSelectedGridZ(n, n2)) {
                return this.benchmarkmirror;
            }
            if (this.getAutoOritention != null && this.getAutoOritention.searchSelectedWallXY(n, n2)) {
                this.getAutoOritention.getWallXY().setType("xy");
                return this.getAutoOritention.getWallXY();
            }
            if (this.getAutoOritention != null && this.getAutoOritention.searchSelectedWallYZ(n, n2)) {
                this.getAutoOritention.getWallYZ().setType("yz");
                return this.getAutoOritention.getWallYZ();
            }
            if (this.getAutoOritention != null && this.getAutoOritention.searchSelectedWallFloor(n, n2)) {
                this.getAutoOritention.getWallFloor().setType("floor");
                return this.getAutoOritention.getWallFloor();
            }
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public void searchSelectedSeriesIndex(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.getAxisShapes[0] != null) {
            this.getAxisShapes[0].search(n, n2);
            this.selectedSeriesIndex = this.getAxisShapes[0].selectedSeriesIndex;
        }
    }

    public void seTransformed(boolean bl) {
        this.getCategoryName = bl;
    }

    private void adjustDistance(Graphics2D graphics2D) {
        if (this.I != null && this.I.getStatus() == 1) {
            Line2D line2D = this.I.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.Z != null && this.Z.getStatus() == 1) {
            Line2D line2D = this.Z.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.C != null && this.C.getStatus() == 1) {
            Line2D line2D = this.C.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.add != null && this.selectedSeriesIndex != -1 && this.add.getStatus() == 1) {
            GeneralPath generalPath = this.getAxisAreaPath.getGridXAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.adjustDistance != null && this.selectedSeriesIndex == -1 && this.adjustDistance.getStatus() == 1) {
            GeneralPath generalPath = this.getAxisAreaPath.getGridYAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.benchmarkmirror != null && this.selectedSeriesIndex == -1 && this.benchmarkmirror.getStatus() == 1) {
            GeneralPath generalPath = this.getAxisAreaPath.getGridZAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.getAutoOritention.getWallXY() != null && this.getAutoOritention.getWallXY().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.getAutoOritention.getWallXYAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.getAutoOritention.getWallYZ() != null && this.getAutoOritention.getWallYZ().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.getAutoOritention.getWallYZAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.getAutoOritention.getWallFloor() != null && this.getAutoOritention.getWallFloor().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.getAutoOritention.getWallFloorAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
    }

    public Vector getChartObjects() {
        Vector<ChartObject> vector = new Vector<ChartObject>();
        vector.add(this);
        if (this.I != null) {
            this.I.setType("x1");
            vector.add(this.I);
        }
        if (this.Z != null) {
            this.Z.setType("y1");
            vector.add(this.Z);
        }
        if (this.C != null && this.getDatasetInfos[1] == 768) {
            this.C.setType("z");
            vector.add(this.C);
        }
        if (this.I != null && this.add != null) {
            this.add.setType("x1");
            this.add.setAxis(this.I);
            vector.add(this.add);
        }
        if (this.Z != null && this.adjustDistance != null) {
            this.adjustDistance.setType("y1");
            this.adjustDistance.setAxis(this.Z);
            vector.add(this.adjustDistance);
        }
        if (this.C != null && this.benchmarkmirror != null && this.getDatasetInfos[1] == 768) {
            this.benchmarkmirror.setType("z");
            this.benchmarkmirror.setAxis(this.C);
            vector.add(this.benchmarkmirror);
        }
        if (this.getAutoOritention != null && this.getAutoOritention.getWallXY() != null) {
            this.getAutoOritention.getWallXY().setType("xy");
            vector.add(this.getAutoOritention.getWallXY());
        }
        if (this.getAutoOritention != null && this.getAutoOritention.getWallFloor() != null) {
            this.getAutoOritention.getWallFloor().setType("floor");
            vector.add(this.getAutoOritention.getWallFloor());
        }
        if (this.getAutoOritention != null && this.getAutoOritention.getWallYZ() != null) {
            this.getAutoOritention.getWallYZ().setType("yz");
            vector.add(this.getAutoOritention.getWallYZ());
        }
        return vector;
    }

    public Rectangle getGraphArea() {
        return this.getMax;
    }
}

