/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ChartIcon
implements Cloneable {
    public static final String[] BUILTINICON = new String[]{"Rectangle", "Diamond", "Triangle Up", "Triangle Down", "Triangle Left", "Triangle Right", "Circle", "Cross1", "Cross2"};
    private static final String[] QOIV = new String[]{"Top", "Center", "Bottom"};
    private static final String[] blue = new String[]{"Left", "Center", "Right"};
    public static final int NUMBUILTINICON = BUILTINICON.length;
    private ChartFillPattern clone;
    private ChartPenStyle closePath;
    private boolean copyImage = false;
    private Dimension draw;
    private int drawImage;
    private String equals;
    private BufferedImage fill;

    public ChartIcon() {
        this.drawImage = BUILTINICON.length;
        this.draw = new Dimension(12, 12);
    }

    public ChartIcon(int n) {
        this.drawImage = n;
        this.draw = new Dimension(12, 12);
    }

    public ChartIcon(int n, int n2, int n3) {
        this.drawImage = n;
        this.draw = new Dimension(n2, n3);
    }

    public ChartIcon(String string) {
        this.fill = ChartGraphicsUtil.copyImage(string);
        if (this.fill == null) {
            return;
        }
        this.equals = string;
        this.draw = new Dimension(this.fill.getWidth(), this.fill.getHeight());
        this.drawImage = BUILTINICON.length;
    }

    protected ChartIcon(int n, Dimension dimension, String string, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern, boolean bl) {
        this.fill = ChartGraphicsUtil.copyImage(string);
        if (this.fill == null) {
            return;
        }
        this.drawImage = n;
        this.draw = dimension;
        this.equals = string;
        this.closePath = chartPenStyle;
        this.clone = chartFillPattern;
        this.copyImage = bl;
    }

    public Object clone() {
        ChartPenStyle chartPenStyle = null;
        ChartFillPattern chartFillPattern = null;
        if (this.closePath != null) {
            chartPenStyle = (ChartPenStyle)this.closePath.clone();
        }
        if (this.clone != null) {
            chartFillPattern = (ChartFillPattern)this.clone.clone();
        }
        ChartIcon chartIcon = new ChartIcon();
        chartIcon.setColor(chartFillPattern);
        chartIcon.setPen(chartPenStyle);
        chartIcon.setIconWidth(this.getIconWidth());
        chartIcon.setIconHeight(this.getIconHeight());
        chartIcon.setStrikethrough(this.getStrikethrough());
        chartIcon.setIconStyle(this.getIconStyle());
        return chartIcon;
    }

    public boolean isNoIcon() {
        return this.drawImage == BUILTINICON.length && this.equals == null;
    }

    public int getIconStyle() {
        return this.drawImage;
    }

    public void setIconStyle(int n) {
        this.drawImage = n;
    }

    public void setStrikethrough(boolean bl) {
        if (bl && !this.copyImage) {
            this.draw.width *= 3;
        }
        if (!bl && this.copyImage) {
            this.draw.width /= 3;
        }
        this.copyImage = bl;
    }

    public boolean getStrikethrough() {
        return this.copyImage;
    }

    public void setColor(ChartFillPattern chartFillPattern) {
        this.clone = chartFillPattern;
    }

    public ChartFillPattern getColor() {
        return this.clone;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.closePath = chartPenStyle;
    }

    public ChartPenStyle getPen() {
        return this.closePath;
    }

    public String getIconFileName() {
        return this.equals;
    }

    public void setIconFileName(String string) {
        this.equals = string;
        this.drawImage = BUILTINICON.length;
    }

    public int getIconType() {
        return this.drawImage;
    }

    public void setIconType(int n) {
        this.drawImage = n;
    }

    public int getIconHeight() {
        return this.draw.height;
    }

    public void setIconHeight(int n) {
        this.draw.height = n;
    }

    public int getIconWidth() {
        return this.draw.width;
    }

    public void setIconWidth(int n) {
        this.draw.width = n;
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        if (this.closePath == null) {
            this.closePath = new ChartPenStyle(new ChartColorPattern(Color.blue));
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GeneralPath generalPath = new GeneralPath();
        RectangularShape rectangularShape = null;
        int n3 = this.draw.width;
        int n4 = this.draw.height;
        if (this.copyImage) {
            generalPath.moveTo(n, n2 + n4 / 2 - 1);
            generalPath.lineTo(n + n3 - 1, n2 + n4 / 2 - 1);
            this.closePath.draw(graphics2D, generalPath);
            generalPath = new GeneralPath();
            n += (n3 /= 3);
        }
        switch (this.drawImage) {
            case 0: {
                rectangularShape = new Rectangle(n, n2, n3 - 1, n4 - 1);
                if (this.clone != null) {
                    this.clone.fill(graphics2D, rectangularShape);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, rectangularShape);
                break;
            }
            case 1: {
                generalPath.moveTo(n + n3 / 2, n2);
                generalPath.lineTo(n + n3, n2 + n4 / 2);
                generalPath.lineTo(n + n3 / 2, n2 + n4);
                generalPath.lineTo(n, n2 + n4 / 2);
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 2: {
                generalPath.moveTo(n + n3 / 2 - 1, n2);
                generalPath.lineTo(n + n3 - 1, n2 + n4 - 1);
                generalPath.lineTo(n, n2 + n4 - 1);
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 3: {
                generalPath.moveTo(n + n3 / 2 - 1, n2 + n4 - 1);
                generalPath.lineTo(n + n3 - 1, n2);
                generalPath.lineTo(n, n2);
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 4: {
                generalPath.moveTo(n, n2 + n4 / 2 - 1);
                generalPath.lineTo(n + n3 - 1, n2);
                generalPath.lineTo(n + n3 - 1, n2 + n4 - 1);
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 5: {
                generalPath.moveTo(n, n2);
                generalPath.lineTo(n, n2 + n4 - 1);
                generalPath.lineTo(n + n3 - 1, n2 + n4 / 2 - 1);
                generalPath.closePath();
                if (this.clone != null) {
                    this.clone.fill(graphics2D, generalPath);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 6: {
                rectangularShape = new Ellipse2D.Float(n, n2, n3 - 2, n4 - 2);
                if (this.clone != null) {
                    this.clone.fill(graphics2D, rectangularShape);
                }
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, rectangularShape);
                break;
            }
            case 7: {
                generalPath.moveTo(n + n3 / 2 - 1, n2);
                generalPath.lineTo(n + n3 / 2 - 1, n2 + n4 - 1);
                generalPath.moveTo(n, n2 + n4 / 2 - 1);
                generalPath.lineTo(n + n3 - 1, n2 + n4 / 2 - 1);
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            case 8: {
                generalPath.moveTo(n, n2);
                generalPath.lineTo(n + n3 - 1, n2 + n4 - 1);
                generalPath.moveTo(n + n3 - 1, n2);
                generalPath.lineTo(n, n2 + n4 - 1);
                this.closePath.draw(graphics2D, generalPath);
                break;
            }
            default: {
                if (this.equals == null || this.equals.length() == 0) {
                    return;
                }
                if (this.fill == null) {
                    this.fill = ChartGraphicsUtil.copyImage(this.equals);
                    if (this.fill == null) {
                        return;
                    }
                }
                graphics.drawImage(this.fill, n, n2, n3, n4, null);
                if (this.copyImage) break;
                this.closePath.draw(graphics2D, new Rectangle(n, n2, n3, n4));
            }
        }
    }

    public static String[] getBuiltinIcons() {
        return BUILTINICON;
    }

    public static String[] getVAlignment() {
        return QOIV;
    }

    public static String[] getHAlignment() {
        return blue;
    }

    public static ChartIcon getBuiltinIcon(String string) {
        int n = 0;
        while (n < BUILTINICON.length) {
            if (string.equals(BUILTINICON[n])) {
                return new ChartIcon(n);
            }
            ++n;
        }
        return null;
    }

    public Icon getPaintedIcon() {
        return new Icon(this){
            private final ChartIcon this$0;
            {
                this.this$0 = chartIcon;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                this.this$0.paintIcon(graphics, n, n2);
            }

            public int getIconWidth() {
                return this.this$0.getIconWidth();
            }

            public int getIconHeight() {
                return this.this$0.getIconHeight();
            }
        };
    }
}

