/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.ChartEnv;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;

public class ChartTextStyle
implements Cloneable {
    private boolean QOIV;
    private static final ChartColorPattern WORDWRAPPER_GAP = new ChartColorPattern(new Color(128, 128, 128));
    public static final int ROT_LEFT = 0;
    public static final int ROT_MID = 1;
    public static final int ROT_RIGHT = 2;
    private static final String[] add = new String[]{"NONE", "Single", "Single Lower", "Bold Line", "Bold Lower", "Double Lines", "Bold Double", "Patterned Line", "Bold Patterned"};
    private static final String[] append = new String[]{"NONE", "Thin Line", "Bold Line", "Double Lines"};
    private static final String[] clone = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    public static final int NONE = 0;
    public static final int EMBOSSED = 1;
    public static final int ENGRAVED = 2;
    public static final int SHADOWED = 4;
    public static final int SUPERSCRIPT = 8;
    public static final int SUBSCRIPT = 16;
    public static final int DRAWOUTLINE = 32;
    private String closePath;
    private int createInverse;
    private int createUnion;
    private ChartPenStyle draw;
    private ChartFillPattern fill;
    private int get;
    private int getAscent;
    private double getAttributes;
    private float getBounds;
    private int getBounds2D;
    private GeneralPath getColor;
    private GeneralPath getDescent;
    private TextLayout getFont;
    private float getFontName;
    private float getFontRenderContext;
    private AffineTransform getHeight;
    private float getIterator = -1.0f;
    private boolean getLineMetrics;
    private int getOutline = 1;
    private Rectangle2D[] getPaint;
    private Vector getPathIterator;
    private double getPenColor;
    private double getPenWidth;
    private float getRealFont = 0.0f;

    public ChartTextStyle() {
        this("Dialog", 12, 0, new ChartPenStyle(), new ChartColorPattern(), 0, 0, 0.0, 0.0f, 0, false);
    }

    public ChartTextStyle(String string, int n, int n2) {
        this(string, n, n2, new ChartPenStyle(), new ChartColorPattern(), 0, 0, 0.0, 0.0f, 0, false);
    }

    public ChartTextStyle(String string, int n, int n2, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern, int n3, int n4, double d, float f, int n5, boolean bl) {
        this.closePath = string;
        this.createInverse = n;
        this.createUnion = n2;
        this.draw = chartPenStyle;
        this.fill = chartFillPattern;
        this.get = n3;
        this.getAscent = n4;
        this.getAttributes = d;
        this.getBounds = f;
        this.getBounds2D = n5;
        this.getLineMetrics = bl;
    }

    private void QOIV(FontRenderContext fontRenderContext, String string) {
        if (string == null || string.length() <= 0) {
            this.getFont = null;
            return;
        }
        if (this.QOIV && this.getFont != null) {
            return;
        }
        this.getLineMetrics = this.getAttributes == 0.0 ? this.getLineMetrics : false;
        Font font = new Font(this.closePath, this.createUnion, this.createInverse);
        if (this.closePath.startsWith("*")) {
            font = ChartEnv.getRealFont(this.closePath, this.createUnion, this.createInverse);
        }
        if (fontRenderContext == null) {
            this.getHeight = new AffineTransform();
            fontRenderContext = new FontRenderContext(this.getHeight, true, true);
        } else {
            this.getHeight = fontRenderContext.getTransform();
        }
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        float f = textLayout.getVisibleAdvance();
        this.draw(lineMetrics, f);
        this.fill(lineMetrics, f);
        float f2 = this.isSuperscript() ? -1.0f : 0.0f;
        float f3 = f2 = this.isSubscript() ? 1.0f : f2;
        if (f2 != 0.0f) {
            float f4 = lineMetrics.getAscent() / 2.0f;
            float f5 = 0.6666667f;
            float f6 = f * (1.0f - f5) / 2.0f;
            this.getHeight.scale(f5, f5);
            this.getHeight.translate(f6, f2 * f4);
        }
        this.getHeight.shear(this.getBounds, 0.0);
        this.getHeight.rotate(this.getAttributes);
        this.getFont = new TextLayout(string, font, fontRenderContext);
        if (this.getLineMetrics && this.getIterator >= 0.0f) {
            this.get(fontRenderContext, string);
        }
        this.QOIV = true;
    }

    public Rectangle2D getDimension(Graphics2D graphics2D, String string) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return this.WORDWRAPPER_GAP(fontRenderContext, string);
    }

    public Rectangle2D getDimension(String string) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        return this.WORDWRAPPER_GAP(fontRenderContext, string);
    }

    public Rectangle2D getZeroRotationDimension(String string) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        this.getAttributes = 0.0;
        return this.WORDWRAPPER_GAP(fontRenderContext, string);
    }

    private Rectangle2D WORDWRAPPER_GAP(FontRenderContext fontRenderContext, String string) {
        Rectangle2D rectangle2D;
        this.QOIV = false;
        this.QOIV(fontRenderContext, string);
        if (this.getFont == null || string == null) {
            return new Rectangle2D.Float();
        }
        if (!this.getLineMetrics || !(this.getIterator >= 0.0f)) {
            Rectangle2D rectangle2D2 = this.getFont.getBounds();
            Shape shape = this.getFont.getOutline(this.getHeight);
            rectangle2D = shape.getBounds2D();
            this.getPenColor = rectangle2D2.getX();
            this.getPenWidth = rectangle2D2.getY() - rectangle2D.getHeight();
        } else {
            Rectangle2D rectangle2D3 = ((TextLayout)this.getPathIterator.get(0)).getBounds();
            double d = rectangle2D3.getWidth();
            double d2 = this.getPaint[0].getHeight();
            int n = 1;
            while (n < this.getOutline) {
                d2 += this.getPaint[n].getHeight() + (double)ChartEnv.WORDWRAPPER_GAP;
                rectangle2D3.createUnion(this.getPaint[n]);
                d = d < this.getPaint[n].getWidth() ? this.getPaint[n].getWidth() : d;
                ++n;
            }
            rectangle2D3.setRect(this.getFont.getBounds().getX(), this.getFont.getBounds().getY(), d, d2 += (double)ChartEnv.WORDWRAPPER_GAP);
            this.getPenColor = this.getFont.getBounds().getX();
            this.getPenWidth = this.getFont.getBounds().getY() - d2;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(rectangle2D3.getPathIterator(this.getHeight), false);
            rectangle2D = generalPath.getBounds2D();
        }
        return rectangle2D;
    }

    public void drawText(Graphics2D graphics2D, String string, float f, float f2) {
        if (!this.QOIV) {
            this.QOIV(graphics2D.getFontRenderContext(), string);
        }
        if (this.getFont == null) {
            return;
        }
        boolean bl = false;
        float f3 = 0.0f;
        if (this.isShadowed()) {
            f3 = this.getFontName;
            bl = true;
        } else if (this.isEmbossed()) {
            f3 = 1.0f;
            bl = true;
        } else if (this.isEngraved()) {
            f3 = -1.0f;
            bl = true;
        }
        graphics2D.translate(f, f2);
        graphics2D.transform(this.getHeight);
        if (bl) {
            graphics2D.translate(f3, f3);
            this.closePath(graphics2D, true);
            this.add(graphics2D, true);
            this.createUnion(graphics2D, true);
            graphics2D.translate(-f3, -f3);
        }
        this.closePath(graphics2D, false);
        this.add(graphics2D, false);
        this.createUnion(graphics2D, false);
        try {
            graphics2D.transform(this.getHeight.createInverse());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics2D.translate(-f, -f2);
    }

    private void add(Graphics2D graphics2D, boolean bl) {
        Paint paint;
        Rectangle2D rectangle2D = this.getFont.getBounds();
        Paint paint2 = paint = this.fill == null ? null : this.fill.getPaint(graphics2D, rectangle2D);
        if (paint != null && !this.isOutlined()) {
            this.clone(paint, graphics2D, bl);
        } else {
            this.append(graphics2D, bl);
        }
    }

    private void append(Graphics2D graphics2D, boolean bl) {
        Shape shape = this.getFont.getOutline(null);
        if (bl) {
            WORDWRAPPER_GAP.fill(graphics2D, shape);
        } else {
            if (this.fill != null) {
                this.fill.fill(graphics2D, shape);
            }
            if (this.isOutlined()) {
                this.draw.draw(graphics2D, shape);
            }
        }
    }

    private void clone(Paint paint, Graphics2D graphics2D, boolean bl) {
        Paint paint2 = graphics2D.getPaint();
        if (bl) {
            graphics2D.setColor(WORDWRAPPER_GAP.getColor());
        } else {
            graphics2D.setPaint(paint);
        }
        if (this.getLineMetrics && this.getOutline > 1) {
            this.getAscent(graphics2D);
        } else {
            this.append(graphics2D, bl);
        }
        graphics2D.setPaint(paint2);
    }

    private void closePath(Graphics2D graphics2D, boolean bl) {
        if (this.get != 0 && this.getColor != null) {
            switch (this.get) {
                case 1: 
                case 2: 
                case 5: {
                    if (bl) {
                        this.createInverse(graphics2D, this.getColor);
                        break;
                    }
                    this.draw.draw(graphics2D, this.getColor);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    float f = this.draw.getPenWidth();
                    this.draw.setPenWidth(this.getFontName);
                    if (bl) {
                        this.createInverse(graphics2D, this.getColor);
                    } else {
                        this.draw.draw(graphics2D, this.getColor);
                    }
                    this.draw.setPenWidth(f);
                    break;
                }
                case 7: 
                case 8: {
                    if (bl) {
                        WORDWRAPPER_GAP.fill(graphics2D, this.getColor);
                        break;
                    }
                    if (this.fill != null) {
                        this.fill.fill(graphics2D, this.getColor);
                    }
                    if (!this.isOutlined()) break;
                    this.draw.draw(graphics2D, this.getColor);
                }
            }
        }
    }

    private void createInverse(Graphics2D graphics2D, GeneralPath generalPath) {
        ChartColorPattern chartColorPattern = this.draw.getPenColor();
        this.draw.setPenColor(WORDWRAPPER_GAP);
        this.draw.draw(graphics2D, generalPath);
        this.draw.setPenColor(chartColorPattern);
    }

    private void createUnion(Graphics2D graphics2D, boolean bl) {
        if (this.getAscent != 0) {
            if (this.getAscent == 2) {
                float f = this.draw.getPenWidth();
                this.draw.setPenWidth(this.getFontRenderContext);
                if (bl) {
                    this.createInverse(graphics2D, this.getDescent);
                } else {
                    this.draw.draw(graphics2D, this.getDescent);
                }
                this.draw.setPenWidth(f);
            } else if (bl) {
                this.createInverse(graphics2D, this.getDescent);
            } else {
                this.draw.draw(graphics2D, this.getDescent);
            }
        }
    }

    private void draw(LineMetrics lineMetrics, float f) {
        this.getFontName = lineMetrics.getUnderlineThickness();
        this.getColor = new GeneralPath();
        float f2 = lineMetrics.getUnderlineOffset();
        float f3 = lineMetrics.getDescent();
        float f4 = this.getFontName;
        f2 += f4 / 3.0f;
        f3 += f4 / 3.0f;
        switch (this.get) {
            case 1: {
                this.getColor.moveTo(0.0f, f2);
                this.getColor.lineTo(f, f2);
                this.getRealFont += f2;
                break;
            }
            case 2: {
                this.getColor.moveTo(0.0f, f3);
                this.getColor.lineTo(f, f3);
                this.getRealFont += f3;
                break;
            }
            case 3: {
                this.getColor.moveTo(0.0f, f2 + f4 / 2.0f);
                this.getColor.lineTo(f, f2 + f4 / 2.0f);
                this.getRealFont += f2 + f4 / 2.0f;
                break;
            }
            case 4: {
                this.getColor.moveTo(0.0f, f3 + f4 / 2.0f);
                this.getColor.lineTo(f, f3 + f4 / 2.0f);
                this.getRealFont += f3 + f4 / 2.0f;
                break;
            }
            case 5: {
                this.getColor.moveTo(0.0f, f2);
                this.getColor.lineTo(f, f2);
                this.getColor.moveTo(0.0f, f3);
                this.getColor.lineTo(f, f3);
                this.getRealFont += f3;
                break;
            }
            case 6: {
                this.getColor.moveTo(0.0f, f2 + f4 / 2.0f);
                this.getColor.lineTo(f, f2 + f4 / 2.0f);
                this.getColor.moveTo(0.0f, f3 + f4 / 2.0f);
                this.getColor.lineTo(f, f3 + f4 / 2.0f);
                this.getRealFont += f3 + f4 / 2.0f;
                break;
            }
            case 7: {
                this.getColor.moveTo(0.0f, f2);
                this.getColor.lineTo(f, f2);
                this.getColor.lineTo(f, f2 + f4);
                this.getColor.lineTo(0.0f, f2 + f4);
                this.getColor.closePath();
                this.getRealFont += f2 + f4;
                break;
            }
            case 8: {
                this.getColor.moveTo(0.0f, f2);
                this.getColor.lineTo(f, f2);
                this.getColor.lineTo(f, f3);
                this.getColor.lineTo(0.0f, f3);
                this.getColor.closePath();
                this.getRealFont += f3;
            }
        }
    }

    private void fill(LineMetrics lineMetrics, float f) {
        float f2;
        float f3 = lineMetrics.getStrikethroughOffset();
        this.getDescent = new GeneralPath();
        this.getFontRenderContext = f2 = lineMetrics.getStrikethroughThickness();
        switch (this.getAscent) {
            case 1: {
                this.getDescent.moveTo(0.0f, f3);
                this.getDescent.lineTo(f, f3);
                break;
            }
            case 2: {
                this.getDescent.moveTo(0.0f, f3 + f2 / 2.0f);
                this.getDescent.lineTo(f, f3 + f2 / 2.0f);
                break;
            }
            case 3: {
                this.getDescent.moveTo(0.0f, f3 - f2);
                this.getDescent.lineTo(f, f3 - f2);
                this.getDescent.moveTo(0.0f, f3 + f2);
                this.getDescent.lineTo(f, f3 + f2);
            }
        }
    }

    private void get(FontRenderContext fontRenderContext, String string) {
        AttributedString attributedString = new AttributedString(string, this.getFont().getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        this.getOutline = 0;
        this.getPathIterator = new Vector(0, 1);
        this.getPaint = new Rectangle2D[string.length()];
        TextLayout textLayout = lineBreakMeasurer.nextLayout(this.getIterator);
        while (textLayout != null) {
            this.getPathIterator.add(textLayout);
            this.getPaint[this.getOutline] = (Rectangle2D.Float)textLayout.getBounds();
            ++this.getOutline;
            textLayout = lineBreakMeasurer.nextLayout(this.getIterator);
        }
        this.getAttributes();
    }

    private void getAscent(Graphics2D graphics2D) {
        float f = 0.0f;
        int n = 0;
        while (n < this.getOutline) {
            graphics2D.translate(0.0, f += n == 0 ? 0.0f : (float)this.getPaint[n].getHeight() + (float)ChartEnv.WORDWRAPPER_GAP);
            Shape shape = ((TextLayout)this.getPathIterator.get(n)).getOutline(null);
            if (this.fill != null) {
                this.fill.fill(graphics2D, shape);
            }
            graphics2D.translate(0.0, -f);
            ++n;
        }
    }

    private void getAttributes() {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        while (n < this.getOutline) {
            generalPath.reset();
            generalPath.append(this.getPaint[n].getPathIterator(this.getHeight), false);
            this.getPaint[n] = (Rectangle2D.Float)generalPath.getBounds2D();
            ++n;
        }
    }

    public String getFontName() {
        return this.closePath;
    }

    public int getFontStyle() {
        return this.createUnion;
    }

    public int getFontSize() {
        return this.createInverse;
    }

    public ChartPenStyle getFontPen() {
        return this.draw;
    }

    public ChartFillPattern getFontColor() {
        return this.fill;
    }

    public Color getTextColor() {
        return ((ChartColorPattern)this.fill).getColor();
    }

    public int getUnderline() {
        return this.get;
    }

    public float getUnderlineHeight() {
        return this.getRealFont;
    }

    public int getStrikethrough() {
        return this.getAscent;
    }

    public double getRotation() {
        return this.getAttributes;
    }

    public float getShearing() {
        return this.getBounds;
    }

    public boolean isEmbossed() {
        return (this.getBounds2D & 1) == 1;
    }

    public boolean isEngraved() {
        return (this.getBounds2D & 2) == 2;
    }

    public boolean isShadowed() {
        return (this.getBounds2D & 4) == 4;
    }

    public boolean isSuperscript() {
        return (this.getBounds2D & 8) == 8;
    }

    public boolean isSubscript() {
        return (this.getBounds2D & 0x10) == 16;
    }

    public boolean isOutlined() {
        return (this.getBounds2D & 0x20) == 32;
    }

    public void setFontName(String string) {
        this.closePath = string;
        this.getBounds();
    }

    public void setFontStyle(int n) {
        this.createUnion = n;
        this.getBounds();
    }

    public void setFontSize(int n) {
        this.createInverse = n;
        this.getBounds();
    }

    public void setFontPen(ChartPenStyle chartPenStyle) {
        this.draw = chartPenStyle;
    }

    public void setFontColor(ChartFillPattern chartFillPattern) {
        this.fill = chartFillPattern;
    }

    public void setUnderline(int n) {
        this.get = n;
        this.getBounds();
    }

    public void setStrikethrough(int n) {
        this.getAscent = n;
        this.getBounds();
    }

    public void setRotation(double d) {
        this.getAttributes = d;
        this.getBounds();
    }

    public void setShearing(float f) {
        this.getBounds = f;
        this.getBounds();
    }

    public void toggleEmbossed() {
        this.getBounds2D ^= 1;
        this.getBounds2D &= 0xFFFFFFD9;
    }

    public void toggleEngraved() {
        this.getBounds2D ^= 2;
        this.getBounds2D &= 0xFFFFFFDA;
    }

    public void toggleShadowed() {
        this.getBounds2D ^= 4;
        this.getBounds2D &= 0xFFFFFFFC;
    }

    public void toggleOutlined() {
        this.getBounds2D ^= 0x20;
        this.getBounds2D &= 0xFFFFFFFC;
    }

    public void toggleSuperscript() {
        this.getBounds2D ^= 8;
        this.getBounds2D &= 0xFFFFFFEF;
        this.getBounds();
    }

    public void toggleSubscript() {
        this.getBounds2D ^= 0x10;
        this.getBounds2D &= 0xFFFFFFF7;
        this.getBounds();
    }

    private void getBounds() {
        this.QOIV = false;
    }

    public Font getFont() {
        if (this.closePath.startsWith("*")) {
            return ChartEnv.getRealFont(this.closePath, this.createUnion, this.createInverse);
        }
        return new Font(this.closePath, this.createUnion, this.createInverse);
    }

    public static String[] getBuiltinFontStyles() {
        return clone;
    }

    public static String[] getBuiltinUnderlines() {
        return add;
    }

    public static String[] getBuiltinStrikethrough() {
        return append;
    }

    public void setWordWrap(float f) {
        this.getIterator = f < 0.0f ? 0.0f : f;
        this.getLineMetrics = true;
        this.getBounds();
    }

    public boolean getWordWrapper() {
        return this.getLineMetrics;
    }

    public void setWordWrapper(boolean bl) {
        this.getLineMetrics = bl;
        this.getBounds();
    }

    public int getWrapperGap() {
        return ChartEnv.WORDWRAPPER_GAP;
    }

    public double getX() {
        return this.getPenColor;
    }

    public double getY() {
        return this.getPenWidth;
    }

    public Object clone() {
        ChartFillPattern chartFillPattern = null;
        if (this.fill != null) {
            chartFillPattern = (ChartFillPattern)this.fill.clone();
        }
        return new ChartTextStyle(this.closePath, this.createInverse, this.createUnion, (ChartPenStyle)this.draw.clone(), chartFillPattern, this.get, this.getAscent, this.getAttributes, this.getBounds, this.getBounds2D, this.getLineMetrics);
    }

    public void setForeground(Color color) {
        this.draw.getPenColor().setColor(color);
        ChartFillPattern chartFillPattern = this.fill;
        if (chartFillPattern instanceof ChartColorPattern) {
            ((ChartColorPattern)chartFillPattern).setColor(color);
        } else {
            this.fill = new ChartColorPattern(color);
        }
    }

    public void setFont(Font font) {
        this.closePath = font.getFontName();
        this.createInverse = font.getSize();
        this.createUnion = font.getStyle();
        this.getBounds();
    }

    public double getWordWrapFristLineHeight() {
        if (this.getPaint != null) {
            return this.getPaint[0].getHeight();
        }
        return -1.0;
    }
}

