/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.ps;

import com.jinfonet.awt.JFont;
import com.jinfonet.awt.ps.Margin;
import com.jinfonet.awt.ps.PixelConsumer;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class PSGraphics
extends Graphics
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1000000L;
    static Margin D = new Margin();
    private boolean closed = false;
    private Point delt = new Point(0, 0);
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private Vector oblique = new Vector();
    protected int pageheight = 792;
    protected int pagewidth = 612;
    protected PrintWriter writer = new PrintWriter(System.out);
    int orientation = 1;
    Color forground = Color.black;
    Color background = Color.white;
    Font font = new Font("Helvetica", 0, 10);
    boolean bDupped = false;
    int savelevel = 0;
    Rectangle clippingRect = new Rectangle(0, 0, this.pagewidth, this.pageheight);
    private boolean disposed = false;
    private boolean inited = false;
    private Hashtable fontset = new Hashtable();
    private boolean useFile;
    protected static final int RESOLUTION = 72;
    static final char[] QOIV = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Hashtable addElement = new Hashtable();
    boolean noMargin = false;
    int pageNumber = 0;

    public PSGraphics() {
        addElement.put("default", "Helvetica");
        addElement.put("dialog", "Helvetica");
        addElement.put("dialoginput", "Courier");
        addElement.put("serif", "Times");
        addElement.put("sansserif", "Helvetica");
        addElement.put("monospaced", "Courier");
        addElement.put("timesroman", "Times");
        addElement.put("courier", "Courier");
        addElement.put("helvetica", "Helvetica");
        addElement.put("symobl", "Symobl");
        this.oblique.addElement("Courier");
        this.oblique.addElement("Helvetica");
    }

    public PSGraphics(File file) throws IOException {
        this(file, false);
    }

    public PSGraphics(File file, boolean bl) throws IOException {
        this(new FileOutputStream(file), bl);
        this.useFile = true;
    }

    public PSGraphics(OutputStream outputStream) throws IOException {
        this(outputStream, false);
    }

    public PSGraphics(OutputStream outputStream, boolean bl) {
        this();
        this.setOutput(outputStream);
        this.noMargin = bl;
    }

    public void clearRect(double d, double d2, double d3, double d4) {
        this.D(this.writer, "%clearRect");
        this.gsave();
        Color color = this.getColor();
        this.setColor(this.background);
        this.bDupped(d, d2, d3, d4, true);
        this.setColor(color);
        this.grestore();
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.clearRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            d3 = 0.0;
            d4 = 0.0;
        }
        double d5 = d3;
        double d6 = d4 * (double)Unit.getResolution() / 60.0;
        this.D(this.writer, "%clipRect");
        this.clippingRect = this.clippingRect.intersection(new Rectangle((int)d, (int)d2, (int)d5, (int)d6));
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.println(String.valueOf(d) + " " + d2 + " moveto");
        this.writer.println(String.valueOf(d + d5) + " " + d2 + " lineto");
        this.writer.println(String.valueOf(d + d5) + " " + (d2 - d6) + " lineto");
        this.writer.println(String.valueOf(d) + " " + (d2 - d6) + " lineto");
        this.writer.println("closepath eoclip newpath");
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void close() {
        if (!this.closed) {
            this.writer.println("%%EOF");
            if (this.useFile) {
                this.writer.close();
            } else {
                this.writer.flush();
            }
            this.closed = true;
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("copyArea not supported");
    }

    public Graphics create() {
        try {
            this.D(this.writer, "%create");
            PSGraphics pSGraphics = (PSGraphics)this.clone();
            pSGraphics.delt = new Point(this.delt);
            pSGraphics.savelevel = 0;
            pSGraphics.font = this.font;
            pSGraphics.bDupped = true;
            pSGraphics.setClip(0, 0, this.clippingRect.width, this.clippingRect.height);
            pSGraphics.delt.x = this.delt.x;
            pSGraphics.delt.y = this.delt.y;
            return pSGraphics;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    void D(PrintWriter printWriter, String string) {
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            if (this.bDupped) {
                while (this.savelevel > 0) {
                    this.D(this.writer, "%dispose");
                    this.grestore();
                }
            } else {
                this.D(this.writer, "%dispose");
                this.writer.println("showpage");
                this.writer.flush();
                this.startPage();
            }
        }
    }

    public void disposeEndPage() {
        if (!this.disposed) {
            this.disposed = true;
            if (this.bDupped) {
                while (this.savelevel > 0) {
                    this.D(this.writer, "%dispose");
                    this.grestore();
                }
            } else {
                this.D(this.writer, "%dispose");
                this.writer.println("showpage");
                this.writer.flush();
            }
        }
    }

    private void QOIV(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.D(this.writer, "%doArc");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.gsave();
        double d7 = d + d3 / 2.0;
        double d8 = d2 - d4 / 2.0;
        this.writer.print(d7);
        this.writer.print(" ");
        this.writer.print(d8);
        this.writer.println(" translate");
        double d9 = d4 / d3;
        this.writer.print(1.0);
        this.writer.print(" ");
        this.writer.print(d9);
        this.writer.println(" scale");
        if (bl) {
            this.writer.println("0 0 moveto");
        } else if (d5 == 0.0 && d6 == 360.0) {
            this.writer.println(String.valueOf(d3 / 2.0) + " 0 moveto");
        }
        double d10 = d5 + d6;
        this.writer.print("0 0 ");
        this.writer.print(d3 / 2.0);
        this.writer.print(" ");
        this.writer.print(d5);
        this.writer.print(" ");
        this.writer.print(d10);
        this.writer.println(" arc");
        if (bl) {
            this.writer.println("closepath eofill");
        } else {
            this.writer.println("stroke");
        }
        this.grestore();
    }

    boolean addElement(PixelConsumer pixelConsumer, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        this.D(this.writer, "%doImage");
        pixelConsumer.produce();
        n2 = (int)this.transformY(n2);
        n = (int)this.transformX(n);
        this.gsave();
        this.D(this.writer, "% build a temporary dictionary");
        this.writer.println("20 dict begin");
        this.black(pixelConsumer.width);
        this.D(this.writer, "% lower left corner");
        this.writer.print(n);
        this.writer.print(" ");
        this.writer.print(n2);
        this.writer.println(" translate");
        if (n4 == 0 || n3 == 0) {
            n4 = pixelConsumer.height;
            n3 = pixelConsumer.width;
        }
        this.D(this.writer, "% size of image");
        this.writer.print(n3);
        this.writer.print(" ");
        this.writer.print(n4);
        this.writer.println(" scale");
        this.writer.print(pixelConsumer.width);
        this.writer.print(" ");
        this.writer.print(pixelConsumer.height);
        this.writer.println(" 8");
        this.writer.print("[");
        this.writer.print(pixelConsumer.width);
        this.writer.print(" 0 0 -");
        this.writer.print(pixelConsumer.height);
        this.writer.print(" 0 ");
        this.writer.print(0);
        this.writer.println("]");
        this.writer.println("{currentfile pix readhexstring pop}");
        this.writer.println("false 3 colorimage");
        this.writer.println("");
        int n5 = 0;
        char[] cArray = new char[73];
        int n6 = 0;
        while (n6 < pixelConsumer.height) {
            int n7 = 0;
            ++n5;
            int n8 = 0;
            while (n8 < pixelConsumer.width) {
                int n9 = pixelConsumer.pix[n8][n6];
                if ((n9 & 0xFF000000) == 0) {
                    n9 = color == null ? 0xFFFFFF : color.getRGB();
                }
                cArray[n7++] = QOIV[(n9 & 0xF00000) >> 20];
                cArray[n7++] = QOIV[(n9 & 0xF0000) >> 16];
                cArray[n7++] = QOIV[(n9 & 0xF000) >> 12];
                cArray[n7++] = QOIV[(n9 & 0xF00) >> 8];
                cArray[n7++] = QOIV[(n9 & 0xF0) >> 4];
                cArray[n7++] = QOIV[n9 & 0xF];
                if (n7 >= 72) {
                    String string = String.copyValueOf(cArray, 0, n7);
                    this.writer.println(string);
                    if (n5 > 5) {
                        try {
                            Thread.sleep(15L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        n5 = 0;
                    }
                    n7 = 0;
                }
                ++n8;
            }
            if (n7 != 0) {
                String string = String.copyValueOf(cArray, 0, n7);
                this.writer.println(string);
            }
            ++n6;
        }
        this.writer.println("");
        this.writer.println("end");
        this.grestore();
        return true;
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image, n5, n6, n7, n8);
        return this.addElement(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image);
        return this.addElement(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    private void append(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n >= 2) {
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray3[n2] = (int)this.transformY(nArray2[n2]);
                nArray4[n2] = (int)this.transformX(nArray[n2]);
                ++n2;
            }
            this.writer.println(String.valueOf(nArray4[0]) + " " + nArray3[0] + " moveto");
            n2 = 0;
            while (n2 < n) {
                this.writer.println(String.valueOf(nArray4[n2]) + " " + nArray3[n2] + " lineto");
                ++n2;
            }
            this.writer.println(String.valueOf(nArray4[0]) + " " + nArray3[0] + " lineto");
            if (bl) {
                this.writer.println("eofill");
            } else {
                this.writer.println("stroke");
            }
        }
    }

    private void bDupped(double d, double d2, double d3, double d4, boolean bl) {
        this.D(this.writer, "%doRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.print(d + " " + d2 + " moveto ");
        this.writer.print(d3 + " 0.0 rlineto 0.0 -");
        this.writer.print(d4 + " rlineto ");
        if (bl) {
            this.writer.println(-d3 + " 0.0 rlineto closepath eofill");
        } else {
            this.writer.println(-d3 + " 0.0 rlineto closepath stroke");
        }
    }

    private void background(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.D(this.writer, "%doRoundRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.print(d + d6);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.println(" moveto");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        if (bl) {
            this.writer.println("eofill");
        } else {
            this.writer.println("stroke");
        }
    }

    public void draw3DRect(double d, double d2, double d3, double d4, boolean bl) {
        this.D(this.writer, "%draw3DRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(d, d2, d, d2 - d4);
        this.drawLine(d + 1.0, d2, d + d3 - 1.0, d2);
        PSGraphics pSGraphics = this;
        pSGraphics.setColor(bl ? color3 : color2);
        this.drawLine(d + 1.0, d2 - d4, d + d3, d2 - d4);
        this.drawLine(d + d3, d2, d + d3, d2 - d4);
        this.setColor(color);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.draw3DRect((double)n, (double)n2, (double)n3, (double)n4, bl);
    }

    public void drawArc(double d, double d2, double d3, double d4, double d5, double d6) {
        this.D(this.writer, "%drawArc");
        this.QOIV(d, d2, d3, d4, d5, d6, false);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.D(this.writer, "%drawImage-6");
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.D(this.writer, "%drawImage-5");
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.D(this.writer, "%drawImage-4");
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.D(this.writer, "%drawImage-2");
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.D(this.writer, "%drawImage-3");
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.D(this.writer, "%drawImage-1");
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.D(this.writer, "%drawLine");
        d2 = this.transformY(d2);
        d4 = this.transformY(d4);
        d = this.transformX(d);
        d3 = this.transformX(d3);
        this.writer.println(d + " " + d2 + " moveto " + d3 + " " + d4 + " lineto stroke");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        this.D(this.writer, "%drawOval");
        this.QOIV(d, d2, d3, d4, 0.0, 360.0, false);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawPolygon(Polygon polygon) {
        this.D(this.writer, "%drawPoly");
        this.append(polygon.xpoints, polygon.ypoints, polygon.npoints, false);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.D(this.writer, "%drawPoly");
        this.append(nArray, nArray2, n, false);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        while (n2 < n) {
            this.drawLine(nArray[n2 - 1], nArray2[n2 - 1], nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        this.D(this.writer, "%drawRect");
        this.bDupped(d, d2, d3, d4, false);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.D(this.writer, "%drawRoundRect");
        this.background(d, d2, d3, d4, d5, d6, false);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void drawString(String string, double d, double d2) {
        this.D(this.writer, "%drawString");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == ' ') {
                ++n;
            }
            ++n3;
        }
        String string2 = PSGraphics.escapeString(string);
        this.writer.print(String.valueOf(this.getFontMetrics().stringWidth(string)) + " ");
        this.writer.println("(" + string2 + ") dup 3 1 roll ");
        this.writer.print("stringwidth pop " + (n *= n2) + " sub ");
        this.writer.println("sub " + string.length() + " div");
        this.writer.print(String.valueOf(d) + " " + d2 + " moveto ");
        this.writer.println("-" + n2 + " 0 32 4 -1 roll 0 6 -1 roll show");
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (double)n, (double)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void emit(String string) {
        this.writer.println(string);
    }

    void black(int n) {
        this.D(this.writer, "% Color picture stuff, lifted from XV's PS files");
        this.D(this.writer, "% define string to hold a scanline's worth of data");
        this.writer.print("/pix ");
        this.writer.print(n * 3);
        this.writer.println(" string def");
        this.D(this.writer, "% define space for color conversions");
        this.writer.print("/grays ");
        this.writer.print(n);
        this.writer.println(" string def  % space for gray scale line");
        this.writer.println("/npixls 0 def");
        this.writer.println("/rgbindx 0 def");
        this.D(this.writer, "% define 'colorimage' if it isn't defined");
        this.D(this.writer, "%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.D(this.writer, "%     via xgrab)");
        this.writer.println("/colorimage where   % do we know about 'colorimage'?");
        this.writer.println("{ pop }           % yes: pop off the 'dict' returned");
        this.writer.println("{                 % no:  define one");
        this.writer.println("/colortogray {  % define an RGB->I function");
        this.writer.println("/rgbdata exch store    % call input 'rgbdata'");
        this.writer.println("rgbdata length 3 idiv");
        this.writer.println("/npixls exch store");
        this.writer.println("/rgbindx 0 store");
        this.writer.println("0 1 npixls 1 sub {");
        this.writer.println("grays exch");
        this.writer.println("rgbdata rgbindx       get 20 mul    % Red");
        this.writer.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.writer.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.writer.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.writer.println("put");
        this.writer.println("/rgbindx rgbindx 3 add store");
        this.writer.println("} for");
        this.writer.println("grays 0 npixls getinterval");
        this.writer.println("} bind def");
        this.writer.println("");
        this.D(this.writer, "% Utility procedure for colorimage operator.");
        this.D(this.writer, "% This procedure takes two procedures off the");
        this.D(this.writer, "% stack and merges them into a single procedure.");
        this.writer.println("");
        this.writer.println("/mergeprocs { % def");
        this.writer.println("dup length");
        this.writer.println("3 -1 roll");
        this.writer.println("dup");
        this.writer.println("length");
        this.writer.println("dup");
        this.writer.println("5 1 roll");
        this.writer.println("3 -1 roll");
        this.writer.println("add");
        this.writer.println("array cvx");
        this.writer.println("dup");
        this.writer.println("3 -1 roll");
        this.writer.println("0 exch");
        this.writer.println("putinterval");
        this.writer.println("dup");
        this.writer.println("4 2 roll");
        this.writer.println("putinterval");
        this.writer.println("} bind def");
        this.writer.println("");
        this.writer.println("/colorimage { % def");
        this.writer.println("pop pop     % remove 'false 3' operands");
        this.writer.println("{colortogray} mergeprocs");
        this.writer.println("image");
        this.writer.println("} bind def");
        this.writer.println("} ifelse          % end of 'false' case");
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '(': {
                    stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    break;
                }
                default: {
                    if (string.charAt(n) > '\u00ff') {
                        stringBuffer.append("\\" + Integer.toString(string.charAt(n), 8));
                        break;
                    }
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void fill3DRect(double d, double d2, double d3, double d4, boolean bl) {
        this.D(this.writer, "%fill3DRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(d + 1.0, d2 + 1.0, d3 - 2.0, d4 - 2.0);
        this.setColor(bl ? color2 : color3);
        this.drawLine(d, d2, d, d2 - d4 - 1.0);
        this.drawLine(d + 1.0, d2, d + d3 - 2.0, d2);
        PSGraphics pSGraphics = this;
        pSGraphics.setColor(bl ? color3 : color2);
        this.drawLine(d + 1.0, d2 - d4 - 1.0, d + d3 - 1.0, d2 - d4 - 1.0);
        this.drawLine(d + d3 - 1.0, d2, d + d3 - 1.0, d2 - d4 - 1.0);
        this.setColor(color);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.fill3DRect((double)n, (double)n2, (double)n3, (double)n4, bl);
    }

    public void fillArc(double d, double d2, double d3, double d4, double d5, double d6) {
        this.D(this.writer, "%fillArc");
        this.QOIV(d, d2, d3, d4, d5, d6, true);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void fillOval(double d, double d2, double d3, double d4) {
        this.D(this.writer, "%fillOval");
        this.QOIV(d, d2, d3, d4, 0.0, 360.0, true);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void p(Polygon polygon) {
        this.D(this.writer, "%fillPoly");
        this.append(polygon.xpoints, polygon.ypoints, polygon.npoints, true);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.D(this.writer, "%fillPoly");
        this.append(nArray, nArray2, n, true);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.D(this.writer, "%fillRect");
        this.bDupped(d, d2, d3, d4, true);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void fillRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.D(this.writer, "%fillRoundRect");
        this.background(d, d2, d3, d4, d5, d6, true);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void finalize() {
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return this.clippingRect;
    }

    public Color getColor() {
        return this.forground;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        if (font instanceof JFont) {
            return ((JFont)((Object)font)).getFontMetrics();
        }
        return this.toolkit.getFontMetrics(font);
    }

    public String getFontName(Font font) {
        int n;
        String string = font instanceof JFont ? ((JFont)((Object)font)).getPSName() : font.getName();
        String string2 = (String)addElement.get(string.toLowerCase());
        if (string2 == null && (n = string.indexOf(46)) > 0) {
            string2 = (String)addElement.get(string.substring(0, n).toLowerCase());
        }
        return string2 == null ? string : string2;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Dimension getPageDimension() {
        return new Dimension(this.pagewidth, this.pageheight);
    }

    public void grestore() {
        this.writer.println("grestore");
        --this.savelevel;
    }

    public void gsave() {
        this.writer.println("gsave");
        ++this.savelevel;
    }

    public void putFontName(String string, String string2) {
        addElement.put(string, string2);
    }

    public void reset() {
        this.fontset.clear();
        this.disposed = false;
    }

    public double rtransformX(double d) {
        return d - (double)this.delt.x;
    }

    public double rtransformY(double d) {
        return -(d + (double)this.delt.y);
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setClip(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            d3 = 0.0;
            d4 = 0.0;
        }
        double d5 = d3 * (double)Unit.getResolution() / 60.0;
        double d6 = d4 * (double)Unit.getResolution() / 60.0;
        this.D(this.writer, "%setClip");
        this.clippingRect = new Rectangle((int)d, (int)d2, (int)d5, (int)d6);
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.println("initclip");
        this.writer.println(String.valueOf(d) + " " + d2 + " moveto");
        this.writer.println(String.valueOf((d + d5) * (double)Unit.getResolution() / 60.0) + " " + d2 + " lineto");
        this.writer.println(String.valueOf((d + d5) * (double)Unit.getResolution() / 60.0) + " " + (d2 - d6) + " lineto");
        this.writer.println(String.valueOf(d) + " " + (d2 - d6) + " lineto");
        this.writer.println("closepath eoclip newpath");
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void setClip(Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setColor(Color color) {
        this.D(this.writer, "%setColor");
        this.forground = color != null ? color : Color.black;
        this.writer.print((double)this.forground.getRed() / 255.0);
        this.writer.print(" ");
        this.writer.print((double)this.forground.getGreen() / 255.0);
        this.writer.print(" ");
        this.writer.print((double)this.forground.getBlue() / 255.0);
        this.writer.println(" setrgbcolor");
    }

    public void setFont(Font font) {
        this.D(this.writer, "%setFont");
        if (font != null) {
            this.font = font;
            int n = this.font.getStyle();
            String string = this.getFontName(this.font);
            boolean bl = false;
            if (!string.equals("Symbol")) {
                if ((n & 1) != 0 && (n & 2) != 0) {
                    string = String.valueOf(string) + (this.oblique.contains(string) ? "-BoldOblique" : "-BoldItalic");
                } else if ((n & 1) != 0) {
                    string = String.valueOf(string) + "-Bold";
                } else if ((n & 2) != 0) {
                    string = String.valueOf(string) + (this.oblique.contains(string) ? "-Oblique" : "-Italic");
                } else if (string.equals("Times")) {
                    string = String.valueOf(string) + "-Roman";
                }
            } else {
                bl = true;
            }
            if (this.fontset.get(string) == null) {
                this.writer.println("/(" + string + ") findfont");
                this.writer.println("dup length dict begin");
                this.writer.println("{1 index /FID ne {def} {pop pop} ifelse} forall");
                this.writer.println("/Encoding ISOLatin1Encoding def");
                this.writer.println("currentdict");
                this.writer.println("end");
                this.writer.println("/" + string.replace(' ', '-') + "-ISOLatin1 exch definefont pop");
                this.fontset.put(string, string);
            }
            if (bl) {
                this.writer.println("/" + string + " findfont");
            } else {
                this.writer.println("/" + string.replace(' ', '-') + "-ISOLatin1 findfont");
            }
            this.writer.println(this.font.getSize() + " scalefont setfont");
        }
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setOutput(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    public void setPageSize(double d, double d2) {
        this.pagewidth = (int)(72.0 * d);
        this.pageheight = (int)(72.0 * d2);
        this.clippingRect = new Rectangle((int)this.transformX(0.0), (int)this.transformY(0.0), this.pagewidth, this.pageheight);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
        System.err.println("Not supported");
    }

    public void startDoc() {
        if (!this.inited) {
            this.writer.println("%!PS-Adobe-2.0 Created by Jinfonet");
            if (this.orientation == 0) {
                this.writer.println("2 dict dup /PageSize[ " + this.pageheight + " " + this.pagewidth + " ] put dup /ImagingBBox null put setpagedevice");
            } else {
                this.writer.println("2 dict dup /PageSize[ " + this.pagewidth + " " + this.pageheight + " ] put dup /ImagingBBox null put setpagedevice");
            }
            this.startPage();
            this.inited = true;
        }
    }

    public void startPage() {
        ++this.pageNumber;
        this.writer.println("\n%%Page:  " + this.pageNumber + " " + this.pageNumber);
        if (this.noMargin) {
            PSGraphics.D.Z = 0.0;
            PSGraphics.D.I = 0.0;
        }
        if (this.orientation == 1) {
            this.writer.println(String.valueOf(PSGraphics.D.Z * 72.0) + " " + (double)this.pageheight * 72.0 / 72.0 + " translate");
        } else if (this.orientation == 0) {
            this.writer.println(String.valueOf((double)this.pageheight - PSGraphics.D.I * 72.0) + " " + ((double)this.pagewidth - PSGraphics.D.Z * 72.0) + " translate");
            this.writer.println("-90 rotate");
        }
        this.setFont(this.font);
        this.gsave();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public double transformX(double d) {
        return d + (double)this.delt.x;
    }

    public double transformY(double d) {
        return -(d + (double)this.delt.y);
    }

    public void translate(int n, int n2) {
        this.D(this.writer, "%translate");
        if (n == 1 && n2 == 1) {
            n = 0;
            n2 = 0;
        }
        this.delt.x += n;
        this.delt.y += n2;
    }

    public void rotate(double d) {
    }

    public void scale(double d, double d2) {
    }

    public void shear(double d, double d2) {
    }

    public void translate(double d, double d2) {
    }

    public void rotate(double d, double d2, double d3) {
    }

    public Color getBackground() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public void setComposite(Composite composite) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public Paint getPaint() {
        return null;
    }

    public void setPaint(Paint paint) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public void clip(Shape shape) {
    }

    public void draw(Shape shape) {
    }

    public void fill(Shape shape) {
    }

    public Stroke getStroke() {
        return null;
    }

    public void setStroke(Stroke stroke) {
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform affineTransform) {
    }

    public void transform(AffineTransform affineTransform) {
    }

    public void drawString(String string, float f, float f2) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
    }

    public void addRenderingHints(Map map) {
    }

    public void setRenderingHints(Map map) {
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return false;
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }
}

