/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util;

import java.io.ByteArrayOutputStream;

public class UnicodeConverter {
    private static final byte[] QOIV = new byte[]{0, 0, -64, -32, -16, -8, -4};
    private static final int[] toByteArray = new int[]{0, 12416, 925824, 63447168, -100130688, -2113396608};
    private static final short[] write = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};

    public static final byte[] ConvertUTF16toUTF8(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length / 2);
        int n = 0;
        int n2 = 191;
        int n3 = 128;
        while (n < byArray.length) {
            int n4;
            int n5;
            int n6 = 0;
            if ((n5 = (0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++]) >= 55296 && n5 <= 56319 && (n4 = (0xFF & byArray[n]) << 8 | 0xFF & byArray[n + 1]) >= 56320 && n4 <= 57343) {
                n5 = (n5 - 55296 << 10) + (n4 - 56320) + 65536;
                n += 2;
            }
            if (n5 < 128) {
                n6 = 1;
            } else if (n5 < 2048) {
                n6 = 2;
            } else if (n5 < 65536) {
                n6 = 3;
            } else if (n5 < 0x200000) {
                n6 = 4;
            } else if (n5 < 0x4000000) {
                n6 = 5;
            } else if (n5 <= Integer.MAX_VALUE) {
                n6 = 6;
            } else {
                n6 = 2;
                n5 = 65533;
            }
            byte[] byArray2 = new byte[n6];
            int n7 = n6 - 1;
            while (n7 >= 0) {
                if (n7 == 0) {
                    byArray2[n7] = (byte)(n5 | QOIV[n6]);
                } else {
                    byArray2[n7] = (byte)((n5 | n3) & n2);
                    n5 >>= 6;
                }
                --n7;
            }
            int n8 = 0;
            while (n8 < n6) {
                byteArrayOutputStream.write(0xFF & byArray2[n8]);
                ++n8;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] ConvertUTF8toUTF16(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3 = 0;
            int n4 = n2 = write[0xFF & byArray[n]];
            while (n4 >= 0) {
                n3 += 0xFF & byArray[n++];
                if (n4 != 0) {
                    n3 <<= 6;
                }
                --n4;
            }
            if ((n3 -= toByteArray[n2]) <= 65535) {
                byteArrayOutputStream.write((n3 & 0xFF00) >> 8);
                byteArrayOutputStream.write(n3 & 0xFF);
                continue;
            }
            if (n3 > 0x10FFFF) {
                byteArrayOutputStream.write(255);
                byteArrayOutputStream.write(253);
                continue;
            }
            int n5 = ((n3 -= 65536) >> 10) + 55296;
            byteArrayOutputStream.write((n5 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n5 & 0xFF);
            n5 = (n3 & 0x3FF) + 56320;
            byteArrayOutputStream.write((n5 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n5 & 0xFF);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ConvertUCS4toUTF16(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length / 2);
        int n = 0;
        while (n < byArray.length) {
            int n2;
            if ((n2 = (0xFF & byArray[n++]) << 24 | (0xFF & byArray[n++]) << 16 | (0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++]) <= 65535) {
                byteArrayOutputStream.write((n2 & 0xFF00) >> 8);
                byteArrayOutputStream.write(n2 & 0xFF);
                continue;
            }
            if (n2 > 0x10FFFF) {
                byteArrayOutputStream.write(255);
                byteArrayOutputStream.write(253);
                continue;
            }
            int n3 = ((n2 -= 65536) >> 10) + 55296;
            byteArrayOutputStream.write((n3 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n3 & 0xFF);
            n3 = (n2 & 0x3FF) + 56320;
            byteArrayOutputStream.write((n3 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n3 & 0xFF);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] ConvertUTF16toUCS4(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3;
            if ((n3 = (0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++]) >= 55296 && n3 <= 56319 && (n2 = (0xFF & byArray[n]) << 8 | 0xFF & byArray[n + 1]) >= 56320 && n2 <= 57343) {
                n3 = (n3 - 55296 << 10) + (n2 - 56320) + 65536;
                n += 2;
            }
            byteArrayOutputStream.write(0xFF & n3 >> 24);
            byteArrayOutputStream.write(0xFF & n3 >> 16);
            byteArrayOutputStream.write(0xFF & n3 >> 8);
            byteArrayOutputStream.write(0xFF & n3);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] ConvertUCS4toUTF8(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length / 4);
        int n = 0;
        int n2 = 191;
        int n3 = 128;
        while (n < byArray.length) {
            int n4;
            int n5;
            int n6 = 0;
            if ((n5 = (0xFF & byArray[n++]) << 24 | (0xFF & byArray[n++]) << 16 | (0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++]) >= 55296 && n5 <= 56319 && (n4 = (0xFF & byArray[n]) << 24 | (0xFF & byArray[n + 1]) << 16 | (0xFF & byArray[n + 2]) << 8 | 0xFF & byArray[n + 3]) >= 56320 && n4 <= 57343) {
                n5 = (n5 - 55296 << 10) + (n4 - 56320) + 65536;
                n += 4;
            }
            if (n5 < 128) {
                n6 = 1;
            } else if (n5 < 2048) {
                n6 = 2;
            } else if (n5 < 65536) {
                n6 = 3;
            } else if (n5 < 0x200000) {
                n6 = 4;
            } else if (n5 < 0x4000000) {
                n6 = 5;
            } else if (n5 <= Integer.MAX_VALUE) {
                n6 = 6;
            } else {
                n6 = 2;
                n5 = 65533;
            }
            byte[] byArray2 = new byte[n6];
            int n7 = n6 - 1;
            while (n7 >= 0) {
                if (n7 == 0) {
                    byArray2[n7] = (byte)(n5 | QOIV[n6]);
                } else {
                    byArray2[n7] = (byte)((n5 | n3) & n2);
                    n5 >>= 6;
                }
                --n7;
            }
            int n8 = 0;
            while (n8 < n6) {
                byteArrayOutputStream.write(0xFF & byArray2[n8]);
                ++n8;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] ConvertUTF8toUCS4(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 4);
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3 = 0;
            int n4 = n2 = write[0xFF & byArray[n]];
            while (n4 >= 0) {
                n3 += 0xFF & byArray[n++];
                if (n4 != 0) {
                    n3 <<= 6;
                }
                --n4;
            }
            if ((n3 -= toByteArray[n2]) <= 65535) {
                byteArrayOutputStream.write((n3 & 0xFF000000) >> 24);
                byteArrayOutputStream.write((n3 & 0xFF0000) >> 16);
                byteArrayOutputStream.write((n3 & 0xFF00) >> 8);
                byteArrayOutputStream.write(n3 & 0xFF);
                continue;
            }
            if (n3 > Integer.MAX_VALUE) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(255);
                byteArrayOutputStream.write(253);
                continue;
            }
            int n5 = ((n3 -= 65536) >> 10) + 55296;
            byteArrayOutputStream.write((n5 & 0xFF000000) >> 24);
            byteArrayOutputStream.write((n5 & 0xFF0000) >> 16);
            byteArrayOutputStream.write((n5 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n5 & 0xFF);
            n5 = (n3 & 0x3FF) + 56320;
            byteArrayOutputStream.write((n5 & 0xFF000000) >> 24);
            byteArrayOutputStream.write((n5 & 0xFF0000) >> 16);
            byteArrayOutputStream.write((n5 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n5 & 0xFF);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

