/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class Unit {
    public static final int UNIT = 5760;
    public static final int INCH = 0;
    public static final int CENTIMETER = 1;
    public static final int UNITCOUNT = 2;
    public static final int GRID = Unit.convertInchToUnit(0.06944444);
    private static final String[] QOIV = new String[]{"Inch", "cm"};
    public static final double ICMFACTOR = 2.54;
    public static final int SCREEN = 0;
    public static final int PRINT = 1;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int ORIENTCOUNT = 2;
    public static final int MAX_VALUE = 2147480000;
    private static final String[] abs = new String[]{"Portrait", "Landscape"};
    public static final int PAPERTYPECOUNT = 53;
    private static final String[] convertCentimeterToPixel = new String[]{"Letter", "Legal", "Executive", "4A0", "2A0", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "RA0", "RA1", "RA2", "SRA0", "SRA1", "SRA2", "Envelope C3", "Envelope B4", "Envelope C4", "Envelope B5", "Envelope C5", "Envelope B6/C4", "Envelope B6", "Envelope C6", "Envelope DL", "Envelope C7/6", "Envelope C7"};
    private static final int[][] convertCentimeterToUnit = new int[][]{{216000, 279400}, {216000, 355600}, {184150, 266700}, {1682000, 2378000}, {1189000, 1682000}, {841000, 1189000}, {594000, 841000}, {420000, 594000}, {297000, 420000}, {210000, 297000}, {148000, 210000}, {105000, 148000}, {74000, 105000}, {52000, 74000}, {37000, 52000}, {26000, 37000}, {1000000, 1414000}, {707000, 1000000}, {500000, 707000}, {353000, 500000}, {250000, 353000}, {176000, 250000}, {125000, 176000}, {88000, 125000}, {62000, 88000}, {44000, 62000}, {31000, 44000}, {917000, 1297000}, {648000, 917000}, {458000, 648000}, {324000, 458000}, {229000, 324000}, {162000, 229000}, {114000, 162000}, {81000, 114000}, {57000, 81000}, {860000, 1220000}, {610000, 860000}, {430000, 610000}, {900000, 1280000}, {640000, 900000}, {450000, 640000}, {324000, 458000}, {250000, 353000}, {229000, 324000}, {176000, 250000}, {162000, 229000}, {125000, 324000}, {125000, 176000}, {114000, 162000}, {110000, 220000}, {81000, 162000}, {81000, 114000}};
    private static final double[] convertInchToPixel = new double[]{0.05, 0.005};
    private static int convertInchToUnit;
    private static int convertPixelToInch;
    private static Dimension convertPixelToUnit;
    private static int convertUnitToPixel;
    protected static int resolution;
    protected static int defRes;

    public static int convertInchToUnit(double d) {
        return (int)Math.round(d * 5760.0);
    }

    public static int convertInchToPixel(double d) {
        return (int)Math.round(d * (double)resolution);
    }

    public static int convertInchToPixel(double d, int n) {
        return (int)Math.round(d * (double)n);
    }

    public static int convertCentimeterToUnit(double d) {
        return (int)Math.round(d * 5760.0 / 2.54);
    }

    public static int convertCentimeterToPixel(double d) {
        return (int)Math.round(d * (double)resolution / 2.54);
    }

    public static int convertCentimeterToPixel(double d, int n) {
        return (int)Math.round(d * (double)n / 2.54);
    }

    public static double convertUnitToInch(int n) {
        return (double)n / 5760.0;
    }

    public static double convertUnitToCentimeter(int n) {
        return (double)n * 2.54 / 5760.0;
    }

    public static double convertPixelToInch(int n) {
        return (double)n / (double)resolution;
    }

    public static double convertPixelToInch(int n, int n2) {
        return (double)n / (double)n2;
    }

    public static double convertPixelToCentimeter(int n) {
        return (double)n * 2.54 / (double)resolution;
    }

    public static double convertPixelToCentimeter(int n, int n2) {
        return (double)n * 2.54 / (double)n2;
    }

    public static int convertPixelToUnit(int n) {
        int n2 = (int)Math.round((double)n * 5760.0 / (double)resolution);
        if (n2 < 0 && n > 0) {
            n2 = Math.abs(n2);
        }
        return n2;
    }

    public static int convertPixelToUnit(int n, int n2) {
        return (int)Math.round((double)n * 5760.0 / (double)n2);
    }

    public static int convertUnitToPixel(int n) {
        return (int)Math.round((double)n * (double)resolution / 5760.0);
    }

    public static int convertUnitToPixel(int n, int n2) {
        return (int)Math.round((double)n * (double)n2 / 5760.0);
    }

    public static void convertUnitToPixel(Rectangle rectangle) {
        rectangle.x = Unit.convertUnitToPixel(rectangle.x);
        rectangle.y = Unit.convertUnitToPixel(rectangle.y);
        rectangle.width = Unit.convertUnitToPixel(rectangle.width);
        rectangle.height = Unit.convertUnitToPixel(rectangle.height);
    }

    public static long convertPixelToUnit(long l) {
        return Math.round((double)l * 5760.0 / (double)resolution);
    }

    public static long convertPixelToUnit(long l, int n) {
        return Math.round((double)l * 5760.0 / (double)n);
    }

    public static long convertUnitToPixel(long l) {
        return Math.round((double)l * (double)resolution / 5760.0);
    }

    public static long convertUnitToPixel(long l, int n) {
        return Math.round((double)l * (double)n / 5760.0);
    }

    public static float convertPixelToUnit(float f) {
        return (float)((double)f * 5760.0 / (double)resolution);
    }

    public static float convertPixelToUnit(float f, int n) {
        return (float)((double)f * 5760.0 / (double)n);
    }

    public static float convertUnitToPixel(float f) {
        return (float)((double)f * (double)resolution / 5760.0);
    }

    public static float convertUnitToPixel(float f, int n) {
        return (float)((double)f * (double)n / 5760.0);
    }

    public static double convertPixelToUnit(double d) {
        return d * 5760.0 / (double)resolution;
    }

    public static double convertPixelToUnit(double d, int n) {
        return d * 5760.0 / (double)n;
    }

    public static double convertUnitToPixel(double d) {
        return d * (double)resolution / 5760.0;
    }

    public static double convertUnitToPixel(double d, int n) {
        return d * (double)n / 5760.0;
    }

    public static int getResolution() {
        return resolution;
    }

    public static int barWidth() {
        return convertInchToUnit;
    }

    public static int barHeight() {
        return convertPixelToInch;
    }

    public static Dimension screenSize() {
        return new Dimension(convertPixelToUnit);
    }

    public static String[] getUnitNames() {
        String[] stringArray = new String[2];
        int n = 1;
        while (n >= 0) {
            stringArray[n] = QOIV[n];
            --n;
        }
        return stringArray;
    }

    public static String getUnitName(int n) {
        if (n >= 0 && n < 2) {
            return QOIV[n];
        }
        return null;
    }

    public static int getUnitType(String string) {
        int n = 1;
        while (n >= 0) {
            if (string.equals(QOIV[n])) {
                return n;
            }
            --n;
        }
        return 0;
    }

    public static String[] getOrientNames() {
        String[] stringArray = new String[2];
        int n = 1;
        while (n >= 0) {
            stringArray[n] = abs[n];
            --n;
        }
        return stringArray;
    }

    public static String getOrientName(int n) {
        if (n >= 0 && n < 2) {
            return abs[n];
        }
        return null;
    }

    public static int getOrientType(String string) {
        int n = 1;
        while (n >= 0) {
            if (string.equals(abs[n])) {
                return n;
            }
            --n;
        }
        return 0;
    }

    public static String[] getPaperNames() {
        String[] stringArray = new String[54];
        int n = 52;
        while (n >= 0) {
            stringArray[n] = convertCentimeterToPixel[n];
            --n;
        }
        stringArray[53] = "Custom size";
        return stringArray;
    }

    public static String getPaperName(int n) {
        if (n >= 0 && n < 53) {
            return convertCentimeterToPixel[n];
        }
        return "Custom size";
    }

    public static int getPaperType(String string) {
        int n = 52;
        while (n >= 0) {
            if (convertCentimeterToPixel[n].equals(string)) {
                return n;
            }
            --n;
        }
        return 53;
    }

    public static int getPaperType(Dimension dimension, int n) {
        if (dimension != null) {
            Unit.getPaperType(dimension.width, dimension.height, n);
        }
        return 53;
    }

    public static int getPaperType(int n, int n2, int n3) {
        return Unit.getPaperType(Unit.convertPixelToInch(n), Unit.convertPixelToInch(n2), n3, 0);
    }

    public static int getPaperType(double d, double d2, int n, int n2) {
        int n3 = 0;
        while (n3 < 53) {
            double d3 = (double)convertCentimeterToUnit[n3][n != 0 ? 1 : 0] / 10000.0;
            double d4 = (double)convertCentimeterToUnit[n3][n != 0 ? 0 : 1] / 10000.0;
            double d5 = convertInchToPixel[n2];
            double d6 = n2 != 0 ? d3 : d3 / 2.54;
            if (Math.abs(d - d6) < d5) {
                double d7 = n2 != 0 ? d4 : d4 / 2.54;
                if (Math.abs(d2 - d7) < d5) {
                    return n3;
                }
            }
            ++n3;
        }
        return 53;
    }

    public static Dimension getPaperSize(int n, int n2) {
        if (n >= 0 && n < 53) {
            return new Dimension(convertCentimeterToUnit[n][n2 != 0 ? 1 : 0], convertCentimeterToUnit[n][n2 != 0 ? 0 : 1]);
        }
        return null;
    }

    public static Dimension getPixelPaperSize(int n, int n2) {
        if (n >= 0 && n < 53) {
            return new Dimension(Unit.convertCentimeterToPixel((double)convertCentimeterToUnit[n][n2 != 0 ? 1 : 0] / 10000.0), Unit.convertCentimeterToPixel((double)convertCentimeterToUnit[n][n2 != 0 ? 0 : 1] / 10000.0));
        }
        return null;
    }

    public static Dimension getUnitPaperSize(int n, int n2) {
        if (n >= 0 && n < 53) {
            return new Dimension(Unit.convertCentimeterToUnit((double)convertCentimeterToUnit[n][n2 != 0 ? 1 : 0] / 10000.0), Unit.convertCentimeterToUnit((double)convertCentimeterToUnit[n][n2 != 0 ? 0 : 1] / 10000.0));
        }
        return null;
    }

    public static int currentConnect() {
        return convertUnitToPixel;
    }

    public static void connectToScreen() {
        if (convertUnitToPixel != 0) {
            convertUnitToPixel = 0;
            resolution = defRes == -1 ? Toolkit.getDefaultToolkit().getScreenResolution() : defRes;
        }
    }

    public static void setResolution(int n) {
        if (defRes == -1) {
            defRes = n;
        }
        resolution = defRes == -1 ? Toolkit.getDefaultToolkit().getScreenResolution() : defRes;
    }

    public static void connectToPrinter(int n) {
        if (convertUnitToPixel != 1) {
            convertUnitToPixel = 1;
            resolution = n;
        }
    }

    public static int convertToScreen(int n, int n2) {
        double d = Unit.convertPixelToInch(n, n2);
        return Unit.convertInchToPixel(d, resolution);
    }

    public static int convertTwoRes(int n, int n2, int n3) {
        double d = Unit.convertPixelToInch(n, n2);
        return Unit.convertInchToPixel(d, n3);
    }

    public static int upgrade(int n, int n2, boolean bl) {
        if (n2 < 65539) {
            if (bl) {
                return Unit.convertPixelToUnit(n);
            }
            if (n2 <= 65537) {
                return (int)Math.round((double)n * 5760.0 / 120.0);
            }
            if (n2 <= 65540) {
                return (int)Math.round((double)n * 5760.0 / 65535.0);
            }
        } else if (n2 <= 65540) {
            return (int)Math.round((double)n * 5760.0 / 65535.0);
        }
        return n;
    }

    static {
        convertUnitToPixel = 0;
        defRes = -1;
        try {
            try {
                String string = System.getProperty("resolution");
                if (string != null && string.length() > 0) {
                    defRes = resolution = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resolution < 72) {
                resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            convertPixelToUnit = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (Throwable throwable) {
            resolution = defRes > 0 ? defRes : 72;
            convertPixelToUnit = new Dimension(1280, 1024);
        }
        convertPixelToInch = convertInchToUnit = Unit.convertInchToUnit(0.141664759) * resolution / 5760;
    }
}

