/*
 * Decompiled with CFR 0.152.
 */
package jet.ie;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import jet.util.Base64;

public class ChartTextProConverter {
    public static final short INTEGER = 1;
    public static final short LONG = 2;
    public static final short FLOAT = 3;
    public static final short DOUBLE = 4;
    public static final short BOOLEAN = 5;
    public static final short STRING = 6;
    public static final short SUBMAP = 7;
    public static final short SUBLIST = 8;
    public static final short NULLVALUE = 9;
    public static final short TIMESTAMP = 10;
    public static final short BIGDECIMAL = 11;
    public static final short BIGINTEGER = 12;
    public static final short SQLDATE = 13;
    public static final short UTILDATE = 14;
    public static final short SQLTIME = 15;
    private String QOIV;

    public ChartTextProConverter(String string) {
        this.QOIV = string;
    }

    public Map convert() throws IOException {
        DataInputStream dataInputStream;
        Object object;
        byte[] byArray = Base64.decode(this.QOIV.getBytes());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (byArray[0] == 80 && byArray[1] == 75) {
            object = new ZipInputStream(byteArrayInputStream);
            ((ZipInputStream)object).getNextEntry();
            dataInputStream = new DataInputStream((InputStream)object);
        } else {
            dataInputStream = new DataInputStream(byteArrayInputStream);
        }
        object = this.QOIV(dataInputStream);
        dataInputStream.close();
        return object;
    }

    private Map QOIV(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = dataInput.readUTF();
            Object object = null;
            short s = dataInput.readShort();
            switch (s) {
                case 1: {
                    object = new Integer(dataInput.readInt());
                    break;
                }
                case 2: {
                    object = new Long(dataInput.readLong());
                    break;
                }
                case 3: {
                    object = new Float(dataInput.readFloat());
                    break;
                }
                case 4: {
                    object = new Double(dataInput.readDouble());
                    break;
                }
                case 5: {
                    object = new Boolean(dataInput.readBoolean());
                    break;
                }
                case 6: {
                    object = dataInput.readUTF();
                    break;
                }
                case 12: {
                    object = new BigInteger(dataInput.readUTF());
                    break;
                }
                case 11: {
                    object = new BigDecimal(dataInput.readUTF());
                    break;
                }
                case 7: {
                    object = this.QOIV(dataInput);
                    break;
                }
                case 8: {
                    object = this.add(dataInput);
                    break;
                }
                case 9: {
                    object = null;
                    break;
                }
                case 10: {
                    object = new Timestamp(dataInput.readLong());
                    break;
                }
                case 13: {
                    object = new Date(dataInput.readLong());
                    break;
                }
                case 14: {
                    object = new java.util.Date(dataInput.readLong());
                    break;
                }
                case 15: {
                    object = new Time(dataInput.readLong());
                    break;
                }
                default: {
                    throw new IOException("Unknow properties type:" + s);
                }
            }
            hashMap.put(string, object);
            ++n2;
        }
        return hashMap;
    }

    private List add(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = null;
            short s = dataInput.readShort();
            switch (s) {
                case 1: {
                    object = new Integer(dataInput.readInt());
                    break;
                }
                case 2: {
                    object = new Long(dataInput.readLong());
                    break;
                }
                case 3: {
                    object = new Float(dataInput.readFloat());
                    break;
                }
                case 4: {
                    object = new Double(dataInput.readDouble());
                    break;
                }
                case 5: {
                    object = new Boolean(dataInput.readBoolean());
                    break;
                }
                case 6: {
                    object = dataInput.readUTF();
                    break;
                }
                case 7: {
                    object = this.QOIV(dataInput);
                    break;
                }
                case 8: {
                    object = this.add(dataInput);
                    break;
                }
                case 11: {
                    object = new BigDecimal(dataInput.readUTF());
                    break;
                }
                case 12: {
                    object = new BigInteger(dataInput.readUTF());
                    break;
                }
                case 9: {
                    object = null;
                    break;
                }
                case 10: {
                    object = new Timestamp(dataInput.readLong());
                    break;
                }
                case 13: {
                    object = new Date(dataInput.readLong());
                    break;
                }
                case 14: {
                    object = new java.util.Date(dataInput.readLong());
                    break;
                }
                case 15: {
                    object = new Time(dataInput.readLong());
                    break;
                }
                default: {
                    throw new IOException("Unknow properties type:" + s);
                }
            }
            arrayList.add(object);
            ++n2;
        }
        return arrayList;
    }
}

