/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartLabelBase;
import chart.ChartObject;
import chart.graphics.ChartIcon;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartLabelProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ChartLabel
extends ChartComponent {
    private ChartLabelBase QOIV;
    public static final int LEFT_TOP = 0;
    public static final int LEFT_CENTER = 1;
    public static final int LEFT_BOTTOM = 2;
    public static final int CENTER_TOP = 3;
    public static final int CENTER_CENTER = 4;
    public static final int CENTER_BOTTOM = 5;
    public static final int RIGHT_TOP = 6;
    public static final int RIGHT_CENTER = 7;
    public static final int RIGHT_BOTTOM = 8;
    private int contains = -1;
    private boolean getBackground = true;
    private float getBottomMargin;
    private float getBounds;
    public static final int CUSTOMIZED_TITLE = 0;
    public static final int CHART_TITLE = 1;
    public static final int AXIS_X_TITLE = 2;
    public static final int AXIS_Y_TITLE = 3;
    public static final int AXIS_Y2_TITLE = 4;
    private int getCoreArea = 0;
    private int getIcon = -1;

    public ChartLabel() {
        this.QOIV = new ChartLabelBase(new ChartLabelProperties());
    }

    public ChartLabel(ChartLabelProperties chartLabelProperties) {
        this.getCoreArea = chartLabelProperties.getTitleType();
        this.QOIV = new ChartLabelBase(chartLabelProperties);
    }

    public ChartLabel(String string) {
        ChartLabelProperties chartLabelProperties = new ChartLabelProperties();
        chartLabelProperties.setText(string);
        this.QOIV = new ChartLabelBase(chartLabelProperties);
    }

    public void doLayout() {
    }

    public void init() {
    }

    public void locate() {
        ChartLabelProperties chartLabelProperties = this.QOIV.getLabelBaseProperties();
        if (chartLabelProperties.getTextStyle().getWordWrapper()) {
            if (chartLabelProperties.getIcon() != null) {
                if (chartLabelProperties.getIcon().isNoIcon()) {
                    chartLabelProperties.getTextStyle().setWordWrap((float)this.getCoreArea().getBounds().getWidth());
                } else {
                    chartLabelProperties.getTextStyle().setWordWrap((float)(this.getCoreArea().getBounds().getWidth() - (double)chartLabelProperties.getIcon().getIconWidth() - (double)chartLabelProperties.getIconTextGap()));
                }
            } else {
                chartLabelProperties.getTextStyle().setWordWrap((float)this.getCoreArea().getBounds().getWidth());
            }
        }
        this.QOIV.setLabelBaseProperties(chartLabelProperties);
        this.QOIV.locate();
        Rectangle rectangle = this.getCoreArea();
        Dimension dimension = this.QOIV.getLabelBaseDimension();
        float f = dimension.width;
        float f2 = dimension.height;
        float f3 = (float)rectangle.width - f;
        float f4 = (float)rectangle.height - f2;
        this.getBottomMargin = 0.0f;
        this.getBounds = 0.0f;
        f3 = f3 < 0.0f ? 0.0f : f3;
        f4 = f4 < 0.0f ? 0.0f : f4;
        float f5 = chartLabelProperties.getLeftMargin();
        float f6 = chartLabelProperties.getTopMargin();
        float f7 = chartLabelProperties.getBottomMargin();
        float f8 = chartLabelProperties.getRightMargin();
        switch (chartLabelProperties.getTextAlignment()) {
            case 0: {
                this.getBottomMargin = (float)rectangle.x + f5;
                this.getBounds = (float)rectangle.y + f6;
                break;
            }
            case 3: {
                this.getBottomMargin = (float)rectangle.x + f3 / 2.0f;
                this.getBounds = (float)rectangle.y + f6;
                break;
            }
            case 6: {
                this.getBottomMargin = (float)rectangle.x + f3 - f8;
                this.getBounds = (float)rectangle.y + f6;
                break;
            }
            case 1: {
                this.getBottomMargin = (float)rectangle.x + f5;
                this.getBounds = (float)rectangle.y + f4 / 2.0f;
                break;
            }
            case 4: {
                this.getBottomMargin = (float)rectangle.x + f3 / 2.0f;
                this.getBounds = (float)rectangle.y + f4 / 2.0f;
                break;
            }
            case 7: {
                this.getBottomMargin = (float)rectangle.x + f3 - f8;
                this.getBounds = (float)rectangle.y + f4 / 2.0f;
                break;
            }
            case 2: {
                this.getBottomMargin = (float)rectangle.x + f5;
                this.getBounds = (float)rectangle.y + f4 - f7;
                break;
            }
            case 5: {
                this.getBottomMargin = (float)rectangle.x + f3 / 2.0f;
                this.getBounds = (float)rectangle.y + f4 - f7;
                break;
            }
            case 8: {
                this.getBottomMargin = (float)rectangle.x + f3 - f8;
                this.getBounds = (float)rectangle.y + f4 - f7;
                break;
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        this.background = this.getProperties().getBackground();
        super.paint(graphics2D);
        this.QOIV.paint(graphics2D, this.getBottomMargin, this.getBounds);
        super.paintBorder(graphics2D);
    }

    public float getIconTextGap() {
        return this.QOIV.getLabelBaseProperties().getIconTextGap();
    }

    public void setIconTextGap(int n) {
        this.QOIV.getLabelBaseProperties().setIconTextGap(n);
    }

    public int getIconWidth() {
        return this.QOIV.getLabelBaseProperties().getIcon().getIconWidth();
    }

    public int getIconHeight() {
        return this.QOIV.getLabelBaseProperties().getIcon().getIconHeight();
    }

    public int getIconStyle() {
        return this.QOIV.getLabelBaseProperties().getIcon().getIconStyle();
    }

    public void setIconStyle(int n) {
        this.QOIV.getLabelBaseProperties().getIcon().setIconStyle(n);
    }

    public void setIconWidth(int n) {
        this.QOIV.getLabelBaseProperties().getIcon().setIconWidth(n);
    }

    public void setIconHeight(int n) {
        this.QOIV.getLabelBaseProperties().getIcon().setIconHeight(n);
    }

    public ChartIcon getIcon() {
        return this.QOIV.getLabelBaseProperties().getIcon();
    }

    public void setIcon(ChartIcon chartIcon) {
        this.QOIV.getLabelBaseProperties().setIcon(chartIcon);
    }

    public int getTextAlignment() {
        return this.QOIV.getLabelBaseProperties().getTextAlignment();
    }

    public void setTextAlignment(int n) {
        this.QOIV.getLabelBaseProperties().setTextAlignment(n);
    }

    public int getIconAlignment() {
        return this.QOIV.getLabelBaseProperties().getIconAlignment();
    }

    public void setIconAlignment(int n) {
        this.QOIV.getLabelBaseProperties().setIconAlignment(n);
    }

    public void setChartTextStyle(ChartTextStyle chartTextStyle) {
        this.QOIV.getLabelBaseProperties().setTextStyle(chartTextStyle);
    }

    public ChartTextStyle getChartTextStyle() {
        return this.QOIV.getLabelBaseProperties().getTextStyle();
    }

    public void setText(String string) {
        this.QOIV.setLabelText(string);
    }

    public String getText() {
        return this.QOIV.getLabelText();
    }

    public void setFont(Font font) {
        if (this.QOIV.getLabelBaseProperties().getTextStyle() != null) {
            this.QOIV.getLabelBaseProperties().getTextStyle().setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.QOIV.getLabelBaseProperties().getTextStyle() != null) {
            this.QOIV.getLabelBaseProperties().getTextStyle().setForeground(color);
        }
    }

    public int getLegendIndex() {
        return this.contains;
    }

    public void setLegendIndex(int n) {
        this.contains = n;
    }

    public boolean getApplyAll() {
        return this.getBackground;
    }

    public void setApplyAll(boolean bl) {
        this.getBackground = bl;
    }

    public ChartLabelProperties getProperties() {
        return this.QOIV.getLabelBaseProperties();
    }

    public void setProperties(ChartLabelProperties chartLabelProperties) {
        this.QOIV.setLabelBaseProperties(chartLabelProperties);
    }

    public ChartObject getChartObject(int n, int n2) {
        return this;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public int getTitleType() {
        return this.getCoreArea;
    }

    public void setTitleType(int n) {
        this.getCoreArea = n;
    }

    public void setID(int n) {
        this.getIcon = n;
    }

    public int getID() {
        return this.getIcon;
    }
}

