/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.css.util;

import com.jinfonet.css.util.CharsetValidate;
import com.jinfonet.dom.css.impl.JCSSCharsetRuleImpl;
import com.jinfonet.dom.css.impl.JCSSImportRuleImpl;
import com.jinfonet.dom.css.impl.JCSSMediaRuleImpl;
import com.jinfonet.dom.css.impl.JCSSPageRuleImpl;
import com.jinfonet.dom.css.impl.JCSSRuleListImpl;
import com.jinfonet.dom.css.impl.JCSSStyleRuleImpl;
import com.jinfonet.dom.css.impl.JCSSStyleSheetImpl;
import com.jinfonet.dom.css.impl.JMediaListImpl;
import com.jinfonet.util.JRLog;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class W3CStyleSheetConvert {
    public CSSStyleSheet convertW3CStyleSheet(CSSStyleSheet cSSStyleSheet) {
        JCSSStyleSheetImpl jCSSStyleSheetImpl = new JCSSStyleSheetImpl();
        JCSSRuleListImpl jCSSRuleListImpl = new JCSSRuleListImpl();
        CSSRule cSSRule = null;
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        int n = cSSRuleList.getLength();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            CSSRule cSSRule2 = cSSRuleList.item(n2);
            short s = cSSRule2.getType();
            switch (s) {
                case 2: {
                    if (bl) {
                        JRLog.error(2, 2205014, cSSRule2);
                        break;
                    }
                    jCSSRuleListImpl.add(this.convertCharsetRule((CSSCharsetRule)cSSRule2));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    if (bl2) {
                        JRLog.error(2, 2205015, cSSRule2);
                        break;
                    }
                    CSSRuleList cSSRuleList2 = this.convertImportRule((CSSImportRule)cSSRule2);
                    int n3 = cSSRuleList2.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        jCSSRuleListImpl.add(cSSRuleList2.item(n4));
                        ++n4;
                    }
                    break;
                }
                case 4: {
                    cSSRule = this.convertMediaRule((CSSMediaRule)cSSRule2);
                    if (cSSRule != null) {
                        jCSSRuleListImpl.add(cSSRule);
                    }
                    bl = true;
                    bl2 = true;
                    break;
                }
                case 6: {
                    cSSRule = this.convertPageRule((CSSPageRule)cSSRule2);
                    if (cSSRule != null) {
                        jCSSRuleListImpl.add(cSSRule);
                    }
                    bl = true;
                    bl2 = true;
                    break;
                }
                case 1: {
                    cSSRule = this.convertStyleRule((CSSStyleRule)cSSRule2);
                    if (cSSRule == null) break;
                    jCSSRuleListImpl.add(cSSRule);
                    break;
                }
                default: {
                    JRLog.error(2, 2205016, "" + s);
                }
            }
            ++n2;
        }
        jCSSStyleSheetImpl.setRuleList(jCSSRuleListImpl);
        return jCSSStyleSheetImpl;
    }

    public CSSRule convertCharsetRule(CSSCharsetRule cSSCharsetRule) {
        String string = cSSCharsetRule.getEncoding();
        if (CharsetValidate.isSupportCharset(string)) {
            return new JCSSCharsetRuleImpl(null, null, string);
        }
        JRLog.error(3, 3205018, new String[]{string, CharsetValidate.getDefaultCharset()});
        return new JCSSCharsetRuleImpl(null, null, CharsetValidate.getDefaultCharset());
    }

    public CSSRuleList convertImportRule(CSSImportRule cSSImportRule) {
        String string = cSSImportRule.getHref();
        MediaList mediaList = cSSImportRule.getMedia();
        JMediaListImpl jMediaListImpl = new JMediaListImpl();
        int n = 1;
        while (n < mediaList.getLength()) {
            jMediaListImpl.addMedium(mediaList.item(n));
            ++n;
        }
        JCSSImportRuleImpl jCSSImportRuleImpl = new JCSSImportRuleImpl(null, null, string, jMediaListImpl);
        return jCSSImportRuleImpl.getStyleSheet().getCssRules();
    }

    public CSSRule convertMediaRule(CSSMediaRule cSSMediaRule) {
        String string = cSSMediaRule.getCssText();
        JCSSMediaRuleImpl jCSSMediaRuleImpl = new JCSSMediaRuleImpl();
        jCSSMediaRuleImpl.setCssText(string);
        return jCSSMediaRuleImpl;
    }

    public CSSRule convertPageRule(CSSPageRule cSSPageRule) {
        JCSSPageRuleImpl jCSSPageRuleImpl = new JCSSPageRuleImpl();
        jCSSPageRuleImpl.setCssText(cSSPageRule.getCssText());
        return jCSSPageRuleImpl;
    }

    public CSSRule convertStyleRule(CSSStyleRule cSSStyleRule) {
        String string = cSSStyleRule.getCssText();
        JCSSStyleRuleImpl jCSSStyleRuleImpl = new JCSSStyleRuleImpl();
        jCSSStyleRuleImpl.setCssText(string);
        return jCSSStyleRuleImpl;
    }
}

