/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.relational.localrelation.index.sorted;

import com.jinfonet.dataservice.relational.localrelation.index.LocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.page.LocalTreeMap;
import com.jinfonet.dataservice.relational.localrelation.index.page.MemoryPage;
import com.jinfonet.dataservice.relational.localrelation.index.page.RowIDChain;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.BigDecimalLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.DoubleLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.FloatLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.IntLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.LongLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.index.sorted.StringLocalIndex;
import com.jinfonet.dataservice.relational.localrelation.util.IntArrayList;
import com.jinfonet.dataservice.relational.localrelation.util.LRelationShip;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;

public abstract class SortedLocalIndex
extends LocalIndex {
    protected String name;
    protected LinkedList pageTable;
    protected IntArrayList nullManager;
    protected IndexState currState;
    protected int nullStrategy;
    protected int dataType;
    private final DSLog QOIV = DSLog.getDSLog(this.getClass().getName());

    protected SortedLocalIndex(String string, int n, int n2) {
        this.dataType = n2;
        this.nullStrategy = n;
        this.name = string;
        this.pageTable = new LinkedList();
        this.nullManager = new IntArrayList(1000);
        this.currState = new IndexState(this, true);
        if (n == 1) {
            this.currState.setNullStrategy(false);
        }
    }

    protected abstract void newPage();

    public int getPageSize() {
        return this.pageTable.size();
    }

    public static SortedLocalIndex getInstance(String string, int n, int n2) throws DSException {
        switch (n) {
            case -6: 
            case 4: 
            case 5: {
                return new IntLocalIndex(string, n2, n);
            }
            case -5: 
            case 91: 
            case 92: 
            case 93: {
                return new LongLocalIndex(string, n2, n);
            }
            case 6: {
                return new FloatLocalIndex(string, n2, n);
            }
            case 8: {
                return new DoubleLocalIndex(string, n2, n);
            }
            case 12: {
                return new StringLocalIndex(string, n2, n);
            }
            case 3: {
                return new BigDecimalLocalIndex(string, n2, n);
            }
        }
        throw new UnsupportedOperationException("collumn: " + string + " not support data type to indexing: " + n);
    }

    public void put(Object object, int n) throws DSException {
        MemoryPage memoryPage;
        if (this.pageTable.size() < 1) {
            this.newPage();
        }
        if (this.currState.getPage().compareTo(object) == 0) {
            this.currState.getPage().put(object, n);
            this.currState.getPage().setTimestamp(System.currentTimeMillis());
        } else {
            memoryPage = this.binarySearch(object, 0, this.pageTable.size() - 1);
            if (!memoryPage.isInMemory()) {
                this.findInMemoryOldestPage().swapToDisk();
                memoryPage.swapToMemory();
            }
            this.currState.I(memoryPage);
            this.currState.getPage().put(object, n);
            this.currState.getPage().setTimestamp(System.currentTimeMillis());
        }
        if (this.currState.getPage().canSplit()) {
            if (this.pageTable.size() >= 30) {
                this.findInMemoryOldestPage().swapToDisk();
            }
            memoryPage = this.currState.getPage().splitPage();
            int n2 = this.pageTable.indexOf(this.currState.getPage());
            this.pageTable.add(n2 + 1, memoryPage);
        }
    }

    protected MemoryPage binarySearch(Object object, int n, int n2) {
        int n3;
        int n4;
        MemoryPage memoryPage = this.access$000(n);
        MemoryPage memoryPage2 = this.QOIV(n2);
        while ((n4 = this.pageTable.indexOf(memoryPage)) <= (n3 = this.pageTable.indexOf(memoryPage2))) {
            int n5 = n4 + n3 >> 1;
            Object e = this.pageTable.get(n5);
            int n6 = ((Comparable)e).compareTo(object);
            if (n6 > 0) {
                memoryPage = (MemoryPage)this.pageTable.get(n5 + 1);
                continue;
            }
            if (n6 < 0) {
                memoryPage2 = (MemoryPage)this.pageTable.get(n5 - 1);
                continue;
            }
            return (MemoryPage)this.pageTable.get(n5);
        }
        return null;
    }

    private MemoryPage QOIV(int n) {
        if (this.currState.equals(this.pageTable.get(n))) {
            return (MemoryPage)this.pageTable.get(n - 1);
        }
        return (MemoryPage)this.pageTable.get(n);
    }

    private MemoryPage access$000(int n) {
        if (this.currState.equals(this.pageTable.get(n))) {
            return (MemoryPage)this.pageTable.get(n + 1);
        }
        return (MemoryPage)this.pageTable.get(n);
    }

    protected MemoryPage findInMemoryOldestPage() {
        MemoryPage memoryPage = null;
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < this.pageTable.size()) {
            MemoryPage memoryPage2 = (MemoryPage)this.pageTable.get(n);
            if (memoryPage2.isInMemory() && memoryPage2.getTimestamp() <= l) {
                l = memoryPage2.getTimestamp();
                memoryPage = memoryPage2;
            }
            ++n;
        }
        return memoryPage;
    }

    public void putNull(int n) {
        this.nullManager.add(n);
    }

    public boolean next() throws DSException {
        if (this.currState.getNullStrategy() && this.currState.getNullPointer() < this.nullManager.size()) {
            this.currState.setNullIndex();
            return true;
        }
        if (!this.currState.Z()) {
            this.binarySearch(10);
        }
        if (!this.currState.C()) {
            this.currState.I(0);
            this.currState.D();
            this.currState.initEntryPointer();
            this.currState.getPage().setTimestamp(System.currentTimeMillis());
            return true;
        }
        if (!this.currState.entryFinish()) {
            this.currState.setNextRowID();
            this.currState.getPage().setTimestamp(System.currentTimeMillis());
            return true;
        }
        if (this.currState.B().hasNext()) {
            this.currState.initEntryPointer();
            this.currState.getPage().setTimestamp(System.currentTimeMillis());
            return true;
        }
        if (this.currState.I() < this.pageTable.size() - 1) {
            int n = this.currState.I() + 1;
            MemoryPage memoryPage = (MemoryPage)this.pageTable.get(n);
            memoryPage.setTimestamp(System.currentTimeMillis());
            if (!memoryPage.isInMemory()) {
                this.findInMemoryOldestPage().swapToDisk();
                memoryPage.swapToMemory();
            }
            this.currState.I(memoryPage);
            this.currState.I(n);
            this.currState.D();
            this.currState.initEntryPointer();
            return true;
        }
        return false;
    }

    public Object getValue() {
        if (this.currState.getNullStrategy()) {
            return null;
        }
        return this.currState.getKey();
    }

    public int getPosition() {
        if (this.currState.getNullStrategy()) {
            return this.nullManager.get(this.currState.getNullPointer());
        }
        return this.currState.getPosition();
    }

    public boolean find(Object object, int n) throws DSException {
        MemoryPage memoryPage = this.append(object);
        if (LRelationShip.isAllEquals(n)) {
            this.add(memoryPage);
            this.currState.I(memoryPage);
            this.currState.I(this.pageTable.indexOf(memoryPage));
            LocalTreeMap.Entry entry = (LocalTreeMap.Entry)memoryPage.find(object);
            if (entry == null) {
                return false;
            }
            this.currState.setEntry(entry);
            return true;
        }
        if (!this.currState.hasIterator(object)) {
            int n2 = this.pageTable.indexOf(memoryPage);
            HashSet hashSet = new HashSet();
            if (LRelationShip.isAllNoMoreThan(n) || LRelationShip.isAllLessThan(n)) {
                int n3 = n2;
                while (n3 < this.pageTable.size()) {
                    hashSet.add(this.pageTable.get(n3));
                    ++n3;
                }
                if (LRelationShip.isAllNoMoreThan(n)) {
                    this.currState.setTailerIterator(hashSet, n2, object, true);
                } else {
                    this.currState.setTailerIterator(hashSet, n2, object, false);
                }
            } else if (LRelationShip.isAllNoLessThan(n) || LRelationShip.isAllMoreThan(n)) {
                int n4 = 0;
                while (n4 < n2 + 1) {
                    hashSet.add(this.pageTable.get(n4));
                    ++n4;
                }
                if (LRelationShip.isAllNoLessThan(n)) {
                    this.currState.setHeaderIterator(hashSet, n2, object, true);
                } else {
                    this.currState.setHeaderIterator(hashSet, n2, object, false);
                }
            } else if (LRelationShip.isAllNotEquals(n)) {
                int n5 = 0;
                while (n5 < this.pageTable.size()) {
                    hashSet.add(this.pageTable.get(n5));
                    ++n5;
                }
                this.currState.setAllIterator(hashSet, n2, object);
            } else {
                throw new IllegalStateException("unknown join condition: " + n);
            }
            return IndexState.access$000(this.currState) != null;
        }
        return this.currState.hasNext();
    }

    private void add(MemoryPage memoryPage) throws DSException {
        if (!memoryPage.isInMemory()) {
            this.findInMemoryOldestPage().swapToDisk();
            memoryPage.swapToMemory();
            memoryPage.setTimestamp(System.currentTimeMillis());
        }
    }

    private MemoryPage append(Object object) {
        int n = this.currState.getPage().compareTo(object);
        MemoryPage memoryPage = n == 0 ? this.currState.getPage() : (n < 0 ? this.binarySearch(object, 0, this.pageTable.indexOf(this.currState.getPage()) - 1) : this.binarySearch(object, this.pageTable.indexOf(this.currState.getPage()) + 1, this.pageTable.size() - 1));
        return memoryPage;
    }

    public RowIDChain getPositions() {
        if (this.currState.getNullStrategy()) {
            return new RowIDChain(this.nullManager);
        }
        return this.currState.getPositions();
    }

    private void binarySearch(int n) throws DSException {
        if (this.pageTable.indexOf(this.currState.getPage()) != 0) {
            if (this.canSplit()) {
                int n2 = 0;
                while (n2 < n) {
                    if (!((MemoryPage)this.pageTable.get(n2)).isInMemory()) {
                        MemoryPage memoryPage = this.findInMemoryOldestPage();
                        int n3 = this.pageTable.indexOf(memoryPage);
                        while (n3 >= 0 || n3 <= n - 1) {
                            memoryPage.setTimestamp(System.currentTimeMillis());
                            memoryPage = this.findInMemoryOldestPage();
                            n3 = this.pageTable.indexOf(memoryPage);
                        }
                        memoryPage.swapToDisk();
                        ((MemoryPage)this.pageTable.get(n2)).swapToMemory();
                        ((MemoryPage)this.pageTable.get(n2)).setTimestamp(System.currentTimeMillis());
                    }
                    ++n2;
                }
            }
            this.currState.I((MemoryPage)this.pageTable.getFirst());
            this.currState.I(0);
            this.currState.getPage().setTimestamp(System.currentTimeMillis());
            this.currState.I(true);
        }
    }

    private boolean canSplit() {
        return this.pageTable.size() >= 30;
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.pageTable.iterator();
        while (iterator.hasNext()) {
            n += ((MemoryPage)iterator.next()).size();
        }
        return n;
    }

    public void clear() {
        int n = 0;
        while (n < this.pageTable.size()) {
            ((MemoryPage)this.pageTable.get(n)).clear();
            ++n;
        }
        Iterator iterator = this.pageTable.iterator();
        while (iterator.hasNext()) {
            ((MemoryPage)iterator.next()).clear();
        }
        this.currState.clear();
        this.nullManager.clear();
        this.pageTable.clear();
    }

    public void beforeFirst() throws DSException {
        this.binarySearch(5);
    }

    public boolean hasNull() {
        return this.nullManager.size() > 0;
    }

    static DSLog access$100(SortedLocalIndex sortedLocalIndex) {
        return sortedLocalIndex.QOIV;
    }

    protected class IndexState {
        private AllEntryIterator QOIV;
        private RowIDChain equals;
        private RowIDChain getIterator;
        private boolean getKey;
        private boolean getNext;
        private int getValue;
        private int hasNext;
        private MemoryPage next;
        private Iterator nullManager;
        private LocalTreeMap.Entry size;
        private final SortedLocalIndex this$0;

        IndexState(SortedLocalIndex sortedLocalIndex, boolean bl) {
            this.this$0 = sortedLocalIndex;
            this.getKey = bl;
            this.getNext = true;
            this.hasNext = -1;
        }

        public boolean hasNext() {
            if (this.QOIV.hasNext()) {
                this.size = (LocalTreeMap.Entry)this.QOIV.next();
                return true;
            }
            return false;
        }

        public boolean hasIterator(Object object) {
            return this.QOIV != null && this.QOIV.getKey().equals(object);
        }

        public void setHeaderIterator(Set set, int n, Object object, boolean bl) throws DSException {
            this.QOIV = new AllEntryIterator(this.this$0, set, n, object, true, bl);
            this.size = (LocalTreeMap.Entry)this.QOIV.next();
        }

        public void setTailerIterator(Set set, int n, Object object, boolean bl) throws DSException {
            this.QOIV = new AllEntryIterator(this.this$0, set, n, object, false, bl);
            this.size = (LocalTreeMap.Entry)this.QOIV.next();
        }

        public void setAllIterator(Set set, int n, Object object) throws DSException {
            this.QOIV = new AllEntryIterator(this.this$0, set, n, object);
            this.size = (LocalTreeMap.Entry)this.QOIV.next();
        }

        protected void clear() {
            this.equals = null;
            this.getIterator = null;
            this.getKey = true;
            this.getValue = -1;
            this.hasNext = -1;
            this.next = null;
            this.nullManager = null;
            this.size = null;
        }

        public void setEntry(LocalTreeMap.Entry entry) {
            this.size = entry;
            this.equals = this.getIterator = (RowIDChain)entry.getValue();
        }

        public RowIDChain getPositions() {
            return (RowIDChain)this.size.getValue();
        }

        public int getPosition() {
            return this.equals.getValue();
        }

        public Object getKey() {
            return this.size.getKey();
        }

        public void setNextRowID() {
            this.equals = this.getIterator;
        }

        public boolean entryFinish() {
            this.getIterator = this.getIterator.getNext();
            return this.getIterator == null;
        }

        public void initEntryPointer() {
            this.size = (LocalTreeMap.Entry)this.nullManager.next();
            this.equals = this.getIterator = (RowIDChain)this.size.getValue();
        }

        public void setNullIndex() {
            ++this.hasNext;
            if (this.hasNext >= this.this$0.nullManager.size() - 1) {
                this.getNext = false;
            }
        }

        public int getNullPointer() {
            return this.hasNext;
        }

        public boolean getNullStrategy() {
            return this.getNext;
        }

        public void setNullStrategy(boolean bl) {
            this.getNext = bl;
        }

        MemoryPage getPage() {
            return this.next;
        }

        int I() {
            return this.getValue;
        }

        void I(MemoryPage memoryPage) {
            this.next = memoryPage;
        }

        void I(int n) {
            this.getValue = n;
        }

        boolean Z() {
            return this.getKey;
        }

        void I(boolean bl) {
            this.getKey = bl;
        }

        boolean C() {
            return this.nullManager != null;
        }

        Iterator B() {
            return this.nullManager;
        }

        void D() {
            this.nullManager = this.next.getIterator();
        }

        static LocalTreeMap.Entry access$000(IndexState indexState) {
            return indexState.size;
        }
    }

    private class AllEntryIterator
    implements Iterator {
        private Iterator QOIV;
        private Iterator access$100;
        private int compareTo;
        private int currentTimeMillis;
        private boolean debug;
        private boolean findInMemoryOldestPage;
        private boolean get;
        private Object getIterator;
        private Object getKey;
        private final SortedLocalIndex this$0;

        public AllEntryIterator(SortedLocalIndex sortedLocalIndex, Set set, int n, Object object) throws DSException {
            this.this$0 = sortedLocalIndex;
            this.get = true;
            this.QOIV = set.iterator();
            this.currentTimeMillis = 0;
            this.compareTo = set.size() - 1;
            this.getIterator = object;
            this.debug = false;
            this.findInMemoryOldestPage = true;
            this.access$100 = this.QOIV().getIterator();
            LocalTreeMap.Entry entry = null;
            boolean bl = false;
            while (this.access$100.hasNext()) {
                entry = (LocalTreeMap.Entry)this.access$100.next();
                if (this.compareTo((Comparable)entry.getKey(), object) == 0) continue;
                bl = true;
                break;
            }
            this.getKey = bl ? entry : null;
        }

        public AllEntryIterator(SortedLocalIndex sortedLocalIndex, Set set, int n, Object object, boolean bl, boolean bl2) throws DSException {
            this.this$0 = sortedLocalIndex;
            this.get = false;
            this.QOIV = set.iterator();
            this.getIterator = object;
            this.debug = bl2;
            this.findInMemoryOldestPage = bl;
            MemoryPage memoryPage = this.QOIV();
            this.access$100 = memoryPage.getIterator();
            LocalTreeMap.Entry entry = null;
            boolean bl3 = false;
            if (bl) {
                this.compareTo = n;
                this.currentTimeMillis = 0;
                if (this.access$100.hasNext()) {
                    entry = (LocalTreeMap.Entry)this.access$100.next();
                    if (bl2) {
                        if (this.compareTo((Comparable)entry.getKey(), object) <= 0) {
                            bl3 = true;
                        }
                    } else if (this.compareTo((Comparable)entry.getKey(), object) < 0) {
                        bl3 = true;
                    }
                }
            } else {
                this.compareTo = sortedLocalIndex.pageTable.size() - 1;
                while (this.access$100.hasNext()) {
                    entry = (LocalTreeMap.Entry)this.access$100.next();
                    if (bl2) {
                        if (this.compareTo((Comparable)entry.getKey(), object) < 0) continue;
                        bl3 = true;
                        break;
                    }
                    if (this.compareTo((Comparable)entry.getKey(), object) <= 0) continue;
                    bl3 = true;
                    break;
                }
                this.currentTimeMillis = n;
            }
            this.getKey = bl3 ? entry : null;
        }

        private MemoryPage QOIV() throws DSException {
            MemoryPage memoryPage = null;
            if (this.QOIV.hasNext()) {
                memoryPage = (MemoryPage)this.QOIV.next();
            }
            if (!memoryPage.isInMemory()) {
                this.this$0.findInMemoryOldestPage().swapToDisk();
                memoryPage.swapToMemory();
                memoryPage.setTimestamp(System.currentTimeMillis());
            }
            return memoryPage;
        }

        public Object getKey() {
            return this.getIterator;
        }

        public void remove() {
            this.access$100.remove();
        }

        public boolean hasNext() {
            if (this.access$100.hasNext()) {
                return this.access$100(this.access$100, this.getIterator);
            }
            if (this.currentTimeMillis < this.compareTo) {
                MemoryPage memoryPage = (MemoryPage)this.this$0.pageTable.get(this.currentTimeMillis + 1);
                try {
                    if (!memoryPage.isInMemory()) {
                        this.this$0.findInMemoryOldestPage().swapToDisk();
                        memoryPage.swapToMemory();
                        memoryPage.setTimestamp(System.currentTimeMillis());
                    }
                }
                catch (DSException dSException) {
                    throw new RuntimeException(dSException.getMessage(), dSException);
                }
                this.access$100 = memoryPage.getIterator();
                ++this.currentTimeMillis;
                return this.access$100(this.access$100, this.getIterator);
            }
            return false;
        }

        private boolean access$100(Iterator iterator, Object object) {
            Object object2 = null;
            int n = -1;
            this.getKey = iterator.next();
            if (this.get) {
                object2 = ((LocalTreeMap.Entry)this.getKey).getKey();
                n = this.compareTo((Comparable)object2, object);
                if (n == 0) {
                    if (this.access$100.hasNext()) {
                        this.getKey = iterator.next();
                        return true;
                    }
                    if (this.currentTimeMillis < this.compareTo) {
                        MemoryPage memoryPage = (MemoryPage)this.this$0.pageTable.get(this.currentTimeMillis + 1);
                        try {
                            if (!memoryPage.isInMemory()) {
                                this.this$0.findInMemoryOldestPage().swapToDisk();
                                memoryPage.swapToMemory();
                                memoryPage.setTimestamp(System.currentTimeMillis());
                            }
                        }
                        catch (DSException dSException) {
                            SortedLocalIndex.access$100(this.this$0).debug(dSException);
                        }
                        this.access$100 = memoryPage.getIterator();
                        ++this.currentTimeMillis;
                        this.getKey = iterator.next();
                        return true;
                    }
                    return false;
                }
                return true;
            }
            if (this.findInMemoryOldestPage) {
                object2 = ((LocalTreeMap.Entry)this.getKey).getKey();
                return this.debug ? this.compareTo((Comparable)object2, object) <= 0 : this.compareTo((Comparable)object2, object) < 0;
            }
            return true;
        }

        private int compareTo(Comparable comparable, Object object) {
            return comparable.compareTo(object);
        }

        public Object next() {
            return this.getKey;
        }
    }
}

